/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.pager;

import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCache;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCallback;
import org.tmatesoft.sqljet.core.internal.SqlJetPageFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPage;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPageCache$PCache;

public class SqlJetPageCache
implements ISqlJetPageCache {
    public static final String SQLJET_PAGE_CACHE_SIZE = "SQLJET.PAGE_CACHE_SIZE";
    public static final int PAGE_CACHE_SIZE_DEFAULT = 2000;
    public static final int PAGE_CACHE_SIZE_MINIMUM = 10;
    private static final int N_SORT_BUCKET = 25;
    SqlJetPage pDirty;
    SqlJetPage pDirtyTail;
    SqlJetPage pSynced;
    int nRef;
    int nMax = 2000;
    int nMin = 10;
    int szPage;
    boolean bPurgeable;
    ISqlJetPageCallback xStress;
    SqlJetPageCache$PCache pCache = new SqlJetPageCache$PCache(this);
    ISqlJetPage pPage1;

    SqlJetPageCache() {
        int n2 = SqlJetUtility.getIntSysProp(SQLJET_PAGE_CACHE_SIZE, this.nMax);
        if (n2 >= this.nMin) {
            this.nMax = n2;
        }
    }

    static void removeFromDirtyList(SqlJetPage sqlJetPage) {
        SqlJetPageCache sqlJetPageCache = sqlJetPage.pCache;
        assert (sqlJetPage.pDirtyNext != null || sqlJetPage == sqlJetPageCache.pDirtyTail);
        assert (sqlJetPage.pDirtyPrev != null || sqlJetPage == sqlJetPageCache.pDirty);
        if (sqlJetPageCache.pSynced == sqlJetPage) {
            SqlJetPage sqlJetPage2 = sqlJetPage.pDirtyPrev;
            while (sqlJetPage2 != null && sqlJetPage2.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                sqlJetPage2 = sqlJetPage2.pDirtyPrev;
            }
            sqlJetPageCache.pSynced = sqlJetPage2;
        }
        if (sqlJetPage.pDirtyNext != null) {
            sqlJetPage.pDirtyNext.pDirtyPrev = sqlJetPage.pDirtyPrev;
        } else {
            assert (sqlJetPage == sqlJetPageCache.pDirtyTail);
            sqlJetPageCache.pDirtyTail = sqlJetPage.pDirtyPrev;
        }
        if (sqlJetPage.pDirtyPrev != null) {
            sqlJetPage.pDirtyPrev.pDirtyNext = sqlJetPage.pDirtyNext;
        } else {
            assert (sqlJetPage == sqlJetPageCache.pDirty);
            sqlJetPageCache.pDirty = sqlJetPage.pDirtyNext;
        }
        sqlJetPage.pDirtyNext = null;
        sqlJetPage.pDirtyPrev = null;
    }

    static void addToDirtyList(SqlJetPage sqlJetPage) {
        SqlJetPageCache sqlJetPageCache = sqlJetPage.pCache;
        assert (sqlJetPage.pDirtyNext == null && sqlJetPage.pDirtyPrev == null && sqlJetPageCache.pDirty != sqlJetPage);
        sqlJetPage.pDirtyNext = sqlJetPageCache.pDirty;
        if (sqlJetPage.pDirtyNext != null) {
            assert (sqlJetPage.pDirtyNext.pDirtyPrev == null);
            sqlJetPage.pDirtyNext.pDirtyPrev = sqlJetPage;
        }
        sqlJetPageCache.pDirty = sqlJetPage;
        if (sqlJetPageCache.pDirtyTail == null) {
            sqlJetPageCache.pDirtyTail = sqlJetPage;
        }
        if (sqlJetPageCache.pSynced == null && !sqlJetPage.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
            sqlJetPageCache.pSynced = sqlJetPage;
        }
    }

    static void unpin(SqlJetPage sqlJetPage) {
        SqlJetPageCache sqlJetPageCache = sqlJetPage.pCache;
        if (sqlJetPageCache.bPurgeable) {
            if (sqlJetPage.pgno == 1) {
                sqlJetPageCache.pPage1 = null;
            }
            if (sqlJetPageCache.pCache != null) {
                sqlJetPageCache.pCache.unpin(sqlJetPage, false);
            }
        }
    }

    public void open(int n2, boolean bl2, ISqlJetPageCallback iSqlJetPageCallback) {
        this.szPage = n2;
        this.bPurgeable = bl2;
        this.xStress = iSqlJetPageCallback;
    }

    public void setPageSize(int n2) {
        assert (this.nRef == 0 && this.pDirty == null);
        if (this.pCache != null) {
            this.pCache.destroy();
            this.pCache = null;
        }
        this.szPage = n2;
    }

    public ISqlJetPage fetch(int n2, boolean bl2) {
        SqlJetPage sqlJetPage = null;
        assert (n2 > 0);
        if (this.pCache == null && bl2) {
            this.pCache = new SqlJetPageCache$PCache(this);
        }
        if (this.pCache != null) {
            sqlJetPage = this.pCache.fetch(n2, bl2);
        }
        if (sqlJetPage == null && bl2) {
            SqlJetPage sqlJetPage2 = this.pSynced;
            while (sqlJetPage2 != null && (sqlJetPage2.nRef > 0 || sqlJetPage2.flags.contains((Object)SqlJetPageFlags.NEED_SYNC))) {
                sqlJetPage2 = sqlJetPage2.pDirtyPrev;
            }
            if (sqlJetPage2 == null) {
                sqlJetPage2 = this.pDirtyTail;
                while (sqlJetPage2 != null && sqlJetPage2.nRef > 0) {
                    sqlJetPage2 = sqlJetPage2.pDirtyPrev;
                }
            }
            if (sqlJetPage2 != null) {
                this.xStress.pageCallback(sqlJetPage2);
            }
            this.pCache.cleanUnpinned();
            sqlJetPage = this.pCache.fetch(n2, true);
        }
        if (sqlJetPage != null) {
            if (0 == sqlJetPage.nRef) {
                ++this.nRef;
            }
            ++sqlJetPage.nRef;
            if (null == sqlJetPage.pData) {
                sqlJetPage.pData = SqlJetUtility.allocatePtr(this.szPage, SqlJetPage.BUFFER_TYPE);
            }
            sqlJetPage.pCache = this;
            sqlJetPage.pgno = n2;
            if (n2 == 1) {
                this.pPage1 = sqlJetPage;
            }
        }
        return sqlJetPage;
    }

    public void release(ISqlJetPage iSqlJetPage) {
        SqlJetPage sqlJetPage = (SqlJetPage)iSqlJetPage;
        assert (sqlJetPage.nRef > 0);
        --sqlJetPage.nRef;
        if (sqlJetPage.nRef == 0) {
            SqlJetPageCache sqlJetPageCache = sqlJetPage.pCache;
            --sqlJetPageCache.nRef;
            if (!sqlJetPage.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
                SqlJetPageCache.unpin(sqlJetPage);
            } else {
                SqlJetPageCache.removeFromDirtyList(sqlJetPage);
                SqlJetPageCache.addToDirtyList(sqlJetPage);
            }
        }
    }

    public void drop(ISqlJetPage iSqlJetPage) {
        SqlJetPage sqlJetPage = (SqlJetPage)iSqlJetPage;
        assert (sqlJetPage.nRef >= 1);
        if (sqlJetPage.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
            SqlJetPageCache.removeFromDirtyList(sqlJetPage);
        }
        --this.nRef;
        if (sqlJetPage.pgno == 1) {
            this.pPage1 = null;
        }
        this.pCache.unpin(sqlJetPage, true);
    }

    public void makeDirty(ISqlJetPage iSqlJetPage) {
        SqlJetPage sqlJetPage = (SqlJetPage)iSqlJetPage;
        sqlJetPage.flags.remove((Object)SqlJetPageFlags.DONT_WRITE);
        assert (sqlJetPage.nRef > 0);
        if (!sqlJetPage.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
            sqlJetPage.flags.add(SqlJetPageFlags.DIRTY);
            SqlJetPageCache.addToDirtyList(sqlJetPage);
        }
    }

    public void makeClean(ISqlJetPage iSqlJetPage) {
        SqlJetPage sqlJetPage = (SqlJetPage)iSqlJetPage;
        if (sqlJetPage.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
            SqlJetPageCache.removeFromDirtyList(sqlJetPage);
            sqlJetPage.flags.remove((Object)SqlJetPageFlags.DIRTY);
            sqlJetPage.flags.remove((Object)SqlJetPageFlags.NEED_SYNC);
            if (sqlJetPage.nRef == 0) {
                SqlJetPageCache.unpin(sqlJetPage);
            }
        }
    }

    public void cleanAll() {
        SqlJetPage sqlJetPage;
        while ((sqlJetPage = this.pDirty) != null) {
            this.makeClean(sqlJetPage);
        }
    }

    public void clearSyncFlags() {
        SqlJetPage sqlJetPage = this.pDirty;
        while (sqlJetPage != null) {
            sqlJetPage.flags.remove((Object)SqlJetPageFlags.NEED_SYNC);
            sqlJetPage = sqlJetPage.pDirtyNext;
        }
        this.pSynced = this.pDirtyTail;
    }

    public void move(ISqlJetPage iSqlJetPage, int n2) {
        SqlJetPage sqlJetPage = (SqlJetPage)iSqlJetPage;
        assert (sqlJetPage.nRef > 0);
        assert (n2 > 0);
        this.pCache.rekey(sqlJetPage, sqlJetPage.pgno, n2);
        sqlJetPage.pgno = n2;
        if (sqlJetPage.flags.contains((Object)SqlJetPageFlags.DIRTY) && sqlJetPage.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
            SqlJetPageCache.removeFromDirtyList(sqlJetPage);
            SqlJetPageCache.addToDirtyList(sqlJetPage);
        }
    }

    public void truncate(int n2) {
        if (this.pCache != null) {
            SqlJetPage sqlJetPage = this.pDirty;
            while (sqlJetPage != null) {
                SqlJetPage sqlJetPage2 = sqlJetPage.pDirtyNext;
                if (sqlJetPage.pgno > n2) {
                    assert (sqlJetPage.flags.contains((Object)SqlJetPageFlags.DIRTY));
                    this.makeClean(sqlJetPage);
                }
                sqlJetPage = sqlJetPage2;
            }
            if (n2 == 0 && this.pPage1 != null) {
                SqlJetUtility.memset(this.pPage1.getData(), (byte)0, this.szPage);
                n2 = 1;
            }
            this.pCache.truncate(n2 + 1);
        }
    }

    public void close() {
        if (this.pCache != null) {
            this.pCache.destroy();
        }
    }

    public void clear() {
        this.truncate(0);
    }

    static SqlJetPage mergeDirtyList(SqlJetPage sqlJetPage, SqlJetPage sqlJetPage2) {
        SqlJetPage sqlJetPage3;
        SqlJetPage sqlJetPage4 = sqlJetPage3 = new SqlJetPage();
        while (sqlJetPage != null && sqlJetPage2 != null) {
            if (sqlJetPage.pgno < sqlJetPage2.pgno) {
                sqlJetPage4.pDirty = sqlJetPage;
                sqlJetPage4 = sqlJetPage;
                sqlJetPage = sqlJetPage.pDirty;
                continue;
            }
            sqlJetPage4.pDirty = sqlJetPage2;
            sqlJetPage4 = sqlJetPage2;
            sqlJetPage2 = sqlJetPage2.pDirty;
        }
        sqlJetPage4.pDirty = sqlJetPage != null ? sqlJetPage : (sqlJetPage2 != null ? sqlJetPage2 : null);
        return sqlJetPage3.pDirty;
    }

    static SqlJetPage sortDirtyList(SqlJetPage sqlJetPage) {
        int n2;
        SqlJetPage sqlJetPage2;
        SqlJetPage[] sqlJetPageArray = new SqlJetPage[25];
        while (sqlJetPage != null) {
            sqlJetPage2 = sqlJetPage;
            sqlJetPage = sqlJetPage2.pDirty;
            sqlJetPage2.pDirty = null;
            for (n2 = 0; n2 < 24; ++n2) {
                if (sqlJetPageArray[n2] == null) {
                    sqlJetPageArray[n2] = sqlJetPage2;
                    break;
                }
                sqlJetPage2 = SqlJetPageCache.mergeDirtyList(sqlJetPageArray[n2], sqlJetPage2);
                sqlJetPageArray[n2] = null;
            }
            if (n2 != 24) continue;
            sqlJetPageArray[n2] = SqlJetPageCache.mergeDirtyList(sqlJetPageArray[n2], sqlJetPage2);
        }
        sqlJetPage2 = sqlJetPageArray[0];
        for (n2 = 1; n2 < 25; ++n2) {
            sqlJetPage2 = SqlJetPageCache.mergeDirtyList(sqlJetPage2, sqlJetPageArray[n2]);
        }
        return sqlJetPage2;
    }

    public ISqlJetPage getDirtyList() {
        SqlJetPage sqlJetPage = this.pDirty;
        while (sqlJetPage != null) {
            sqlJetPage.pDirty = sqlJetPage.pDirtyNext;
            sqlJetPage = sqlJetPage.pDirtyNext;
        }
        return SqlJetPageCache.sortDirtyList(this.pDirty);
    }

    public int getRefCount() {
        return this.nRef;
    }

    public int getPageCount() {
        int n2 = 0;
        if (this.pCache != null) {
            n2 = this.pCache.getPageCount();
        }
        return n2;
    }

    public int getCachesize() {
        return this.nMax;
    }

    public void setCacheSize(int n2) {
        this.nMax = n2;
    }

    public void iterate(ISqlJetPageCallback iSqlJetPageCallback) {
        SqlJetPage sqlJetPage = this.pDirty;
        while (sqlJetPage != null) {
            iSqlJetPageCallback.pageCallback(sqlJetPage);
            sqlJetPage = sqlJetPage.pDirtyNext;
        }
    }
}

