/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.pager;

import java.util.BitSet;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetMemoryBufferType;
import org.tmatesoft.sqljet.core.internal.SqlJetPageFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPageCache;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPager;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPagerState;

public class SqlJetPage
implements ISqlJetPage {
    public static final SqlJetMemoryBufferType BUFFER_TYPE = (SqlJetMemoryBufferType)SqlJetUtility.getEnumSysProp("SqlJetPage.BUFFER_TYPE", SqlJetMemoryBufferType.ARRAY);
    ISqlJetMemoryPointer pData;
    Object pExtra;
    SqlJetPage pDirty;
    int pgno;
    SqlJetPager pPager;
    long pageHash;
    Set flags = SqlJetUtility.noneOf(SqlJetPageFlags.class);
    int nRef;
    SqlJetPageCache pCache;
    SqlJetPage pDirtyNext;
    SqlJetPage pDirtyPrev;

    public SqlJetPage() {
    }

    SqlJetPage(int n2) {
        this.pData = SqlJetUtility.allocatePtr(n2, BUFFER_TYPE);
    }

    public void dontRollback() {
        assert (this.pPager.state.compareTo(SqlJetPagerState.RESERVED) >= 0);
        if (!this.pPager.journalOpen || SqlJetUtility.bitSetTest(this.pPager.pagesAlwaysRollback, this.pgno) || this.pgno > this.pPager.dbOrigSize) {
            return;
        }
        if (SqlJetUtility.bitSetTest(this.pPager.pagesInJournal, this.pgno) || this.pgno > this.pPager.dbOrigSize) {
            return;
        }
        assert (this.pPager.pagesInJournal != null);
        this.flags.remove((Object)SqlJetPageFlags.NEED_READ);
        this.pPager.pagesInJournal.set(this.pgno);
        this.pPager.addToSavepointBitSets(this.pgno);
        SqlJetPager.PAGERTRACE("DONT_ROLLBACK page %d of %s\n", this.pgno, this.pPager.PAGERID());
    }

    public void dontWrite() {
        if (this.pgno > this.pPager.dbOrigSize) {
            return;
        }
        if (this.pPager.pagesAlwaysRollback == null) {
            assert (this.pPager.pagesInJournal != null);
            this.pPager.pagesAlwaysRollback = new BitSet(this.pPager.dbOrigSize);
        }
        this.pPager.pagesAlwaysRollback.set(this.pgno);
        if (this.flags.contains((Object)SqlJetPageFlags.DIRTY) && this.pPager.nSavepoint == 0) {
            assert (this.pPager.state.compareTo(SqlJetPagerState.SHARED) >= 0);
            if (this.pPager.dbSize != this.pgno || this.pPager.dbOrigSize >= this.pPager.dbSize) {
                SqlJetPager.PAGERTRACE("DONT_WRITE page %d of %s\n", this.pgno, this.pPager.PAGERID());
                this.flags.add(SqlJetPageFlags.DONT_WRITE);
                this.pageHash = this.pPager.pageHash(this);
            }
        }
    }

    public ISqlJetMemoryPointer getData() {
        return this.pData;
    }

    public Object getExtra() {
        return this.pPager != null ? this.pExtra : null;
    }

    public void setExtra(Object object) {
        this.pExtra = object;
    }

    public void move(int n2, boolean bl2) {
        int n3 = 0;
        assert (this.nRef > 0);
        if (this.flags.contains((Object)SqlJetPageFlags.DIRTY) && SqlJetPager.subjRequiresPage(this)) {
            this.pPager.subjournalPage(this);
        }
        SqlJetPager.PAGERTRACE("MOVE %s page %d (needSync=%b) moves to %d\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC), n2);
        this.pPager.getContent(this);
        if (this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC) && !bl2) {
            n3 = this.pgno;
            assert (SqlJetPager.pageInJournal(this) || this.pgno > this.pPager.dbOrigSize);
            assert (this.flags.contains((Object)SqlJetPageFlags.DIRTY));
            assert (this.pPager.needSync);
        }
        this.flags.remove((Object)SqlJetPageFlags.NEED_SYNC);
        SqlJetPage sqlJetPage = (SqlJetPage)this.pPager.lookup(n2);
        assert (sqlJetPage == null || sqlJetPage.nRef >= 1);
        if (sqlJetPage != null && sqlJetPage.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
            this.flags.add(SqlJetPageFlags.NEED_SYNC);
        }
        if (sqlJetPage != null) {
            this.pPager.pageCache.drop(sqlJetPage);
        }
        this.pPager.pageCache.move(this, n2);
        this.pPager.pageCache.makeDirty(this);
        this.pPager.dirtyCache = true;
        this.pPager.dbModified = true;
        if (n3 != 0) {
            SqlJetPage sqlJetPage2;
            assert (this.pPager.needSync);
            try {
                sqlJetPage2 = (SqlJetPage)this.pPager.getPage(n3);
            }
            catch (SqlJetException sqlJetException) {
                if (this.pPager.pagesInJournal != null && n3 <= this.pPager.dbOrigSize) {
                    this.pPager.pagesInJournal.clear(n3);
                }
                throw sqlJetException;
            }
            this.pPager.needSync = true;
            assert (!this.pPager.noSync && !this.pPager.memDb);
            sqlJetPage2.flags.add(SqlJetPageFlags.NEED_SYNC);
            this.pPager.pageCache.makeDirty(sqlJetPage2);
            sqlJetPage2.unref();
        }
    }

    public void ref() {
        assert (this.nRef > 0);
        ++this.nRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unref() {
        try {
            this.pPager.pageCache.release(this);
            Object var2_1 = null;
            this.pPager.unlockIfUnused();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.pPager.unlockIfUnused();
            throw throwable;
        }
    }

    public void write() {
        int n2 = this.pPager.sectorSize / this.pPager.pageSize;
        if (n2 > 1) {
            int n3;
            boolean bl2 = false;
            assert (!this.pPager.memDb);
            assert (!this.pPager.doNotSync);
            this.pPager.doNotSync = true;
            int n4 = (this.pgno - 1 & ~(n2 - 1)) + 1;
            int n5 = this.pPager.getPageCount();
            int n6 = this.pgno > n5 ? this.pgno - n4 + 1 : (n4 + n2 - 1 > n5 ? n5 + 1 - n4 : n2);
            assert (n6 > 0);
            assert (n4 <= this.pgno);
            assert (n4 + n6 > this.pgno);
            for (n3 = 0; n3 < n6; ++n3) {
                SqlJetPage sqlJetPage;
                int n7 = n4 + n3;
                if (n7 == this.pgno || !SqlJetUtility.bitSetTest(this.pPager.pagesInJournal, n7)) {
                    if ((long)n7 == this.pPager.PAGER_MJ_PGNO()) continue;
                    sqlJetPage = (SqlJetPage)this.pPager.getPage(n7);
                    sqlJetPage.doWrite();
                    if (sqlJetPage.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                        bl2 = true;
                    }
                    sqlJetPage.unref();
                    continue;
                }
                sqlJetPage = (SqlJetPage)this.pPager.lookup(n7);
                if (sqlJetPage == null) continue;
                if (sqlJetPage.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                    bl2 = true;
                    assert (this.pPager.needSync);
                }
                sqlJetPage.unref();
            }
            if (bl2) {
                assert (!this.pPager.memDb && !this.pPager.noSync);
                for (n3 = 0; n3 < n6 && bl2; ++n3) {
                    SqlJetPage sqlJetPage = (SqlJetPage)this.pPager.lookup(n4 + n3);
                    if (sqlJetPage == null) continue;
                    sqlJetPage.flags.add(SqlJetPageFlags.NEED_SYNC);
                    sqlJetPage.unref();
                }
                assert (this.pPager.needSync);
            }
            assert (this.pPager.doNotSync);
            this.pPager.doNotSync = false;
        } else {
            this.doWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite() {
        block22: {
            block23: {
                block24: {
                    block21: {
                        if (this.pPager.errCode != null) {
                            throw new SqlJetException(this.pPager.errCode);
                        }
                        if (this.pPager.readOnly) {
                            throw new SqlJetException(SqlJetErrorCode.PERM);
                        }
                        assert (!this.pPager.setMaster);
                        this.pPager.getContent(this);
                        this.pCache.makeDirty(this);
                        if (!SqlJetPager.pageInJournal(this) || SqlJetPager.subjRequiresPage(this)) break block21;
                        this.pPager.dirtyCache = true;
                        this.pPager.dbModified = true;
                        break block22;
                    }
                    assert (this.pPager.state != SqlJetPagerState.UNLOCK);
                    this.pPager.begin(false);
                    assert (this.pPager.state.compareTo(SqlJetPagerState.RESERVED) >= 0);
                    if (!this.pPager.journalOpen && this.pPager.useJournal && this.pPager.journalMode != SqlJetPagerJournalMode.OFF) {
                        this.pPager.openJournal();
                    }
                    this.pPager.dirtyCache = true;
                    this.pPager.dbModified = true;
                    if (SqlJetPager.pageInJournal(this) || !this.pPager.journalOpen) break block23;
                    if (this.pgno > this.pPager.dbOrigSize) break block24;
                    assert ((long)this.pgno != this.pPager.PAGER_MJ_PGNO());
                    try {
                        long l2 = this.pPager.cksum(this.pData);
                        SqlJetPager.write32bits(this.pPager.jfd, this.pPager.journalOff, this.pgno);
                        try {
                            this.pPager.jfd.write(this.pData, this.pPager.pageSize, this.pPager.journalOff + 4L);
                            Object var4_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_3 = null;
                            this.pPager.journalOff += (long)(this.pPager.pageSize + 4);
                            throw throwable;
                        }
                        this.pPager.journalOff += (long)(this.pPager.pageSize + 4);
                        {
                        }
                        try {
                            SqlJetPager.write32bitsUnsigned(this.pPager.jfd, this.pPager.journalOff, l2);
                            Object var6_5 = null;
                            this.pPager.journalOff += 4L;
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            this.pPager.journalOff += 4L;
                            throw throwable;
                        }
                        Object var8_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        SqlJetPager.PAGERTRACE("JOURNAL %s page %d needSync=%b hash(%08x)\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC), this.pPager.pageHash(this));
                        if (!this.pPager.noSync) {
                            this.flags.add(SqlJetPageFlags.NEED_SYNC);
                            this.pPager.needSync = true;
                        }
                        throw throwable;
                    }
                    SqlJetPager.PAGERTRACE("JOURNAL %s page %d needSync=%b hash(%08x)\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC), this.pPager.pageHash(this));
                    if (!this.pPager.noSync) {
                        this.flags.add(SqlJetPageFlags.NEED_SYNC);
                        this.pPager.needSync = true;
                    }
                    ++this.pPager.nRec;
                    assert (this.pPager.pagesInJournal != null);
                    this.pPager.pagesInJournal.set(this.pgno);
                    this.pPager.addToSavepointBitSets(this.pgno);
                    break block23;
                }
                if (!this.pPager.journalStarted && !this.pPager.noSync) {
                    this.flags.add(SqlJetPageFlags.NEED_SYNC);
                    this.pPager.needSync = true;
                }
                SqlJetPager.PAGERTRACE("APPEND %s page %d needSync=%b\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC));
            }
            if (SqlJetPager.subjRequiresPage(this)) {
                this.pPager.subjournalPage(this);
            }
        }
        assert (this.pPager.state.compareTo(SqlJetPagerState.SHARED) >= 0);
        if (this.pPager.dbSize < this.pgno) {
            this.pPager.dbSize = this.pgno;
            if ((long)this.pPager.dbSize == this.pPager.PAGER_MJ_PGNO() - 1L) {
                ++this.pPager.dbSize;
            }
        }
    }

    public Set getFlags() {
        return this.flags;
    }

    public long getHash() {
        return this.pageHash;
    }

    public ISqlJetPager getPager() {
        return this.pPager;
    }

    public void setFlags(Set set) {
        this.flags = set;
    }

    public void setHash(long l2) {
        this.pageHash = l2;
    }

    public void setPager(ISqlJetPager iSqlJetPager) {
        this.pPager = (SqlJetPager)iSqlJetPager;
    }

    public int getPageNumber() {
        return this.pgno;
    }

    public void setPageNumber(int n2) {
        this.pgno = n2;
    }

    public ISqlJetPage getNext() {
        return this.pDirtyNext;
    }

    public ISqlJetPage getPrev() {
        return this.pDirtyPrev;
    }

    public int getRefCount() {
        return this.nRef;
    }

    public boolean isWriteable() {
        return this.flags.contains((Object)SqlJetPageFlags.DIRTY);
    }

    public ISqlJetPage getDirty() {
        return this.pDirty;
    }
}

