/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import java.io.RandomAccessFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;

public final class SqlJetMemoryPointer
implements ISqlJetMemoryPointer {
    private ISqlJetMemoryBuffer buffer;
    private int pointer;
    private int limit;

    public SqlJetMemoryPointer(ISqlJetMemoryBuffer iSqlJetMemoryBuffer, int n2) {
        assert (iSqlJetMemoryBuffer != null);
        assert (iSqlJetMemoryBuffer.isAllocated());
        assert (n2 >= 0);
        assert (n2 <= iSqlJetMemoryBuffer.getSize());
        this.buffer = iSqlJetMemoryBuffer;
        this.pointer = n2;
        this.limit = iSqlJetMemoryBuffer.getSize();
    }

    public SqlJetMemoryPointer(ISqlJetMemoryBuffer iSqlJetMemoryBuffer, int n2, int n3) {
        assert (iSqlJetMemoryBuffer != null);
        assert (iSqlJetMemoryBuffer.isAllocated());
        assert (n2 >= 0);
        assert (n2 <= iSqlJetMemoryBuffer.getSize());
        this.buffer = iSqlJetMemoryBuffer;
        this.pointer = n2;
        this.limit = n3;
    }

    public final ISqlJetMemoryBuffer getBuffer() {
        return this.buffer;
    }

    public final int getPointer() {
        return this.pointer;
    }

    public final void setPointer(int n2) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.pointer = n2;
    }

    public final void movePointer(int n2) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        assert (this.pointer + n2 >= 0);
        assert (this.pointer + n2 <= this.buffer.getSize());
        this.pointer += n2;
    }

    public final byte getByte() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getByte(this.pointer);
    }

    public final int getInt() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getInt(this.pointer);
    }

    public final long getLong() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getLong(this.pointer);
    }

    public final short getShort() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getShort(this.pointer);
    }

    public final int getByteUnsigned() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getByteUnsigned(this.pointer);
    }

    public final long getIntUnsigned() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getIntUnsigned(this.pointer);
    }

    public final int getShortUnsigned() {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        return this.buffer.getShortUnsigned(this.pointer);
    }

    public final void putByte(byte by) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putByte(this.pointer, by);
    }

    public final void putInt(int n2) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putInt(this.pointer, n2);
    }

    public final void putLong(long l2) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putLong(this.pointer, l2);
    }

    public final void putShort(short s2) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putShort(this.pointer, s2);
    }

    public final void putByteUnsigned(int n2) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putByteUnsigned(this.pointer, n2);
    }

    public final void putIntUnsigned(long l2) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putIntUnsigned(this.pointer, l2);
    }

    public final void putShortUnsigned(int n2) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        this.buffer.putShortUnsigned(this.pointer, n2);
    }

    public final int readFromFile(RandomAccessFile randomAccessFile, long l2, int n2) {
        assert (this.buffer != null);
        assert (this.buffer.isAllocated());
        assert (randomAccessFile != null);
        assert (l2 >= 0L);
        assert (n2 > 0);
        assert (this.pointer + n2 <= this.buffer.getSize());
        return this.buffer.readFromFile(this.pointer, randomAccessFile, l2, n2);
    }

    public final int writeToFile(RandomAccessFile randomAccessFile, long l2, int n2) {
        assert (this.buffer != null);
        assert (randomAccessFile != null);
        assert (l2 >= 0L);
        assert (n2 > 0);
        assert (this.pointer + n2 <= this.buffer.getSize());
        return this.buffer.writeToFile(this.pointer, randomAccessFile, l2, n2);
    }

    public final int getAbsolute(int n2) {
        return this.pointer + n2;
    }

    public final byte getByte(int n2) {
        return this.buffer.getByte(this.getAbsolute(n2));
    }

    public final int getByteUnsigned(int n2) {
        return this.buffer.getByteUnsigned(this.getAbsolute(n2));
    }

    public final int getInt(int n2) {
        return this.buffer.getInt(this.getAbsolute(n2));
    }

    public final long getIntUnsigned(int n2) {
        return this.buffer.getIntUnsigned(this.getAbsolute(n2));
    }

    public final long getLong(int n2) {
        return this.buffer.getLong(this.getAbsolute(n2));
    }

    public final short getShort(int n2) {
        return this.buffer.getShort(this.getAbsolute(n2));
    }

    public final int getShortUnsigned(int n2) {
        return this.buffer.getShortUnsigned(this.getAbsolute(n2));
    }

    public final void putByte(int n2, byte by) {
        this.buffer.putByte(this.getAbsolute(n2), by);
    }

    public final void putByteUnsigned(int n2, int n3) {
        this.buffer.putByteUnsigned(this.getAbsolute(n2), n3);
    }

    public final void putInt(int n2, int n3) {
        this.buffer.putInt(this.getAbsolute(n2), n3);
    }

    public final void putIntUnsigned(int n2, long l2) {
        this.buffer.putIntUnsigned(this.getAbsolute(n2), l2);
    }

    public final void putLong(int n2, long l2) {
        this.buffer.putLong(this.getAbsolute(n2), l2);
    }

    public final void putShort(int n2, short s2) {
        this.buffer.putShort(this.getAbsolute(n2), s2);
    }

    public final void putShortUnsigned(int n2, int n3) {
        this.buffer.putShortUnsigned(this.getAbsolute(n2), n3);
    }

    public final int readFromFile(int n2, RandomAccessFile randomAccessFile, long l2, int n3) {
        return this.buffer.readFromFile(this.getAbsolute(n2), randomAccessFile, l2, n3);
    }

    public final int writeToFile(int n2, RandomAccessFile randomAccessFile, long l2, int n3) {
        return this.buffer.writeToFile(this.getAbsolute(n2), randomAccessFile, l2, n3);
    }

    public final int remaining() {
        return this.limit - this.pointer;
    }

    public final void copyFrom(int n2, ISqlJetMemoryPointer iSqlJetMemoryPointer, int n3, int n4) {
        this.buffer.copyFrom(this.getAbsolute(n2), iSqlJetMemoryPointer.getBuffer(), iSqlJetMemoryPointer.getAbsolute(n3), n4);
    }

    public final void copyFrom(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, int n3) {
        this.buffer.copyFrom(this.pointer, iSqlJetMemoryPointer.getBuffer(), iSqlJetMemoryPointer.getAbsolute(n2), n3);
    }

    public final void copyFrom(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        this.buffer.copyFrom(this.pointer, iSqlJetMemoryPointer.getBuffer(), iSqlJetMemoryPointer.getPointer(), n2);
    }

    public final void fill(int n2, byte by) {
        this.buffer.fill(this.pointer, n2, by);
    }

    public final void fill(int n2, int n3, byte by) {
        this.buffer.fill(this.getAbsolute(n2), n3, by);
    }

    public final void getBytes(byte[] byArray) {
        this.buffer.getBytes(this.pointer, byArray, 0, byArray.length);
    }

    public final void getBytes(int n2, byte[] byArray) {
        this.buffer.getBytes(this.getAbsolute(n2), byArray, 0, byArray.length);
    }

    public final void getBytes(int n2, byte[] byArray, int n3) {
        this.buffer.getBytes(this.getAbsolute(n2), byArray, 0, n3);
    }

    public final void getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.buffer.getBytes(this.getAbsolute(n2), byArray, n3, n4);
    }

    public final void putBytes(byte[] byArray) {
        this.buffer.putBytes(this.pointer, byArray, 0, byArray.length);
    }

    public final void putBytes(int n2, byte[] byArray) {
        this.buffer.putBytes(this.getAbsolute(n2), byArray, 0, byArray.length);
    }

    public final void putBytes(int n2, byte[] byArray, int n3) {
        this.buffer.putBytes(this.getAbsolute(n2), byArray, 0, n3);
    }

    public final void putBytes(int n2, byte[] byArray, int n3, int n4) {
        this.buffer.putBytes(this.getAbsolute(n2), byArray, n3, n4);
    }

    public final int compareTo(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        return this.buffer.compareTo(this.pointer, iSqlJetMemoryPointer.getBuffer(), iSqlJetMemoryPointer.getPointer());
    }

    public final void limit(int n2) {
        this.limit = n2;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final ISqlJetMemoryPointer getIdentic() {
        return new SqlJetMemoryPointer(this.buffer, this.pointer);
    }

    public ISqlJetMemoryPointer getMoved(int n2) {
        return new SqlJetMemoryPointer(this.buffer, this.pointer + n2, this.limit);
    }
}

