/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryManager;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetMemoryBufferType;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetByteArrayBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetByteBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetDirectByteBuffer;

public class SqlJetMemoryManager
implements ISqlJetMemoryManager {
    private SqlJetMemoryBufferType defaultBufferType = (SqlJetMemoryBufferType)SqlJetUtility.getEnumSysProp("SqlJetMemoryManager.defaultBufferType", SqlJetMemoryBufferType.ARRAY);

    public SqlJetMemoryBufferType getDefaultBufferType() {
        return this.defaultBufferType;
    }

    public void setDefaultBufferType(SqlJetMemoryBufferType sqlJetMemoryBufferType) {
        if (sqlJetMemoryBufferType != null) {
            this.defaultBufferType = sqlJetMemoryBufferType;
        }
    }

    public ISqlJetMemoryPointer allocatePtr(int n2) {
        return this.allocate(n2).getPointer(0);
    }

    public ISqlJetMemoryPointer allocatePtr(int n2, SqlJetMemoryBufferType sqlJetMemoryBufferType) {
        return this.allocate(n2, sqlJetMemoryBufferType).getPointer(0);
    }

    public ISqlJetMemoryBuffer allocate(int n2) {
        return this.allocate(n2, this.defaultBufferType);
    }

    public ISqlJetMemoryBuffer allocate(int n2, SqlJetMemoryBufferType sqlJetMemoryBufferType) {
        if (n2 >= 0) {
            ISqlJetMemoryBuffer iSqlJetMemoryBuffer;
            switch (sqlJetMemoryBufferType) {
                case ARRAY: {
                    iSqlJetMemoryBuffer = new SqlJetByteArrayBuffer();
                    break;
                }
                case BUFFER: {
                    iSqlJetMemoryBuffer = new SqlJetByteBuffer();
                    break;
                }
                case DIRECT: {
                    iSqlJetMemoryBuffer = new SqlJetDirectByteBuffer();
                    break;
                }
                default: {
                    iSqlJetMemoryBuffer = new SqlJetByteArrayBuffer();
                }
            }
            iSqlJetMemoryBuffer.allocate(n2);
            return iSqlJetMemoryBuffer;
        }
        return null;
    }

    public void free(ISqlJetMemoryBuffer iSqlJetMemoryBuffer) {
        if (iSqlJetMemoryBuffer != null) {
            iSqlJetMemoryBuffer.free();
        }
    }
}

