/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetBytesUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetDirectByteBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryPointer;

public class SqlJetByteBuffer
implements ISqlJetMemoryBuffer {
    protected ByteBuffer buffer;

    public SqlJetByteBuffer() {
    }

    public SqlJetByteBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public void allocate(int n2) {
        assert (n2 >= 0);
        this.buffer = ByteBuffer.allocate(n2);
    }

    public void free() {
        assert (this.buffer != null);
        this.buffer = null;
    }

    public boolean isAllocated() {
        return this.buffer != null;
    }

    public int getSize() {
        assert (this.buffer != null);
        return this.buffer.capacity();
    }

    public ISqlJetMemoryPointer getPointer(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity());
        return new SqlJetMemoryPointer(this, n2);
    }

    public byte getByte(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.capacity());
        return this.buffer.get(n2);
    }

    public int getByteUnsigned(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.capacity());
        return SqlJetBytesUtility.toUnsignedByte(this.getByte(n2));
    }

    public int getInt(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity() - 4);
        return this.buffer.getInt(n2);
    }

    public long getIntUnsigned(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity() - 4);
        return SqlJetBytesUtility.toUnsignedInt(this.getInt(n2));
    }

    public long getLong(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity() - 8);
        return this.buffer.getLong(n2);
    }

    public short getShort(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity() - 2);
        return this.buffer.getShort(n2);
    }

    public int getShortUnsigned(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity() - 2);
        return SqlJetBytesUtility.toUnsignedShort(this.getShort(n2));
    }

    public void putByte(int n2, byte by) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.capacity());
        this.buffer.put(n2, by);
    }

    public void putByteUnsigned(int n2, int n3) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.capacity());
        this.putByte(n2, (byte)SqlJetBytesUtility.toUnsignedByte(n3));
    }

    public void putInt(int n2, int n3) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity() - 4);
        this.buffer.putInt(n2, n3);
    }

    public void putIntUnsigned(int n2, long l2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity() - 4);
        this.putInt(n2, (int)SqlJetBytesUtility.toUnsignedInt(l2));
    }

    public void putLong(int n2, long l2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity() - 8);
        this.buffer.putLong(n2, l2);
    }

    public void putShort(int n2, short s2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity() - 2);
        this.buffer.putShort(n2, s2);
    }

    public void putShortUnsigned(int n2, int n3) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.capacity() - 2);
        this.putShort(n2, (short)SqlJetBytesUtility.toUnsignedShort(n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFromFile(int n2, RandomAccessFile randomAccessFile, long l2, int n3) {
        int n4;
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.capacity());
        assert (randomAccessFile != null);
        assert (l2 >= 0L);
        assert (n3 > 0);
        this.buffer.limit(n2 + n3).position(n2);
        try {
            n4 = randomAccessFile.getChannel().read(this.buffer, l2);
            Object var8_6 = null;
            this.buffer.clear();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.buffer.clear();
            throw throwable;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeToFile(int n2, RandomAccessFile randomAccessFile, long l2, int n3) {
        int n4;
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.capacity());
        assert (randomAccessFile != null);
        assert (l2 >= 0L);
        assert (n3 > 0);
        this.buffer.limit(n2 + n3).position(n2);
        try {
            n4 = randomAccessFile.getChannel().write(this.buffer, l2);
            Object var8_6 = null;
            this.buffer.clear();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.buffer.clear();
            throw throwable;
        }
        return n4;
    }

    public byte[] asArray() {
        return this.buffer.array();
    }

    public void copyFrom(int n2, ISqlJetMemoryBuffer iSqlJetMemoryBuffer, int n3, int n4) {
        if (iSqlJetMemoryBuffer instanceof SqlJetByteBuffer && !(iSqlJetMemoryBuffer instanceof SqlJetDirectByteBuffer)) {
            SqlJetByteBuffer sqlJetByteBuffer = (SqlJetByteBuffer)iSqlJetMemoryBuffer;
            System.arraycopy(sqlJetByteBuffer.buffer.array(), n3, this.buffer.array(), n2, n4);
        } else {
            byte[] byArray = new byte[n4];
            iSqlJetMemoryBuffer.getBytes(n3, byArray, 0, n4);
            this.putBytes(n2, byArray, 0, n4);
        }
    }

    public void fill(int n2, int n3, byte by) {
        Arrays.fill(this.buffer.array(), n2, n2 + n3, by);
    }

    public void getBytes(int n2, byte[] byArray, int n3, int n4) {
        System.arraycopy(this.buffer.array(), n2, byArray, n3, n4);
    }

    public void putBytes(int n2, byte[] byArray, int n3, int n4) {
        System.arraycopy(byArray, n3, this.buffer.array(), n2, n4);
    }

    public int compareTo(int n2, ISqlJetMemoryBuffer iSqlJetMemoryBuffer, int n3) {
        int n4;
        int n5 = this.getSize() - n2;
        if (n5 != (n4 = iSqlJetMemoryBuffer.getSize() - n3)) {
            if (n5 > n4) {
                return 1;
            }
            return -1;
        }
        if (iSqlJetMemoryBuffer instanceof SqlJetByteBuffer && !(iSqlJetMemoryBuffer instanceof SqlJetDirectByteBuffer)) {
            SqlJetByteBuffer sqlJetByteBuffer = (SqlJetByteBuffer)iSqlJetMemoryBuffer;
            return SqlJetUtility.memcmp(this.buffer.array(), n2, sqlJetByteBuffer.buffer.array(), n3, n5);
        }
        byte[] byArray = new byte[n5];
        iSqlJetMemoryBuffer.getBytes(n3, byArray, 0, n5);
        return SqlJetUtility.memcmp(this.buffer.array(), n2, byArray, n3, n5);
    }
}

