/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import java.io.RandomAccessFile;
import java.util.Arrays;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetBytesUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryPointer;

public class SqlJetByteArrayBuffer
implements ISqlJetMemoryBuffer {
    private byte[] buffer;

    public void allocate(int n2) {
        assert (n2 >= 0);
        this.buffer = new byte[n2];
    }

    public void free() {
        assert (this.buffer != null);
        this.buffer = null;
    }

    public boolean isAllocated() {
        return this.buffer != null;
    }

    public int getSize() {
        assert (this.buffer != null);
        return this.buffer.length;
    }

    public ISqlJetMemoryPointer getPointer(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length);
        return new SqlJetMemoryPointer(this, n2);
    }

    public byte getByte(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.length);
        return this.buffer[n2];
    }

    public int getInt(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length - 4);
        return SqlJetBytesUtility.getInt(this.buffer, n2);
    }

    public long getLong(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length - 8);
        return SqlJetBytesUtility.getLong(this.buffer, n2);
    }

    public short getShort(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length - 2);
        return SqlJetBytesUtility.getShort(this.buffer, n2);
    }

    public int getByteUnsigned(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.length);
        return SqlJetBytesUtility.toUnsignedByte(this.getByte(n2));
    }

    public long getIntUnsigned(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length - 4);
        return SqlJetBytesUtility.toUnsignedInt(this.getInt(n2));
    }

    public int getShortUnsigned(int n2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length - 2);
        return SqlJetBytesUtility.toUnsignedShort(this.getShort(n2));
    }

    public void putByte(int n2, byte by) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.length);
        this.buffer[n2] = by;
    }

    public void putInt(int n2, int n3) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length - 4);
        SqlJetBytesUtility.putInt(this.buffer, n2, n3);
    }

    public void putLong(int n2, long l2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length - 8);
        SqlJetBytesUtility.putLong(this.buffer, n2, l2);
    }

    public void putShort(int n2, short s2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length - 2);
        SqlJetBytesUtility.putShort(this.buffer, n2, s2);
    }

    public void putByteUnsigned(int n2, int n3) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.length);
        this.putByte(n2, (byte)SqlJetBytesUtility.toUnsignedByte(n3));
    }

    public void putIntUnsigned(int n2, long l2) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length - 4);
        this.putInt(n2, (int)SqlJetBytesUtility.toUnsignedInt(l2));
    }

    public void putShortUnsigned(int n2, int n3) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 <= this.buffer.length - 2);
        this.putShort(n2, (short)SqlJetBytesUtility.toUnsignedShort(n3));
    }

    public int readFromFile(int n2, RandomAccessFile randomAccessFile, long l2, int n3) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.length);
        assert (randomAccessFile != null);
        assert (l2 >= 0L);
        assert (n3 > 0);
        randomAccessFile.seek(l2);
        return randomAccessFile.read(this.buffer, n2, n3);
    }

    public int writeToFile(int n2, RandomAccessFile randomAccessFile, long l2, int n3) {
        assert (this.buffer != null);
        assert (n2 >= 0);
        assert (n2 < this.buffer.length);
        assert (randomAccessFile != null);
        assert (l2 >= 0L);
        assert (n3 > 0);
        randomAccessFile.seek(l2);
        randomAccessFile.write(this.buffer, n2, n3);
        return n3;
    }

    public byte[] asArray() {
        return this.buffer;
    }

    public void copyFrom(int n2, ISqlJetMemoryBuffer iSqlJetMemoryBuffer, int n3, int n4) {
        if (iSqlJetMemoryBuffer instanceof SqlJetByteArrayBuffer) {
            SqlJetByteArrayBuffer sqlJetByteArrayBuffer = (SqlJetByteArrayBuffer)iSqlJetMemoryBuffer;
            System.arraycopy(sqlJetByteArrayBuffer.buffer, n3, this.buffer, n2, n4);
        } else {
            byte[] byArray = new byte[n4];
            iSqlJetMemoryBuffer.getBytes(n3, byArray, 0, n4);
            this.putBytes(n2, byArray, 0, n4);
        }
    }

    public void fill(int n2, int n3, byte by) {
        Arrays.fill(this.buffer, n2, n2 + n3, by);
    }

    public void getBytes(int n2, byte[] byArray, int n3, int n4) {
        System.arraycopy(this.buffer, n2, byArray, n3, n4);
    }

    public void putBytes(int n2, byte[] byArray, int n3, int n4) {
        System.arraycopy(byArray, n3, this.buffer, n2, n4);
    }

    public int compareTo(int n2, ISqlJetMemoryBuffer iSqlJetMemoryBuffer, int n3) {
        int n4;
        int n5;
        int n6 = this.getSize() - n2;
        int n7 = n5 = n6 > (n4 = iSqlJetMemoryBuffer.getSize() - n3) ? n4 : n6;
        if (iSqlJetMemoryBuffer instanceof SqlJetByteArrayBuffer) {
            SqlJetByteArrayBuffer sqlJetByteArrayBuffer = (SqlJetByteArrayBuffer)iSqlJetMemoryBuffer;
            int n8 = SqlJetUtility.memcmp(this.buffer, n2, sqlJetByteArrayBuffer.buffer, n3, n5);
            if (n8 != 0) {
                return n8;
            }
        } else {
            byte[] byArray = new byte[n6];
            iSqlJetMemoryBuffer.getBytes(n3, byArray, 0, n6);
            int n9 = SqlJetUtility.memcmp(this.buffer, n2, byArray, n3, n5);
            if (n9 != 0) {
                return n9;
            }
        }
        if (n6 != n4) {
            if (n6 > n4) {
                return 1;
            }
            return -1;
        }
        return 0;
    }
}

