/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;

public class SqlJetMapTableCursor
extends SqlJetBtreeTable
implements ISqlJetMapTableCursor {
    private static final String KEY_MUST_BE_MORE_THAN_ZERO = "Key must be more than zero: ";
    private final SqlJetMapDb mapDb;

    public SqlJetMapTableCursor(SqlJetMapDb sqlJetMapDb, ISqlJetBtree iSqlJetBtree, SqlJetMapDef sqlJetMapDef, boolean bl2) {
        super(iSqlJetBtree, sqlJetMapDef.getVirtualTableDef().getPage(), bl2, false);
        if (!sqlJetMapDb.isInTransaction()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        }
        this.mapDb = sqlJetMapDb;
    }

    public long getKey() {
        return this.getKeySize();
    }

    public Object[] getValue() {
        return this.getValues();
    }

    public boolean goToKey(long l2) {
        if (l2 > 0L) {
            int n2 = this.moveTo(null, l2, false);
            if (n2 < 0 && !this.next()) {
                return false;
            }
            return n2 == 0 || l2 == this.getKeySize();
        }
        throw new SqlJetException(String.format(KEY_MUST_BE_MORE_THAN_ZERO, l2));
    }

    public long put(long l2, Object ... objectArray) {
        if (objectArray != null) {
            SqlJetEncoding sqlJetEncoding = this.mapDb.getOptions().getEncoding();
            ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(sqlJetEncoding, objectArray);
            ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
            l2 = l2 > 0L ? l2 : this.newRowId();
            this.insert(null, l2, iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), 0, true);
            iSqlJetBtreeRecord.release();
            return l2;
        }
        if (this.goToKey(l2)) {
            this.delete();
            return l2;
        }
        return 0L;
    }
}

