/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetUnpackedRecordFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.map.ISqlJetMapIndexCursor;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;

public class SqlJetMapIndexCursor
extends SqlJetBtreeTable
implements ISqlJetMapIndexCursor {
    private final SqlJetMapDb mapDb;

    public SqlJetMapIndexCursor(SqlJetMapDb sqlJetMapDb, ISqlJetBtree iSqlJetBtree, ISqlJetIndexDef iSqlJetIndexDef, boolean bl2) {
        super(iSqlJetBtree, iSqlJetIndexDef.getPage(), bl2, true);
        if (!sqlJetMapDb.isInTransaction()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        }
        this.mapDb = sqlJetMapDb;
    }

    public Object[] getKey() {
        Object[] objectArray = this.getValues();
        if (objectArray != null && objectArray.length > 1) {
            int n2 = objectArray.length - 1;
            Object[] objectArray2 = new Object[n2];
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            return objectArray2;
        }
        return null;
    }

    public Long getValue() {
        Object object;
        Object[] objectArray = this.getValues();
        if (objectArray != null && objectArray.length > 1 && (object = objectArray[objectArray.length - 1]) != null && object instanceof Long) {
            return (Long)object;
        }
        return null;
    }

    public boolean goToKey(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            SqlJetEncoding sqlJetEncoding = this.mapDb.getOptions().getEncoding();
            ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(sqlJetEncoding, objectArray);
            ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
            iSqlJetBtreeRecord.release();
            int n2 = this.moveTo(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), false);
            if (n2 < 0 && !this.next()) {
                return false;
            }
            if (n2 != 0) {
                ISqlJetBtreeRecord iSqlJetBtreeRecord2 = this.getRecord();
                if (null == iSqlJetBtreeRecord2) {
                    return false;
                }
                if (this.keyCompare(objectArray.length, iSqlJetMemoryPointer, iSqlJetBtreeRecord2.getRawRecord()) != 0) {
                    return false;
                }
            }
            return true;
        }
        throw new SqlJetException("Key must be not null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int keyCompare(int n2, ISqlJetMemoryPointer iSqlJetMemoryPointer, ISqlJetMemoryPointer iSqlJetMemoryPointer2) {
        this.getKeyInfo().setNField(n2);
        SqlJetUnpackedRecord sqlJetUnpackedRecord = this.getKeyInfo().recordUnpack(iSqlJetMemoryPointer.remaining(), iSqlJetMemoryPointer);
        Set set = sqlJetUnpackedRecord.getFlags();
        set.add(SqlJetUnpackedRecordFlags.IGNORE_ROWID);
        set.add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        try {
            int n3 = sqlJetUnpackedRecord.recordCompare(iSqlJetMemoryPointer2.remaining(), iSqlJetMemoryPointer2);
            Object var8_7 = null;
            sqlJetUnpackedRecord.release();
            return n3;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            sqlJetUnpackedRecord.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object[] objectArray, Long l2) {
        block6: {
            if (this.write) {
                if (l2 != null) {
                    this.lock();
                    try {
                        SqlJetEncoding sqlJetEncoding = this.mapDb.getOptions().getEncoding();
                        ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(sqlJetEncoding, SqlJetUtility.addArrays(objectArray, new Object[]{l2}));
                        ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
                        this.getCursor().insert(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), SqlJetUtility.allocatePtr(0), 0, 0, true);
                        this.clearRecordCache();
                        iSqlJetBtreeRecord.release();
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        this.unlock();
                        throw throwable;
                    }
                    this.unlock();
                    {
                        break block6;
                    }
                }
                if (this.goToKey(objectArray)) {
                    this.delete();
                }
            } else {
                throw new SqlJetException("Read-only");
            }
        }
    }
}

