/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapIndexCursor;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapIndexCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;

public class SqlJetMapCursor
implements ISqlJetMapCursor {
    private final SqlJetMapDb mapDb;
    private final ISqlJetBtree btree;
    private final SqlJetMapDef mapDef;
    private boolean writable;
    private ISqlJetMapTableCursor mapTable;
    private ISqlJetMapIndexCursor mapIndex;

    public SqlJetMapCursor(SqlJetMapDb sqlJetMapDb, ISqlJetBtree iSqlJetBtree, SqlJetMapDef sqlJetMapDef, boolean bl2) {
        if (!sqlJetMapDb.isInTransaction()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        }
        this.mapDb = sqlJetMapDb;
        this.btree = iSqlJetBtree;
        this.mapDef = sqlJetMapDef;
        this.writable = bl2;
    }

    public synchronized ISqlJetMapTableCursor getMapTable() {
        if (this.mapTable == null) {
            this.mapTable = new SqlJetMapTableCursor(this.mapDb, this.btree, this.mapDef, this.writable);
        }
        return this.mapTable;
    }

    public synchronized ISqlJetMapIndexCursor getMapIndex() {
        if (this.mapIndex == null) {
            ISqlJetIndexDef iSqlJetIndexDef = this.mapDef.getIndexDef();
            this.mapIndex = new SqlJetMapIndexCursor(this.mapDb, this.btree, iSqlJetIndexDef, this.writable);
        }
        return this.mapIndex;
    }

    public synchronized void close() {
        if (this.mapTable != null) {
            this.mapTable.close();
            this.mapTable = null;
        }
        if (this.mapIndex != null) {
            this.mapIndex.close();
            this.mapIndex = null;
        }
    }

    public Object[] getKey() {
        return this.getMapIndex().getKey();
    }

    public Object[] getValue() {
        return this.getMapTable().getValue();
    }

    public boolean goToKey(Object[] objectArray) {
        if (this.getMapIndex().goToKey(objectArray)) {
            return this.getMapTable().goToKey(this.getMapIndex().getValue());
        }
        return false;
    }

    public void put(Object[] objectArray, Object[] objectArray2) {
        this.getMapIndex().put(objectArray, this.getMapTable().put(0L, objectArray2));
    }

    public boolean eof() {
        return this.getMapIndex().eof();
    }

    public boolean first() {
        return this.getMapIndex().first();
    }

    public boolean last() {
        return this.getMapIndex().last();
    }

    public boolean next() {
        return this.getMapIndex().next();
    }

    public boolean previous() {
        return this.getMapIndex().previous();
    }
}

