/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.lang;

import java.io.InputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.lang.SqlLexer;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.table.SqlJetPragmasHandler;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class SqlJetPreparedStatement {
    private final SqlJetDb db;
    private final String sql;
    private CommonTree ast;
    private ISqlJetTable table;
    private ISqlJetCursor cursor;
    private Object result;

    public SqlJetPreparedStatement(SqlJetDb sqlJetDb, String string) {
        this.db = sqlJetDb;
        this.sql = string;
    }

    public void close() {
        if (this.table != null) {
            this.table = null;
        }
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    public int getParametersCount() {
        return 0;
    }

    public void setInteger(int n2, long l2) {
    }

    public void setFloat(int n2, double d2) {
    }

    public void setText(int n2, String string) {
    }

    public void setBlob(int n2, byte[] byArray) {
    }

    public void setNull(int n2) {
    }

    public void setInteger(String string, long l2) {
    }

    public void setFloat(String string, double d2) {
    }

    public void setText(String string, String string2) {
    }

    public void setBlob(String string, byte[] byArray) {
    }

    public void setNull(String string) {
    }

    public void clearBindings() {
    }

    public boolean step() {
        if (this.ast == null) {
            try {
                this.ast = this.parse();
                String string = this.ast.getText();
                if ("select".equalsIgnoreCase(string)) {
                    this.handleSelect();
                }
                if ("create_table".equalsIgnoreCase(string)) {
                    this.db.createTable(this.sql);
                }
                if ("drop_table".equalsIgnoreCase(string)) {
                    this.handleDropTable();
                }
                if ("create_index".equalsIgnoreCase(string)) {
                    this.db.createIndex(this.sql);
                }
                if ("drop_index".equalsIgnoreCase(string)) {
                    this.handleDropIndex();
                }
                if ("pragma".equalsIgnoreCase(string)) {
                    this.result = new SqlJetPragmasHandler(this.db.getOptions()).pragma(this.ast);
                    return this.result != null;
                }
                throw new SqlJetException(SqlJetErrorCode.ERROR, "Unsupported statement.");
            }
            catch (RecognitionException recognitionException) {
                throw new SqlJetException(SqlJetErrorCode.ERROR, (Throwable)recognitionException);
            }
        } else if (this.cursor != null) {
            this.cursor.next();
        }
        if (this.cursor != null) {
            return !this.cursor.eof();
        }
        return false;
    }

    private CommonTree parse() {
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(this.sql);
        SqlLexer sqlLexer = new SqlLexer(aNTLRStringStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(sqlLexer);
        SqlParser sqlParser = new SqlParser(commonTokenStream);
        return (CommonTree)sqlParser.sql_stmt().getTree();
    }

    private void handleSelect() {
        CommonTree commonTree = (CommonTree)this.ast.getChild(0);
        if (!"select_core".equalsIgnoreCase(commonTree.getText())) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Compound select is not supported yet.");
        }
        int n2 = 0;
        CommonTree commonTree2 = (CommonTree)commonTree.getChild(n2++);
        boolean bl2 = false;
        if ("distinct".equalsIgnoreCase(commonTree2.getText())) {
            bl2 = true;
            commonTree2 = (CommonTree)commonTree.getChild(n2++);
        }
        if (bl2) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Distinct select modifier is not supported yet.");
        }
        assert ("columns".equalsIgnoreCase(commonTree2.getText()));
        if (commonTree2.getChildCount() != 1 && !"*".equals(commonTree2.getChild(0).getText())) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Can select only * for now.");
        }
        if (!"from".equalsIgnoreCase((commonTree2 = (CommonTree)commonTree.getChild(n2++)).getText())) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Select source should be specified.");
        }
        if (!"alias".equalsIgnoreCase((commonTree2 = (CommonTree)commonTree2.getChild(0)).getText())) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Compound select source is not supported yet.");
        }
        if ("select".equalsIgnoreCase((commonTree2 = (CommonTree)commonTree2.getChild(0)).getText())) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Select as select source is not supported yet.");
        }
        String string = commonTree2.getText();
        if (commonTree.getChildCount() > n2) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Unsupported select syntax.");
        }
        this.table = this.db.getTable(string);
        if (this.table != null) {
            this.cursor = this.table.open();
        }
    }

    private void handleDropTable() {
        CommonTree commonTree = (CommonTree)this.ast.getChild(0);
        boolean bl2 = commonTree.getChildCount() > 0 && "exists".equalsIgnoreCase(commonTree.getChild(0).getText());
        String string = this.ast.getChild(1).getText();
        if (this.db.getSchema().getTable(string) != null) {
            this.db.dropTable(string);
        } else if (!bl2) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Table does not exists.");
        }
    }

    private void handleDropIndex() {
        CommonTree commonTree = (CommonTree)this.ast.getChild(0);
        boolean bl2 = commonTree.getChildCount() > 0 && "exists".equalsIgnoreCase(commonTree.getChild(0).getText());
        String string = this.ast.getChild(1).getText();
        if (this.db.getSchema().getIndex(string) != null) {
            this.db.dropIndex(string);
        } else if (!bl2) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Index does not exists.");
        }
    }

    public int getColumnsCount() {
        if (this.result != null) {
            return 1;
        }
        return this.cursor.getFieldsCount();
    }

    public SqlJetValueType getColumnType(int n2) {
        if (this.result instanceof String) {
            return SqlJetValueType.TEXT;
        }
        if (this.result instanceof Integer) {
            return SqlJetValueType.INTEGER;
        }
        if (this.result instanceof Double) {
            return SqlJetValueType.FLOAT;
        }
        return this.cursor.getFieldType(n2);
    }

    public long getInteger(int n2) {
        if (this.result instanceof Integer && n2 == 0) {
            return ((Integer)this.result).longValue();
        }
        return this.cursor.getInteger(n2);
    }

    public double getFloat(int n2) {
        if (this.result instanceof Double && n2 == 0) {
            return (Double)this.result;
        }
        return this.cursor.getFloat(n2);
    }

    public String getText(int n2) {
        if (this.result instanceof String && n2 == 0) {
            return (String)this.result;
        }
        return this.cursor.getString(n2);
    }

    public byte[] getBlobAsArray(int n2) {
        return this.cursor.getBlobAsArray(n2);
    }

    public InputStream getBlobAsStream(int n2) {
        return this.cursor.getBlobAsStream(n2);
    }

    public boolean isNull(int n2) {
        return this.cursor.isNull(n2);
    }

    public void reset() {
    }
}

