/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.lang;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.tmatesoft.sqljet.core.internal.lang.SqlJetConnection;
import org.tmatesoft.sqljet.core.internal.lang.SqlJetExecCallback;
import org.tmatesoft.sqljet.core.internal.lang.SqlJetPreparedStatement;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBlobLiteral;

public class SqlJetConsole
implements SqlJetExecCallback {
    private final String fileName;
    private boolean firstRow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            SqlJetConsole.println("Exactly one database file name should be specified.");
            return;
        }
        SqlJetConnection sqlJetConnection = SqlJetConnection.open(stringArray[0]);
        SqlJetConsole.println("SQLJet version 1.0");
        SqlJetConsole.println("Enter \".help\" for instructions");
        try {
            new SqlJetConsole(stringArray[0]).repl(sqlJetConnection);
            Object var3_2 = null;
            sqlJetConnection.close();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            sqlJetConnection.close();
            throw throwable;
        }
    }

    private SqlJetConsole(String string) {
        this.fileName = string;
    }

    private void repl(SqlJetConnection sqlJetConnection) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        StringBuffer stringBuffer = new StringBuffer();
        SqlJetConsole.print("sqljet> ");
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            String string2 = stringBuffer.toString().trim();
            if (".help".equalsIgnoreCase(string2)) {
                this.printHelp();
            } else if (".databases".equalsIgnoreCase(string2)) {
                this.printDatabases();
            } else if (".schema".equalsIgnoreCase(string2)) {
                this.printSchema(sqlJetConnection);
            } else if (".exit".equalsIgnoreCase(string2) || ".quit".equalsIgnoreCase(string2)) {
                System.exit(0);
            } else if (string.trim().endsWith(";")) {
                this.firstRow = true;
                try {
                    sqlJetConnection.exec(stringBuffer.toString(), this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                SqlJetConsole.print("   ...> ");
                continue;
            }
            stringBuffer.setLength(0);
            SqlJetConsole.print("sqljet> ");
        }
    }

    public void processRow(SqlJetPreparedStatement sqlJetPreparedStatement) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.firstRow) {
            for (n2 = 0; n2 < 80; ++n2) {
                stringBuffer.append('-');
            }
            SqlJetConsole.println(stringBuffer.toString());
            stringBuffer.setLength(0);
            this.firstRow = false;
        }
        block8: for (n2 = 0; n2 < sqlJetPreparedStatement.getColumnsCount(); ++n2) {
            if (n2 > 0) {
                stringBuffer.append("|");
            }
            switch (sqlJetPreparedStatement.getColumnType(n2)) {
                case INTEGER: {
                    stringBuffer.append(sqlJetPreparedStatement.getInteger(n2));
                    continue block8;
                }
                case FLOAT: {
                    stringBuffer.append(sqlJetPreparedStatement.getFloat(n2));
                    continue block8;
                }
                case TEXT: {
                    stringBuffer.append(String.valueOf(sqlJetPreparedStatement.getText(n2)));
                    continue block8;
                }
                case BLOB: {
                    stringBuffer.append(this.asBlob(sqlJetPreparedStatement.getBlobAsArray(n2)));
                    continue block8;
                }
                case NULL: {
                    stringBuffer.append("NULL");
                }
            }
        }
        SqlJetConsole.println(stringBuffer.toString());
    }

    private String asBlob(byte[] byArray) {
        if (byArray == null) {
            return "NULL";
        }
        return SqlJetBlobLiteral.asBlob(byArray);
    }

    private void printHelp() {
        SqlJetConsole.println(".databases             List names and files of attached databases");
        SqlJetConsole.println(".exit                  Exit this program");
        SqlJetConsole.println(".help                  Show this message");
        SqlJetConsole.println(".quit                  Exit this program");
        SqlJetConsole.println(".schema ?TABLE?        Show the CREATE statements");
    }

    private void printDatabases() {
        SqlJetConsole.println(this.fileName);
    }

    private void printSchema(SqlJetConnection sqlJetConnection) {
        SqlJetConsole.println(sqlJetConnection.getSchema("main").toString());
    }

    private static void print(String string) {
        System.out.print(string);
    }

    private static void println(String string) {
        System.out.println(string);
    }
}

