/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.fs.util.SqlJetFileUtil$SqlJetOsType;

public class SqlJetFileUtil {
    public static final int ATTEMPTS_COUNT = SqlJetUtility.getIntSysProp("sqljet.fs.win32_retry_count", 100);
    public static final SqlJetFileUtil$SqlJetOsType OS = new SqlJetFileUtil$SqlJetOsType();

    public static boolean deleteFile(File file) {
        return SqlJetFileUtil.deleteFile(file, false);
    }

    public static boolean deleteFile(File file, boolean bl2) {
        if (file == null) {
            return true;
        }
        if (OS.isWindows()) {
            bl2 = true;
        }
        if (!bl2 || file.isDirectory() || !file.exists()) {
            return file.delete();
        }
        long l2 = 1L;
        for (int i2 = 0; i2 < ATTEMPTS_COUNT; ++i2) {
            if (file.delete() && !file.exists()) {
                return true;
            }
            if (!file.exists()) {
                return true;
            }
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            if (l2 >= 128L) continue;
            l2 *= 2L;
        }
        return false;
    }

    public static RandomAccessFile openFile(File file, String string) {
        if (file == null) {
            return null;
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (OS.isWindows()) {
            long l2 = 1L;
            for (int i2 = 0; i2 < ATTEMPTS_COUNT; ++i2) {
                try {
                    return new RandomAccessFile(file, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                    if (l2 >= 128L) continue;
                    l2 *= 2L;
                    continue;
                }
            }
        }
        return new RandomAccessFile(file, string);
    }

    private static boolean containsIgnoreCase(String string, String string2) {
        assert (string != null && string2 != null);
        int n2 = string2.length();
        assert (n2 > 0);
        for (int i2 = string.length() - n2; i2 >= 0; --i2) {
            if (!string.regionMatches(true, i2, string2, 0, n2)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$000(String string, String string2) {
        return SqlJetFileUtil.containsIgnoreCase(string, string2);
    }
}

