/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystemsManager;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystem;

public class SqlJetFileSystemsManager
implements ISqlJetFileSystemsManager {
    private Object lock = new Object();
    private ISqlJetFileSystem defaultFileSystem = null;
    private Map fileSystems = new ConcurrentHashMap();
    private static SqlJetFileSystemsManager manager = new SqlJetFileSystemsManager();

    protected SqlJetFileSystemsManager() {
        try {
            this.register(new SqlJetFileSystem(), true);
        }
        catch (SqlJetException sqlJetException) {
            sqlJetException.printStackTrace();
        }
    }

    public static SqlJetFileSystemsManager getManager() {
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetFileSystem find(String string) {
        if (null != string) {
            return (ISqlJetFileSystem)this.fileSystems.get(string);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.defaultFileSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ISqlJetFileSystem iSqlJetFileSystem, boolean bl2) {
        this.checkFS(iSqlJetFileSystem);
        this.fileSystems.put(iSqlJetFileSystem.getName(), iSqlJetFileSystem);
        if (bl2 || null == this.defaultFileSystem) {
            Object object = this.lock;
            synchronized (object) {
                this.defaultFileSystem = iSqlJetFileSystem;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ISqlJetFileSystem iSqlJetFileSystem) {
        this.checkFS(iSqlJetFileSystem);
        this.fileSystems.remove(iSqlJetFileSystem.getName());
        if (iSqlJetFileSystem == this.defaultFileSystem) {
            Object object = this.lock;
            synchronized (object) {
                this.defaultFileSystem = null;
                this.defaultFileSystem = this.fileSystems.size() > 0 ? (ISqlJetFileSystem)this.fileSystems.values().iterator().next() : null;
            }
        }
    }

    private void checkFS(ISqlJetFileSystem iSqlJetFileSystem) {
        if (null == iSqlJetFileSystem) {
            throw new SqlJetException(SqlJetErrorCode.BAD_PARAMETER, "Prameter 'fs' must be not null");
        }
        if (null == iSqlJetFileSystem.getName()) {
            throw new SqlJetException(SqlJetErrorCode.BAD_PARAMETER, "fs.getName() must return not null value");
        }
    }
}

