/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.SecureRandom;
import java.util.EnumSet;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.SqlJetFileAccesPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFile;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetMemJournal;
import org.tmatesoft.sqljet.core.internal.fs.util.SqlJetFileUtil;

public class SqlJetFileSystem
implements ISqlJetFileSystem {
    public static final String FS_NAME = SqlJetFileSystem.class.getCanonicalName();
    private static final String SQLJET_TEMP_FILE_PREFIX = "tejlqs_";
    private final SecureRandom random = new SecureRandom();

    public String getName() {
        return FS_NAME;
    }

    public ISqlJetFile open(File file, SqlJetFileType sqlJetFileType, Set set) {
        File file2;
        if (null == sqlJetFileType) {
            throw new SqlJetException(SqlJetErrorCode.BAD_PARAMETER, "File type must not be null to open file");
        }
        if (null == set || set.isEmpty()) {
            throw new SqlJetException(SqlJetErrorCode.BAD_PARAMETER, "Permissions must not be null or empty to open file");
        }
        boolean bl2 = set.contains((Object)SqlJetFileOpenPermission.EXCLUSIVE);
        boolean bl3 = set.contains((Object)SqlJetFileOpenPermission.DELETEONCLOSE);
        boolean bl4 = set.contains((Object)SqlJetFileOpenPermission.CREATE);
        boolean bl5 = set.contains((Object)SqlJetFileOpenPermission.READONLY);
        boolean bl6 = set.contains((Object)SqlJetFileOpenPermission.READWRITE);
        assert (!(bl5 && bl6 || !bl6 && !bl5));
        assert (!bl4 || bl6);
        assert (!bl2 || bl4);
        assert (!bl3 || bl4);
        assert (SqlJetFileType.MAIN_DB != sqlJetFileType || !bl3);
        assert (SqlJetFileType.MAIN_JOURNAL != sqlJetFileType || !bl3);
        assert (SqlJetFileType.MASTER_JOURNAL != sqlJetFileType || !bl3);
        if (null != file) {
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)iOException);
            }
        }
        assert (bl3 && (!bl4 || SqlJetFileType.MASTER_JOURNAL != sqlJetFileType && SqlJetFileType.MAIN_JOURNAL != sqlJetFileType));
        try {
            file2 = this.getTempFile();
        }
        catch (IOException iOException) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)iOException);
        }
        assert (null != file2);
        if (!(bl6 || file2.isFile() && file2.canRead())) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        String string = "rw";
        if (bl5 && !bl6 && !bl4 && !bl2) {
            string = "r";
        } else if (bl6 && !bl2 && file2.isFile() && !file2.canWrite() && file2.canRead()) {
            EnumSet<SqlJetFileOpenPermission> enumSet = EnumSet.copyOf(set);
            enumSet.remove((Object)SqlJetFileOpenPermission.READWRITE);
            enumSet.remove((Object)SqlJetFileOpenPermission.CREATE);
            enumSet.add(SqlJetFileOpenPermission.READONLY);
            return this.open(file2, sqlJetFileType, enumSet);
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = SqlJetFileUtil.openFile(file2, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (bl6 && !bl2) {
                EnumSet<SqlJetFileOpenPermission> enumSet = EnumSet.copyOf(set);
                enumSet.remove((Object)SqlJetFileOpenPermission.READWRITE);
                enumSet.remove((Object)SqlJetFileOpenPermission.CREATE);
                enumSet.add(SqlJetFileOpenPermission.READONLY);
                return this.open(file2, sqlJetFileType, enumSet);
            }
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        boolean bl7 = SqlJetFileType.MAIN_DB != sqlJetFileType;
        return new SqlJetFile(this, randomAccessFile, file2, sqlJetFileType, set, bl7);
    }

    public File getTempFile() {
        return File.createTempFile(SQLJET_TEMP_FILE_PREFIX, null);
    }

    public boolean delete(File file, boolean bl2) {
        assert (null != file);
        return SqlJetFileUtil.deleteFile(file, bl2);
    }

    public boolean access(File file, SqlJetFileAccesPermission sqlJetFileAccesPermission) {
        assert (null != file);
        assert (null != sqlJetFileAccesPermission);
        switch (sqlJetFileAccesPermission) {
            case EXISTS: {
                return file.exists();
            }
            case READONLY: {
                return file.canRead() && !file.canWrite();
            }
            case READWRITE: {
                return file.canRead() && file.canWrite();
            }
        }
        throw new SqlJetException(SqlJetErrorCode.INTERNAL, "Unhandled SqlJetFileAccesPermission value :" + sqlJetFileAccesPermission.name());
    }

    public long currentTime() {
        return System.currentTimeMillis();
    }

    public byte[] randomness(int n2) {
        assert (n2 > 0);
        byte[] byArray = new byte[n2];
        this.random.nextBytes(byArray);
        return byArray;
    }

    public long sleep(long l2) {
        assert (l2 > 0L);
        long l3 = System.currentTimeMillis();
        try {
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return System.currentTimeMillis() - l3;
    }

    public ISqlJetFile memJournalOpen() {
        return new SqlJetMemJournal();
    }

    public String getFullPath(File file) {
        assert (file != null);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_ACCESS, (Throwable)iOException);
        }
    }
}

