/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLock;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLockManager$1;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLockManager$2;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLockManager$ILockCreator;

public class SqlJetFileLockManager {
    private String filePath;
    private FileChannel fileChannel;
    private static Logger filesLogger = Logger.getLogger("SQLJET_LOG_FILES");
    private static final Map locks = new ConcurrentHashMap();
    private SqlJetFileLockManager$ILockCreator tryLockCreator = new SqlJetFileLockManager$1(this);
    private SqlJetFileLockManager$ILockCreator lockCreator = new SqlJetFileLockManager$2(this);

    public SqlJetFileLockManager(String string, FileChannel fileChannel) {
        this.filePath = string;
        this.fileChannel = fileChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock createLock(long l2, long l3, boolean bl2, SqlJetFileLockManager$ILockCreator sqlJetFileLockManager$ILockCreator) {
        Map map = locks;
        synchronized (map) {
            FileLock fileLock;
            SqlJetFileLock sqlJetFileLock = this.getLock(l2, l3);
            if (sqlJetFileLock != null) {
                if (bl2) {
                    sqlJetFileLock.addLock();
                    return sqlJetFileLock;
                }
                return null;
            }
            try {
                fileLock = sqlJetFileLockManager$ILockCreator.createLock(l2, l3, bl2);
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                SqlJetUtility.log(filesLogger, "Cannot lock (%d, %d, %s) of %s: the range overlaps with already existing lock;this may be cause by loading %s class from several class loaders", l2, l3, bl2, this.filePath, this.getClass().getSimpleName());
                return null;
            }
            catch (NonWritableChannelException nonWritableChannelException) {
                SqlJetUtility.log(filesLogger, "Cannot lock (%d, %d, %s) of %s: the file is not writable;this may be caused by wrong permissions", l2, l3, bl2, this.filePath);
                return null;
            }
            return this.addLock(fileLock);
        }
    }

    public FileLock tryLock(long l2, long l3, boolean bl2) {
        return this.createLock(l2, l3, bl2, this.tryLockCreator);
    }

    public FileLock lock(long l2, long l3, boolean bl2) {
        return this.createLock(l2, l3, bl2, this.lockCreator);
    }

    private SqlJetFileLock getLock(long l2, long l3) {
        if (locks.containsKey(this.filePath)) {
            for (SqlJetFileLock sqlJetFileLock : (List)locks.get(this.filePath)) {
                if (!sqlJetFileLock.overlaps(l2, l3)) continue;
                return sqlJetFileLock;
            }
        }
        return null;
    }

    private SqlJetFileLock addLock(FileLock fileLock) {
        if (fileLock != null) {
            SqlJetFileLock sqlJetFileLock = new SqlJetFileLock(this, fileLock);
            if (!locks.containsKey(this.filePath)) {
                locks.put(this.filePath, new ArrayList());
            }
            ((List)locks.get(this.filePath)).add(sqlJetFileLock);
            return sqlJetFileLock;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLock(SqlJetFileLock sqlJetFileLock) {
        Map map = locks;
        synchronized (map) {
            if (locks.containsKey(this.filePath)) {
                List list = (List)locks.get(this.filePath);
                list.remove(sqlJetFileLock);
                if (list.size() == 0) {
                    locks.remove(this.filePath);
                }
            }
        }
    }

    static /* synthetic */ FileChannel access$000(SqlJetFileLockManager sqlJetFileLockManager) {
        return sqlJetFileLockManager.fileChannel;
    }
}

