/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.nio.channels.FileLock;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLockManager;

public class SqlJetFileLock
extends FileLock {
    private final SqlJetFileLockManager manager;
    private final FileLock fileLock;
    private long locksCount;

    public SqlJetFileLock(SqlJetFileLockManager sqlJetFileLockManager, FileLock fileLock) {
        super(fileLock.channel(), fileLock.position(), fileLock.size(), fileLock.isShared());
        this.manager = sqlJetFileLockManager;
        this.fileLock = fileLock;
        this.locksCount = 1L;
    }

    public boolean isValid() {
        return this.fileLock.isValid();
    }

    public void release() {
        --this.locksCount;
        if (this.locksCount == 0L) {
            if (this.fileLock.isValid()) {
                this.fileLock.release();
            }
            this.manager.deleteLock(this);
        }
    }

    public void addLock() {
        ++this.locksCount;
    }
}

