/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetDeviceCharacteristics;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetLockType;
import org.tmatesoft.sqljet.core.internal.SqlJetSyncFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFile$LockInfo;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFile$OpenFile;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLockManager;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.fs.util.SqlJetFileUtil;

public class SqlJetFile
implements ISqlJetFile {
    private static final boolean SQLJET_LOG_FILES = SqlJetUtility.getBoolSysProp("SQLJET_LOG_FILES", false);
    private static final boolean SQLJET_LOG_FILES_PERFORMANCE = SqlJetUtility.getBoolSysProp("SQLJET_LOG_FILES_PERFORMANCE", false);
    private static Logger filesLogger = Logger.getLogger("SQLJET_LOG_FILES");
    public static final int SQLJET_DEFAULT_SECTOR_SIZE = 512;
    private long timer_start = 0L;
    private long timer_elapsed = 0L;
    private static final Map openFiles = new HashMap();
    private SqlJetFileType fileType;
    private Set permissions;
    private RandomAccessFile file;
    private File filePath;
    private String filePathResolved;
    private boolean noLock;
    private SqlJetLockType lockType = SqlJetLockType.NONE;
    private Map locks = new ConcurrentHashMap();
    private SqlJetFile$OpenFile openCount = null;
    private SqlJetFile$LockInfo lockInfo = null;
    private SqlJetFileLockManager fileLockManager;
    static final Set noDeviceCharacteristircs = SqlJetUtility.noneOf(SqlJetDeviceCharacteristics.class);

    private static void OSTRACE(String string, Object ... objectArray) {
        if (SQLJET_LOG_FILES) {
            SqlJetUtility.log(filesLogger, string, objectArray);
        }
    }

    private long TIMER_ELAPSED() {
        return this.timer_elapsed;
    }

    private void TIMER_END() {
        if (SQLJET_LOG_FILES_PERFORMANCE) {
            this.timer_elapsed = System.nanoTime() - this.timer_start;
        }
    }

    private void TIMER_START() {
        if (SQLJET_LOG_FILES_PERFORMANCE) {
            this.timer_start = System.nanoTime();
        }
    }

    private String getpid() {
        return "thread ['" + Thread.currentThread().getName() + "]";
    }

    private String locktypeName(SqlJetLockType sqlJetLockType) {
        return sqlJetLockType != null ? sqlJetLockType.name() : null;
    }

    SqlJetFile(SqlJetFileSystem sqlJetFileSystem, RandomAccessFile randomAccessFile, File file, SqlJetFileType sqlJetFileType, Set set, boolean bl2) {
        this.file = randomAccessFile;
        this.filePath = file;
        this.filePathResolved = file.getAbsolutePath();
        this.fileType = sqlJetFileType;
        this.permissions = EnumSet.copyOf(set);
        this.noLock = bl2;
        this.fileLockManager = new SqlJetFileLockManager(this.filePathResolved, randomAccessFile.getChannel());
        this.findLockInfo();
        SqlJetFile.OSTRACE("OPEN    %s\n", this.filePath);
    }

    public SqlJetFileType getFileType() {
        return this.fileType;
    }

    public synchronized Set getPermissions() {
        HashSet<SqlJetFileOpenPermission> hashSet = new HashSet<SqlJetFileOpenPermission>();
        for (SqlJetFileOpenPermission sqlJetFileOpenPermission : this.permissions) {
            hashSet.add(sqlJetFileOpenPermission);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (null == this.file) {
            return;
        }
        Map map = openFiles;
        synchronized (map) {
            this.unlock(SqlJetLockType.NONE);
            if (!this.noLock && null != this.openCount && null != SqlJetFile$OpenFile.access$000(this.openCount) && SqlJetFile$OpenFile.access$000(this.openCount).size() > 0) {
                for (SqlJetFile$LockInfo sqlJetFile$LockInfo : SqlJetFile$OpenFile.access$000(this.openCount).values()) {
                    if (SqlJetFile$LockInfo.access$100(sqlJetFile$LockInfo) <= 0) continue;
                    SqlJetFile$OpenFile.access$200(this.openCount).add(this.file);
                    return;
                }
            }
            this.releaseLockInfo();
            try {
                try {
                    this.file.close();
                }
                catch (IOException iOException) {
                    throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)iOException);
                }
                Object var5_5 = null;
                this.file = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.file = null;
                throw throwable;
            }
        }
        if (this.filePath != null && this.permissions.contains((Object)SqlJetFileOpenPermission.DELETEONCLOSE) && !SqlJetFileUtil.deleteFile(this.filePath)) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_DELETE, String.format("Can't delete file '%s'", this.filePath.getPath()));
        }
        SqlJetFile.OSTRACE("CLOSE   %s\n", this.filePath);
    }

    public synchronized int read(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, long l2) {
        assert (n2 > 0);
        assert (l2 >= 0L);
        assert (iSqlJetMemoryPointer != null);
        assert (iSqlJetMemoryPointer.remaining() >= n2);
        assert (this.file != null);
        try {
            this.TIMER_START();
            int n3 = iSqlJetMemoryPointer.readFromFile(this.file, l2, n2);
            this.TIMER_END();
            SqlJetFile.OSTRACE("READ %s %5d %7d %d\n", this.filePath, n3, l2, this.TIMER_ELAPSED());
            return n3 < 0 ? 0 : n3;
        }
        catch (IOException iOException) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_READ, (Throwable)iOException);
        }
    }

    public synchronized void write(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, long l2) {
        assert (n2 > 0);
        assert (l2 >= 0L);
        assert (iSqlJetMemoryPointer != null);
        assert (iSqlJetMemoryPointer.remaining() >= n2);
        assert (this.file != null);
        try {
            this.TIMER_START();
            int n3 = iSqlJetMemoryPointer.writeToFile(this.file, l2, n2);
            this.TIMER_END();
            SqlJetFile.OSTRACE("WRITE %s %5d %7d %d\n", this.filePath, n3, l2, this.TIMER_ELAPSED());
        }
        catch (IOException iOException) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_WRITE, (Throwable)iOException);
        }
    }

    public synchronized void truncate(long l2) {
        assert (l2 >= 0L);
        assert (this.file != null);
        try {
            this.file.setLength(l2);
        }
        catch (IOException iOException) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_TRUNCATE, (Throwable)iOException);
        }
    }

    public synchronized void sync(Set set) {
        assert (this.file != null);
        try {
            SqlJetFile.OSTRACE("SYNC    %s\n", this.filePath);
            boolean bl2 = set != null && set.contains((Object)SqlJetSyncFlags.NORMAL);
            this.file.getChannel().force(bl2);
        }
        catch (IOException iOException) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_FSYNC, (Throwable)iOException);
        }
    }

    public synchronized long fileSize() {
        assert (this.file != null);
        try {
            return this.file.getChannel().size();
        }
        catch (IOException iOException) {
            throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)iOException);
        }
    }

    public synchronized SqlJetLockType getLockType() {
        return this.lockType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean lock(SqlJetLockType sqlJetLockType) {
        boolean bl2;
        block49: {
            boolean bl3;
            block48: {
                boolean bl4;
                block47: {
                    boolean bl5;
                    block46: {
                        boolean bl6;
                        block45: {
                            boolean bl7;
                            block44: {
                                boolean bl8;
                                block43: {
                                    boolean bl9;
                                    block42: {
                                        assert (sqlJetLockType != null);
                                        assert (this.file != null);
                                        if (this.noLock) {
                                            return false;
                                        }
                                        SqlJetFile.OSTRACE("LOCK    %s %s was %s(%s,%d) pid=%s\n", this.filePath, this.locktypeName(sqlJetLockType), this.locktypeName(this.lockType), this.locktypeName(SqlJetFile$LockInfo.access$300(this.lockInfo)), SqlJetFile$LockInfo.access$100(this.lockInfo), this.getpid());
                                        if (this.lockType.compareTo(sqlJetLockType) > 0) {
                                            SqlJetFile.OSTRACE("LOCK    %s %s ok (already held)\n", this.filePath, this.locktypeName(sqlJetLockType));
                                            return false;
                                        }
                                        assert (sqlJetLockType != SqlJetLockType.PENDING);
                                        assert (this.lockType != SqlJetLockType.NONE || sqlJetLockType == SqlJetLockType.SHARED);
                                        assert (sqlJetLockType != SqlJetLockType.RESERVED || this.lockType == SqlJetLockType.SHARED);
                                        assert (this.lockInfo != null);
                                        try {
                                            try {
                                                Map map = openFiles;
                                                synchronized (map) {
                                                    FileLock fileLock;
                                                    if (this.lockType != SqlJetFile$LockInfo.access$300(this.lockInfo) && (SqlJetLockType.PENDING.compareTo(SqlJetFile$LockInfo.access$300(this.lockInfo)) <= 0 || SqlJetLockType.SHARED.compareTo(sqlJetLockType) < 0)) {
                                                        bl9 = false;
                                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 41, 10] lbl25 : MonitorExitStatement: MONITOREXIT : var2_2
                                                        Object var8_9 = null;
                                                        break block42;
                                                    }
                                                    if (sqlJetLockType == SqlJetLockType.SHARED && SqlJetFile$LockInfo.access$100(this.lockInfo) > 0 && (SqlJetFile$LockInfo.access$300(this.lockInfo) == SqlJetLockType.SHARED || SqlJetFile$LockInfo.access$300(this.lockInfo) == SqlJetLockType.RESERVED)) {
                                                        this.lockType = SqlJetLockType.SHARED;
                                                        SqlJetFile$LockInfo.access$108(this.lockInfo);
                                                        this.locks.put(SqlJetLockType.SHARED, SqlJetFile$LockInfo.access$400(this.lockInfo));
                                                        SqlJetFile$OpenFile.access$508(this.openCount);
                                                        bl8 = true;
                                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 40, 10] lbl38 : MonitorExitStatement: MONITOREXIT : var2_2
                                                        break block43;
                                                    }
                                                    if (sqlJetLockType == SqlJetLockType.SHARED || sqlJetLockType == SqlJetLockType.EXCLUSIVE && this.lockType.compareTo(SqlJetLockType.PENDING) < 0) {
                                                        if (!this.locks.containsKey((Object)SqlJetLockType.PENDING)) {
                                                            fileLock = this.fileLockManager.tryLock(0x40000000L, 1L, sqlJetLockType == SqlJetLockType.SHARED);
                                                            if (null == fileLock) {
                                                                bl7 = false;
                                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 37, 38, 39, 10] lbl46 : MonitorExitStatement: MONITOREXIT : var2_2
                                                                break block44;
                                                            }
                                                            this.locks.put(SqlJetLockType.PENDING, fileLock);
                                                        }
                                                        if (sqlJetLockType != SqlJetLockType.SHARED && SqlJetFile$LockInfo.access$100(this.lockInfo) <= 1 && null != (fileLock = (FileLock)this.locks.remove((Object)SqlJetLockType.SHARED))) {
                                                            fileLock.release();
                                                            SqlJetFile$LockInfo.access$402(this.lockInfo, null);
                                                        }
                                                    }
                                                    if (sqlJetLockType == SqlJetLockType.SHARED) {
                                                        fileLock = this.fileLockManager.tryLock(0x40000002L, 510L, true);
                                                        FileLock fileLock2 = (FileLock)this.locks.get((Object)SqlJetLockType.PENDING);
                                                        if (null != fileLock2) {
                                                            fileLock2.release();
                                                            this.locks.remove((Object)SqlJetLockType.PENDING);
                                                        }
                                                        if (null == fileLock) {
                                                            bl6 = false;
                                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 34, 36, 10] lbl64 : MonitorExitStatement: MONITOREXIT : var2_2
                                                            break block45;
                                                        }
                                                        this.locks.put(SqlJetLockType.SHARED, fileLock);
                                                        this.lockType = SqlJetLockType.SHARED;
                                                        SqlJetFile$OpenFile.access$508(this.openCount);
                                                        SqlJetFile$LockInfo.access$102(this.lockInfo, 1);
                                                        SqlJetFile$LockInfo.access$402(this.lockInfo, fileLock);
                                                    } else {
                                                        if (sqlJetLockType == SqlJetLockType.EXCLUSIVE && SqlJetFile$LockInfo.access$100(this.lockInfo) > 1) {
                                                            bl5 = false;
                                                            // MONITOREXIT @DISABLED, blocks:[0, 33, 1, 35, 10] lbl79 : MonitorExitStatement: MONITOREXIT : var2_2
                                                            break block46;
                                                        }
                                                        assert (SqlJetLockType.NONE != this.lockType);
                                                        switch (sqlJetLockType) {
                                                            case RESERVED: {
                                                                fileLock = this.fileLockManager.tryLock(0x40000001L, 1L, false);
                                                                if (null == fileLock) {
                                                                    bl4 = false;
                                                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 35, 21, 10, 11, 12] lbl89 : MonitorExitStatement: MONITOREXIT : var2_2
                                                                    break block47;
                                                                } else {
                                                                    this.locks.put(SqlJetLockType.RESERVED, fileLock);
                                                                    break;
                                                                }
                                                            }
                                                            case EXCLUSIVE: {
                                                                FileLock fileLock3 = this.fileLockManager.tryLock(0x40000002L, 510L, false);
                                                                if (null == fileLock3) {
                                                                    this.lockType = SqlJetLockType.PENDING;
                                                                    SqlJetFile$LockInfo.access$302(this.lockInfo, SqlJetLockType.PENDING);
                                                                    bl3 = false;
                                                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 35, 19, 10, 11, 13] lbl102 : MonitorExitStatement: MONITOREXIT : var2_2
                                                                    break block48;
                                                                } else {
                                                                    this.locks.put(SqlJetLockType.EXCLUSIVE, fileLock3);
                                                                    break;
                                                                }
                                                            }
                                                            default: {
                                                                assert (false);
                                                                break;
                                                            }
                                                        }
                                                    }
                                                    this.lockType = sqlJetLockType;
                                                    SqlJetFile$LockInfo.access$302(this.lockInfo, sqlJetLockType);
                                                    bl2 = true;
                                                }
                                                break block49;
                                            }
                                            catch (IOException iOException) {
                                                throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_LOCK, (Throwable)iOException);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var8_17 = null;
                                            SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(sqlJetLockType), this.lockType == sqlJetLockType ? "ok" : "failed");
                                            throw throwable;
                                        }
                                    }
                                    SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(sqlJetLockType), this.lockType == sqlJetLockType ? "ok" : "failed");
                                    return bl9;
                                }
                                Object var8_10 = null;
                                SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(sqlJetLockType), this.lockType == sqlJetLockType ? "ok" : "failed");
                                return bl8;
                            }
                            Object var8_11 = null;
                            SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(sqlJetLockType), this.lockType == sqlJetLockType ? "ok" : "failed");
                            return bl7;
                        }
                        Object var8_12 = null;
                        SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(sqlJetLockType), this.lockType == sqlJetLockType ? "ok" : "failed");
                        return bl6;
                    }
                    Object var8_13 = null;
                    SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(sqlJetLockType), this.lockType == sqlJetLockType ? "ok" : "failed");
                    return bl5;
                }
                Object var8_14 = null;
                SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(sqlJetLockType), this.lockType == sqlJetLockType ? "ok" : "failed");
                return bl4;
            }
            Object var8_15 = null;
            SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(sqlJetLockType), this.lockType == sqlJetLockType ? "ok" : "failed");
            return bl3;
        }
        Object var8_16 = null;
        SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(sqlJetLockType), this.lockType == sqlJetLockType ? "ok" : "failed");
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean unlock(SqlJetLockType sqlJetLockType) {
        assert (sqlJetLockType != null);
        assert (this.file != null);
        if (this.noLock) {
            return false;
        }
        SqlJetFile.OSTRACE("UNLOCK  %s %s was %s(%s,%s) pid=%s\n", this.filePath, this.locktypeName(sqlJetLockType), this.locktypeName(this.lockType), this.locktypeName(SqlJetFile$LockInfo.access$300(this.lockInfo)), SqlJetFile$LockInfo.access$100(this.lockInfo), this.getpid());
        assert (SqlJetLockType.SHARED.compareTo(sqlJetLockType) >= 0);
        if (this.lockType.compareTo(sqlJetLockType) <= 0) {
            return true;
        }
        Map map = openFiles;
        synchronized (map) {
            assert (this.lockInfo != null);
            assert (SqlJetFile$LockInfo.access$100(this.lockInfo) > 0);
            try {
                if (SqlJetLockType.SHARED.compareTo(this.lockType) < 0) {
                    AutoCloseable autoCloseable;
                    Object object;
                    if (SqlJetLockType.SHARED == sqlJetLockType) {
                        object = (FileLock)this.locks.get((Object)SqlJetLockType.EXCLUSIVE);
                        if (null != object) {
                            ((FileLock)object).release();
                            this.locks.remove((Object)SqlJetLockType.EXCLUSIVE);
                        }
                        if (null == this.locks.get((Object)SqlJetLockType.SHARED)) {
                            autoCloseable = this.fileLockManager.lock(0x40000002L, 510L, true);
                            if (null == autoCloseable) {
                                return false;
                            }
                            this.locks.put(SqlJetLockType.SHARED, autoCloseable);
                            SqlJetFile$LockInfo.access$402(this.lockInfo, (FileLock)autoCloseable);
                        }
                    }
                    if (null != (object = (FileLock)this.locks.get((Object)SqlJetLockType.RESERVED))) {
                        ((FileLock)object).release();
                        this.locks.remove((Object)SqlJetLockType.RESERVED);
                    }
                    if (null != (autoCloseable = (FileLock)this.locks.get((Object)SqlJetLockType.PENDING))) {
                        ((FileLock)autoCloseable).release();
                        this.locks.remove((Object)SqlJetLockType.PENDING);
                    }
                    SqlJetFile$LockInfo.access$302(this.lockInfo, SqlJetLockType.SHARED);
                }
                if (sqlJetLockType == SqlJetLockType.NONE) {
                    SqlJetFile$LockInfo.access$110(this.lockInfo);
                    if (SqlJetFile$LockInfo.access$100(this.lockInfo) == 0) {
                        SqlJetFile$LockInfo.access$102(this.lockInfo, 1);
                        for (AutoCloseable autoCloseable : this.locks.values()) {
                            ((FileLock)autoCloseable).release();
                        }
                        this.locks.clear();
                        SqlJetFile$LockInfo.access$102(this.lockInfo, 0);
                        SqlJetFile$LockInfo.access$302(this.lockInfo, SqlJetLockType.NONE);
                    }
                    SqlJetFile$OpenFile.access$510(this.openCount);
                    assert (SqlJetFile$OpenFile.access$500(this.openCount) >= 0);
                    if (SqlJetFile$OpenFile.access$500(this.openCount) == 0 && null != SqlJetFile$OpenFile.access$200(this.openCount) && SqlJetFile$OpenFile.access$200(this.openCount).size() > 0) {
                        for (AutoCloseable autoCloseable : SqlJetFile$OpenFile.access$200(this.openCount)) {
                            ((RandomAccessFile)autoCloseable).close();
                        }
                        SqlJetFile$OpenFile.access$200(this.openCount).clear();
                    }
                }
                this.lockType = sqlJetLockType;
            }
            catch (IOException iOException) {
                throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_LOCK, (Throwable)iOException);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean checkReservedLock() {
        boolean bl2;
        boolean bl3;
        block20: {
            boolean bl4;
            block18: {
                boolean bl5;
                block17: {
                    boolean bl6;
                    block16: {
                        boolean bl7;
                        block15: {
                            boolean bl8;
                            block14: {
                                bl3 = false;
                                try {
                                    block19: {
                                        if (this.noLock) {
                                            bl8 = false;
                                            Object var7_7 = null;
                                            break block14;
                                        }
                                        if (null == this.file) {
                                            bl7 = false;
                                            break block15;
                                        }
                                        if (null == this.lockInfo) {
                                            bl6 = false;
                                            break block16;
                                        }
                                        Map map = openFiles;
                                        synchronized (map) {
                                            FileLock fileLock;
                                            if (SqlJetLockType.SHARED.compareTo(SqlJetFile$LockInfo.access$300(this.lockInfo)) < 0) {
                                                bl5 = true;
                                                // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl20 : MonitorExitStatement: MONITOREXIT : var2_5
                                                break block17;
                                            }
                                            try {
                                                fileLock = this.fileLockManager.tryLock(0x40000001L, 1L, false);
                                                if (null == fileLock) {
                                                    bl3 = true;
                                                    bl4 = true;
                                                    break block18;
                                                }
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                                break block19;
                                            }
                                            {
                                                fileLock.release();
                                            }
                                        }
                                    }
                                    bl2 = false;
                                    break block20;
                                }
                                catch (Throwable throwable) {
                                    Object var7_13 = null;
                                    SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, bl3);
                                    throw throwable;
                                }
                            }
                            SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, bl3);
                            return bl8;
                        }
                        Object var7_8 = null;
                        SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, bl3);
                        return bl7;
                    }
                    Object var7_9 = null;
                    SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, bl3);
                    return bl6;
                }
                Object var7_10 = null;
                SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, bl3);
                return bl5;
            }
            Object var7_11 = null;
            SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, bl3);
            return bl4;
        }
        Object var7_12 = null;
        SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, bl3);
        return bl2;
    }

    public int sectorSize() {
        return 512;
    }

    public Set deviceCharacteristics() {
        return noDeviceCharacteristircs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void findLockInfo() {
        Map map = openFiles;
        synchronized (map) {
            Object object;
            if (null == this.openCount) {
                object = (SqlJetFile$OpenFile)openFiles.get(this.filePathResolved);
                if (null != object) {
                    this.openCount = object;
                    SqlJetFile$OpenFile.access$608(this.openCount);
                } else {
                    this.openCount = new SqlJetFile$OpenFile();
                    openFiles.put(this.filePathResolved, this.openCount);
                }
            }
            if (null != (object = (SqlJetFile$LockInfo)SqlJetFile$OpenFile.access$000(this.openCount).get(Thread.currentThread()))) {
                this.lockInfo = object;
                SqlJetFile$LockInfo.access$808(this.lockInfo);
            } else {
                this.lockInfo = new SqlJetFile$LockInfo(null);
                SqlJetFile$OpenFile.access$000(this.openCount).put(Thread.currentThread(), this.lockInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLockInfo() {
        Map map = openFiles;
        synchronized (map) {
            if (null != this.lockInfo) {
                SqlJetFile$LockInfo.access$810(this.lockInfo);
                if (0 == SqlJetFile$LockInfo.access$800(this.lockInfo)) {
                    if (null != this.openCount) {
                        SqlJetFile$OpenFile.access$000(this.openCount).remove(Thread.currentThread());
                    }
                    this.lockInfo = null;
                }
            }
            if (null != this.openCount) {
                SqlJetFile$OpenFile.access$610(this.openCount);
                if (0 == SqlJetFile$OpenFile.access$600(this.openCount)) {
                    openFiles.remove(this.filePathResolved);
                    this.openCount = null;
                }
            }
        }
    }

    public boolean isMemJournal() {
        return false;
    }
}

