/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.db;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.tmatesoft.sqljet.core.ISqlJetMutex;
import org.tmatesoft.sqljet.core.internal.ISqlJetConfig;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.SqlJetDbFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.db.SqlJetConfig;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystemsManager;
import org.tmatesoft.sqljet.core.internal.mutex.SqlJetEmptyMutex;
import org.tmatesoft.sqljet.core.internal.mutex.SqlJetMutex;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;

public class SqlJetDbHandle
implements ISqlJetDbHandle {
    private Set flags = SqlJetUtility.noneOf(SqlJetDbFlags.class);
    private ISqlJetConfig config = new SqlJetConfig();
    private ISqlJetFileSystem fileSystem = SqlJetFileSystemsManager.getManager().find(null);
    private ISqlJetMutex mutex = new SqlJetEmptyMutex();
    private List backends = new LinkedList();
    private ISqlJetOptions options;
    private ISqlJetBusyHandler busyHandler;

    public SqlJetDbHandle() {
        if (this.config.isSynchronizedThreading()) {
            this.mutex = new SqlJetMutex();
        }
    }

    public SqlJetDbHandle(ISqlJetFileSystem iSqlJetFileSystem) {
        this();
        this.fileSystem = iSqlJetFileSystem;
    }

    public List getBackends() {
        return this.backends;
    }

    public ISqlJetBusyHandler getBusyHandler() {
        return this.busyHandler;
    }

    public void setBusyHandler(ISqlJetBusyHandler iSqlJetBusyHandler) {
        this.busyHandler = iSqlJetBusyHandler;
    }

    public ISqlJetConfig getConfig() {
        return this.config;
    }

    public ISqlJetFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Set getFlags() {
        return this.flags;
    }

    public ISqlJetMutex getMutex() {
        return this.mutex;
    }

    public int getSavepointNum() {
        return 0;
    }

    public void setConfig(ISqlJetConfig iSqlJetConfig) {
    }

    public ISqlJetOptions getOptions() {
        return this.options;
    }

    public void setOptions(ISqlJetOptions iSqlJetOptions) {
        this.options = iSqlJetOptions;
    }
}

