/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetConfig;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCellInfo;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage$_OvflCell;

public class SqlJetMemPage
extends SqlJetCloneable {
    public static final byte PTF_INTKEY = 1;
    public static final byte PTF_ZERODATA = 2;
    public static final byte PTF_LEAFDATA = 4;
    public static final byte PTF_LEAF = 8;
    boolean isInit;
    int nOverflow;
    boolean intKey;
    boolean leaf;
    boolean hasData;
    byte hdrOffset;
    byte childPtrSize;
    int maxLocal;
    int minLocal;
    int cellOffset;
    int nFree;
    int nCell;
    int maskPage;
    SqlJetMemPage$_OvflCell[] aOvfl = new SqlJetMemPage$_OvflCell[]{new SqlJetMemPage$_OvflCell(), new SqlJetMemPage$_OvflCell(), new SqlJetMemPage$_OvflCell(), new SqlJetMemPage$_OvflCell(), new SqlJetMemPage$_OvflCell()};
    SqlJetBtreeShared pBt;
    ISqlJetMemoryPointer aData;
    ISqlJetPage pDbPage;
    int pgno;

    private boolean ISAUTOVACUUM() {
        return this.pBt.autoVacuum;
    }

    public void decodeFlags(int n2) {
        assert (this.hdrOffset == (this.pgno == 1 ? (byte)100 : 0));
        assert (this.pBt.mutex.held());
        this.leaf = n2 >> 3 > 0;
        this.childPtrSize = (byte)(4 - 4 * (this.leaf ? 1 : 0));
        if ((n2 &= 0xFFFFFFF7) == 5) {
            this.intKey = true;
            this.hasData = this.leaf;
            this.maxLocal = this.pBt.maxLeaf;
            this.minLocal = this.pBt.minLeaf;
        } else if (n2 == 2) {
            this.intKey = false;
            this.hasData = false;
            this.maxLocal = this.pBt.maxLocal;
            this.minLocal = this.pBt.minLocal;
        } else {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    public void initPage() {
        assert (this.pBt != null);
        assert (this.pBt.mutex.held());
        assert (this.pgno == this.pDbPage.getPageNumber());
        assert (this == this.pDbPage.getExtra());
        assert (this.aData.getBuffer() == this.pDbPage.getData().getBuffer());
        if (!this.isInit) {
            int n2;
            byte by = this.hdrOffset;
            this.decodeFlags(SqlJetUtility.getUnsignedByte(this.aData, by));
            assert (this.pBt.pageSize >= 512 && this.pBt.pageSize <= 32768);
            this.maskPage = this.pBt.pageSize - 1;
            this.nOverflow = 0;
            int n3 = this.pBt.usableSize;
            this.cellOffset = n2 = by + 12 - 4 * (this.leaf ? 1 : 0);
            int n4 = SqlJetUtility.get2byte(this.aData, by + 5);
            this.nCell = SqlJetUtility.get2byte(this.aData, by + 3);
            if (this.nCell > this.pBt.MX_CELL()) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            int n5 = n2 + 2 * this.nCell;
            int n6 = SqlJetUtility.get2byte(this.aData, by + 1);
            int n7 = SqlJetUtility.getUnsignedByte(this.aData, by + 7) + n4;
            while (n6 > 0) {
                if (n6 > n3 - 4) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                int n8 = SqlJetUtility.get2byte(this.aData, n6);
                int n9 = SqlJetUtility.get2byte(this.aData, n6 + 2);
                if (n8 > 0 && n8 <= n6 + n9 + 3) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                n7 += n9;
                n6 = n8;
            }
            if (n7 > n3) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            this.nFree = n7 - n5;
            this.isInit = true;
        }
    }

    public static void releasePage(SqlJetMemPage sqlJetMemPage) {
        if (sqlJetMemPage != null) {
            assert (sqlJetMemPage.aData != null);
            assert (sqlJetMemPage.pBt != null);
            assert (sqlJetMemPage.pDbPage.getExtra() == sqlJetMemPage);
            assert (sqlJetMemPage.pDbPage.getData().getBuffer() == sqlJetMemPage.aData.getBuffer());
            assert (sqlJetMemPage.pBt.mutex.held());
            sqlJetMemPage.pDbPage.unref();
        }
    }

    public void setChildPtrmaps() {
        boolean bl2 = this.isInit;
        assert (this.pBt.mutex.held());
        try {
            this.initPage();
            int n2 = this.nCell;
            for (int i2 = 0; i2 < n2; ++i2) {
                ISqlJetMemoryPointer iSqlJetMemoryPointer = this.findCell(i2);
                this.ptrmapPutOvflPtr(iSqlJetMemoryPointer);
                if (this.leaf) continue;
                int n3 = SqlJetUtility.get4byte(iSqlJetMemoryPointer);
                this.pBt.ptrmapPut(n3, (short)5, this.pgno);
            }
            if (!this.leaf) {
                int n4 = SqlJetUtility.get4byte(this.aData, this.hdrOffset + 8);
                this.pBt.ptrmapPut(n4, (short)5, this.pgno);
            }
        }
        catch (SqlJetException sqlJetException) {
            this.isInit = bl2;
            throw sqlJetException;
        }
    }

    public void modifyPagePointer(int n2, int n3, short s2) {
        assert (this.pBt.mutex.held());
        if (s2 == 4) {
            if (SqlJetUtility.get4byte(this.aData) != n2) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            SqlJetUtility.put4byte(this.aData, n3);
        } else {
            int n4;
            boolean bl2 = this.isInit;
            this.initPage();
            int n5 = this.nCell;
            for (n4 = 0; n4 < n5; ++n4) {
                ISqlJetMemoryPointer iSqlJetMemoryPointer = this.findCell(n4);
                if (s2 == 3) {
                    SqlJetBtreeCellInfo sqlJetBtreeCellInfo = this.parseCellPtr(iSqlJetMemoryPointer);
                    if (sqlJetBtreeCellInfo.iOverflow <= 0 || n2 != SqlJetUtility.get4byte(iSqlJetMemoryPointer, sqlJetBtreeCellInfo.iOverflow)) continue;
                    SqlJetUtility.put4byte(iSqlJetMemoryPointer, sqlJetBtreeCellInfo.iOverflow, n3);
                    break;
                }
                if (SqlJetUtility.get4byte(iSqlJetMemoryPointer) != n2) continue;
                SqlJetUtility.put4byte(iSqlJetMemoryPointer, n3);
                break;
            }
            if (n4 == n5) {
                if (s2 != 5 || SqlJetUtility.get4byte(this.aData, this.hdrOffset + 8) != n2) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                SqlJetUtility.put4byte(this.aData, this.hdrOffset + 8, n3);
            }
            this.isInit = bl2;
        }
    }

    public ISqlJetMemoryPointer findCell(int n2) {
        return SqlJetUtility.pointer(this.aData, this.maskPage & SqlJetUtility.get2byte(this.aData, this.cellOffset + 2 * n2));
    }

    public void ptrmapPutOvflPtr(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        assert (iSqlJetMemoryPointer != null);
        SqlJetBtreeCellInfo sqlJetBtreeCellInfo = this.parseCellPtr(iSqlJetMemoryPointer);
        assert ((long)sqlJetBtreeCellInfo.nData + (this.intKey ? 0L : sqlJetBtreeCellInfo.nKey) == (long)sqlJetBtreeCellInfo.nPayload);
        if ((long)sqlJetBtreeCellInfo.nData + (this.intKey ? 0L : sqlJetBtreeCellInfo.nKey) > (long)sqlJetBtreeCellInfo.nLocal) {
            int n2 = SqlJetUtility.get4byte(iSqlJetMemoryPointer, sqlJetBtreeCellInfo.iOverflow);
            this.pBt.ptrmapPut(n2, (short)3, this.pgno);
        }
    }

    SqlJetBtreeCellInfo parseCellPtr(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        int[] nArray = new int[1];
        assert (this.pBt.mutex.held());
        SqlJetBtreeCellInfo sqlJetBtreeCellInfo = new SqlJetBtreeCellInfo();
        sqlJetBtreeCellInfo.pCell = iSqlJetMemoryPointer;
        int n2 = this.childPtrSize;
        assert (n2 == 4 - 4 * (this.leaf ? 1 : 0));
        if (this.intKey) {
            if (this.hasData) {
                n2 += SqlJetUtility.getVarint32(iSqlJetMemoryPointer, n2, nArray);
            } else {
                nArray[0] = 0;
            }
            long[] lArray = new long[1];
            n2 += SqlJetUtility.getVarint(iSqlJetMemoryPointer, n2, lArray);
            sqlJetBtreeCellInfo.nKey = lArray[0];
            sqlJetBtreeCellInfo.nData = nArray[0];
        } else {
            sqlJetBtreeCellInfo.nData = 0;
            n2 += SqlJetUtility.getVarint32(iSqlJetMemoryPointer, n2, nArray);
            sqlJetBtreeCellInfo.nKey = nArray[0];
        }
        sqlJetBtreeCellInfo.nPayload = nArray[0];
        sqlJetBtreeCellInfo.nHeader = n2;
        if (nArray[0] <= this.maxLocal) {
            int n3 = nArray[0] + n2;
            sqlJetBtreeCellInfo.nLocal = nArray[0];
            sqlJetBtreeCellInfo.iOverflow = 0;
            if ((n3 & 0xFFFFFFFC) == 0) {
                n3 = 4;
            }
            sqlJetBtreeCellInfo.nSize = n3;
        } else {
            int n4 = this.minLocal;
            int n5 = n4 + (nArray[0] - n4) % (this.pBt.usableSize - 4);
            int n6 = this.maxLocal;
            sqlJetBtreeCellInfo.nLocal = n5 <= n6 ? n5 : n4;
            sqlJetBtreeCellInfo.iOverflow = sqlJetBtreeCellInfo.nLocal + n2;
            sqlJetBtreeCellInfo.nSize = sqlJetBtreeCellInfo.iOverflow + 4;
        }
        return sqlJetBtreeCellInfo;
    }

    public SqlJetBtreeCellInfo parseCell(int n2) {
        return this.parseCellPtr(this.findCell(n2));
    }

    void zeroPage(int n2) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer = this.aData;
        byte by = this.hdrOffset;
        assert (this.pDbPage.getPageNumber() == this.pgno);
        assert (this.pDbPage.getExtra() == this);
        assert (this.pDbPage.getData().getBuffer() == iSqlJetMemoryPointer.getBuffer());
        assert (this.pBt.mutex.held());
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, by, (short)n2);
        int n3 = by + 8 + 4 * ((n2 & 8) == 0 ? 1 : 0);
        SqlJetUtility.put4byte(iSqlJetMemoryPointer, by + 1, 0L);
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, by + 7, 0);
        SqlJetUtility.put2byte(iSqlJetMemoryPointer, by + 5, this.pBt.usableSize);
        this.nFree = this.pBt.usableSize - n3;
        this.decodeFlags(n2);
        this.hdrOffset = by;
        this.cellOffset = n3;
        this.nOverflow = 0;
        assert (this.pBt.pageSize >= 512 && this.pBt.pageSize <= 32768);
        this.maskPage = this.pBt.pageSize - 1;
        this.nCell = 0;
        this.isInit = true;
    }

    public void freePage() {
        SqlJetMemPage sqlJetMemPage = this.pBt.pPage1;
        assert (this.pBt.mutex.held());
        assert (this.pgno > 1);
        this.isInit = false;
        sqlJetMemPage.pDbPage.write();
        int n2 = SqlJetUtility.get4byte(sqlJetMemPage.aData, 36);
        SqlJetUtility.put4byte(sqlJetMemPage.aData, 36, n2 + 1);
        if (ISqlJetConfig.SECURE_DELETE) {
            this.pDbPage.write();
            SqlJetUtility.memset(this.aData, (byte)0, this.pBt.pageSize);
        }
        if (this.ISAUTOVACUUM()) {
            this.pBt.ptrmapPut(this.pgno, (short)2, 0);
        }
        if (n2 == 0) {
            this.pDbPage.write();
            SqlJetUtility.memset(this.aData, (byte)0, 8);
            SqlJetUtility.put4byte(sqlJetMemPage.aData, 32, this.pgno);
            SqlJetBtree.TRACE("FREE-PAGE: %d first\n", this.pgno);
        } else {
            SqlJetMemPage sqlJetMemPage2 = this.pBt.getPage(SqlJetUtility.get4byte(sqlJetMemPage.aData, 32), false);
            int n3 = SqlJetUtility.get4byte(sqlJetMemPage2.aData, 4);
            if (n3 >= this.pBt.usableSize / 4 - 8) {
                this.pDbPage.write();
                SqlJetUtility.put4byte(this.aData, sqlJetMemPage2.pgno);
                SqlJetUtility.put4byte(this.aData, 4, 0L);
                SqlJetUtility.put4byte(sqlJetMemPage.aData, 32, this.pgno);
                SqlJetBtree.TRACE("FREE-PAGE: %d new trunk page replacing %d\n", this.pgno, sqlJetMemPage2.pgno);
            } else {
                if (n3 < 0) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                sqlJetMemPage2.pDbPage.write();
                SqlJetUtility.put4byte(sqlJetMemPage2.aData, 4, n3 + 1);
                SqlJetUtility.put4byte(sqlJetMemPage2.aData, 8 + n3 * 4, this.pgno);
                if (ISqlJetConfig.SECURE_DELETE) {
                    this.pDbPage.dontWrite();
                }
                SqlJetBtree.TRACE("FREE-PAGE: %d leaf on trunk page %d\n", this.pgno, sqlJetMemPage2.pgno);
            }
            SqlJetMemPage.releasePage(sqlJetMemPage2);
        }
    }

    public void clearCell(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        int[] nArray = new int[1];
        assert (this.pBt.mutex.held());
        SqlJetBtreeCellInfo sqlJetBtreeCellInfo = this.parseCellPtr(iSqlJetMemoryPointer);
        if (sqlJetBtreeCellInfo.iOverflow == 0) {
            return;
        }
        nArray[0] = SqlJetUtility.get4byte(iSqlJetMemoryPointer, sqlJetBtreeCellInfo.iOverflow);
        int n2 = this.pBt.usableSize - 4;
        int n3 = (sqlJetBtreeCellInfo.nPayload - sqlJetBtreeCellInfo.nLocal + n2 - 1) / n2;
        assert (nArray[0] == 0 || n3 > 0);
        while (n3-- != 0) {
            SqlJetMemPage[] sqlJetMemPageArray = new SqlJetMemPage[1];
            if (nArray[0] < 2 || nArray[0] > this.pBt.pPager.getPageCount()) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            this.pBt.getOverflowPage(nArray[0], sqlJetMemPageArray, n3 == 0 ? null : nArray);
            sqlJetMemPageArray[0].freePage();
            sqlJetMemPageArray[0].pDbPage.unref();
        }
    }

    int cellSize(int n2) {
        return this.cellSizePtr(this.findCell(n2));
    }

    int cellSizePtr(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        int n2;
        SqlJetMemPage sqlJetMemPage = this;
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = iSqlJetMemoryPointer.getMoved(sqlJetMemPage.childPtrSize);
        int[] nArray = new int[]{0};
        if (sqlJetMemPage.intKey) {
            if (sqlJetMemPage.hasData) {
                iSqlJetMemoryPointer2.movePointer(SqlJetUtility.getVarint32(iSqlJetMemoryPointer2, nArray));
            } else {
                nArray[0] = 0;
            }
            n2 = iSqlJetMemoryPointer2.getPointer() + 9;
            while (iSqlJetMemoryPointer2.getPointer() < n2) {
                int n3 = iSqlJetMemoryPointer2.getByteUnsigned();
                iSqlJetMemoryPointer2.movePointer(1);
                if ((n3 & 0x80) != 0) continue;
                break;
            }
        } else {
            iSqlJetMemoryPointer2.movePointer(SqlJetUtility.getVarint32(iSqlJetMemoryPointer2, nArray));
        }
        if (nArray[0] > sqlJetMemPage.maxLocal) {
            n2 = sqlJetMemPage.minLocal;
            nArray[0] = n2 + (nArray[0] - n2) % (sqlJetMemPage.pBt.usableSize - 4);
            if (nArray[0] > sqlJetMemPage.maxLocal) {
                nArray[0] = n2;
            }
            nArray[0] = nArray[0] + 4;
        }
        nArray[0] = nArray[0] + (iSqlJetMemoryPointer2.getPointer() - iSqlJetMemoryPointer.getPointer());
        if (nArray[0] < 4) {
            nArray[0] = 4;
        }
        return nArray[0];
    }

    public void dropCell(int n2, int n3) {
        SqlJetMemPage sqlJetMemPage = this;
        assert (n2 >= 0 && n2 < sqlJetMemPage.nCell);
        assert (n3 == sqlJetMemPage.cellSize(n2));
        assert (sqlJetMemPage.pBt.mutex.held());
        ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage.aData;
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = SqlJetUtility.pointer(iSqlJetMemoryPointer, sqlJetMemPage.cellOffset + 2 * n2);
        int n4 = SqlJetUtility.get2byte(iSqlJetMemoryPointer2);
        if (n4 < sqlJetMemPage.hdrOffset + 6 + (sqlJetMemPage.leaf ? 0 : 4) || n4 + n3 > sqlJetMemPage.pBt.usableSize) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        sqlJetMemPage.freeSpace(n4, n3);
        ISqlJetMemoryPointer iSqlJetMemoryPointer3 = SqlJetUtility.pointer(iSqlJetMemoryPointer, sqlJetMemPage.cellOffset + 2 * sqlJetMemPage.nCell - 2);
        while (iSqlJetMemoryPointer2.getPointer() < iSqlJetMemoryPointer3.getPointer()) {
            SqlJetUtility.put2byte(iSqlJetMemoryPointer2, SqlJetUtility.get2byte(iSqlJetMemoryPointer2, 2));
            SqlJetUtility.movePtr(iSqlJetMemoryPointer2, 2);
        }
        --sqlJetMemPage.nCell;
        SqlJetUtility.put2byte(iSqlJetMemoryPointer, sqlJetMemPage.hdrOffset + 3, sqlJetMemPage.nCell);
        sqlJetMemPage.nFree += 2;
    }

    private void freeSpace(int n2, int n3) {
        int n4;
        int n5;
        SqlJetMemPage sqlJetMemPage = this;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage.aData;
        assert (sqlJetMemPage.pBt != null);
        assert (n2 >= sqlJetMemPage.hdrOffset + 6 + (sqlJetMemPage.leaf ? 0 : 4));
        assert (n2 + n3 <= sqlJetMemPage.pBt.usableSize);
        assert (sqlJetMemPage.pBt.mutex.held());
        assert (n3 >= 0);
        if (ISqlJetConfig.SECURE_DELETE) {
            SqlJetUtility.memset(iSqlJetMemoryPointer, n2, (byte)0, n3);
        }
        byte by = sqlJetMemPage.hdrOffset;
        int n6 = by + 1;
        while ((n5 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, n6)) < n2 && n5 > 0) {
            assert (n5 <= sqlJetMemPage.pBt.usableSize - 4);
            if (n5 <= n6) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            n6 = n5;
        }
        if (n5 > sqlJetMemPage.pBt.usableSize - 4) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        assert (n5 > n6 || n5 == 0);
        SqlJetUtility.put2byte(iSqlJetMemoryPointer, n6, n2);
        SqlJetUtility.put2byte(iSqlJetMemoryPointer, n2, n5);
        SqlJetUtility.put2byte(iSqlJetMemoryPointer, n2 + 2, n3);
        sqlJetMemPage.nFree += n3;
        n6 = sqlJetMemPage.hdrOffset + 1;
        while ((n5 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, n6)) > 0) {
            assert (n5 > n6);
            assert (n5 <= sqlJetMemPage.pBt.usableSize - 4);
            n4 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, n5);
            int n7 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, n5 + 2);
            if (n5 + n7 + 3 >= n4 && n4 > 0) {
                int n8 = n4 - (n5 + n7);
                if (n8 < 0 || n8 > SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, sqlJetMemPage.hdrOffset + 7)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, sqlJetMemPage.hdrOffset + 7, (byte)(SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, sqlJetMemPage.hdrOffset + 7) - (byte)n8));
                int n9 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, n4);
                SqlJetUtility.put2byte(iSqlJetMemoryPointer, n5, n9);
                n9 = n4 + SqlJetUtility.get2byte(iSqlJetMemoryPointer, n4 + 2) - n5;
                SqlJetUtility.put2byte(iSqlJetMemoryPointer, n5 + 2, n9);
                continue;
            }
            n6 = n5;
        }
        if (SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, by + 1) == SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, by + 5) && SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, by + 2) == SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, by + 6)) {
            n5 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, by + 1);
            SqlJetUtility.memcpy(iSqlJetMemoryPointer, by + 1, iSqlJetMemoryPointer, n5, 2);
            n4 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, by + 5) + SqlJetUtility.get2byte(iSqlJetMemoryPointer, n5 + 2);
            SqlJetUtility.put2byte(iSqlJetMemoryPointer, by + 5, n4);
        }
        assert (sqlJetMemPage.pDbPage.isWriteable());
    }

    public void insertCell(int n2, ISqlJetMemoryPointer iSqlJetMemoryPointer, int n3, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n4) {
        int n5 = n4 > 0 ? 4 : 0;
        SqlJetMemPage sqlJetMemPage = this;
        assert (n2 >= 0 && n2 <= sqlJetMemPage.nCell + sqlJetMemPage.nOverflow);
        assert (sqlJetMemPage.nCell <= sqlJetMemPage.pBt.MX_CELL() && sqlJetMemPage.pBt.MX_CELL() <= 5460);
        assert (sqlJetMemPage.nOverflow <= sqlJetMemPage.aOvfl.length);
        assert (n3 == sqlJetMemPage.cellSizePtr(iSqlJetMemoryPointer) || n3 == 8 && n4 > 0);
        assert (sqlJetMemPage.pBt.mutex.held());
        if (sqlJetMemPage.nOverflow != 0 || n3 + 2 > sqlJetMemPage.nFree) {
            if (iSqlJetMemoryPointer2 != null) {
                SqlJetUtility.memcpy(iSqlJetMemoryPointer2, n5, iSqlJetMemoryPointer, n5, n3 - n5);
                iSqlJetMemoryPointer = iSqlJetMemoryPointer2;
            }
            if (n4 > 0) {
                SqlJetUtility.put4byte(iSqlJetMemoryPointer, n4);
            }
            int n6 = sqlJetMemPage.nOverflow++;
            sqlJetMemPage.aOvfl[n6].pCell = iSqlJetMemoryPointer;
            sqlJetMemPage.aOvfl[n6].idx = n2;
        } else {
            sqlJetMemPage.pDbPage.write();
            assert (sqlJetMemPage.pDbPage.isWriteable());
            ISqlJetMemoryPointer iSqlJetMemoryPointer3 = sqlJetMemPage.aData;
            byte by = sqlJetMemPage.hdrOffset;
            int n7 = SqlJetUtility.get2byte(iSqlJetMemoryPointer3, by + 5);
            int n8 = sqlJetMemPage.cellOffset;
            int n9 = n8 + 2 * sqlJetMemPage.nCell + 2;
            int n10 = n8 + 2 * n2;
            if (n9 > n7 - n3) {
                sqlJetMemPage.defragmentPage();
                n7 = SqlJetUtility.get2byte(iSqlJetMemoryPointer3, by + 5);
                assert (n9 + n3 <= n7);
            }
            int n11 = sqlJetMemPage.allocateSpace(n3);
            assert (n11 > 0);
            assert (n9 <= SqlJetUtility.get2byte(iSqlJetMemoryPointer3, by + 5));
            if (n11 + n3 > sqlJetMemPage.pBt.usableSize) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            ++sqlJetMemPage.nCell;
            sqlJetMemPage.nFree -= 2 + n3;
            SqlJetUtility.memcpy(iSqlJetMemoryPointer3, n11 + n5, iSqlJetMemoryPointer, n5, n3 - n5);
            if (n4 > 0) {
                SqlJetUtility.put4byte(iSqlJetMemoryPointer3, n11, n4);
            }
            for (int i2 = n9 - 2; i2 > n10; i2 -= 2) {
                SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer3, i2, SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer3, i2 - 2));
                SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer3, i2 + 1, SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer3, i2 - 1));
            }
            SqlJetUtility.put2byte(iSqlJetMemoryPointer3, n10, n11);
            SqlJetUtility.put2byte(iSqlJetMemoryPointer3, by + 3, sqlJetMemPage.nCell);
            if (sqlJetMemPage.pBt.autoVacuum) {
                SqlJetBtreeCellInfo sqlJetBtreeCellInfo = sqlJetMemPage.parseCellPtr(iSqlJetMemoryPointer);
                assert ((long)sqlJetBtreeCellInfo.nData + (sqlJetMemPage.intKey ? 0L : sqlJetBtreeCellInfo.nKey) == (long)sqlJetBtreeCellInfo.nPayload);
                if ((long)sqlJetBtreeCellInfo.nData + (sqlJetMemPage.intKey ? 0L : sqlJetBtreeCellInfo.nKey) > (long)sqlJetBtreeCellInfo.nLocal) {
                    int n12 = SqlJetUtility.get4byte(iSqlJetMemoryPointer, sqlJetBtreeCellInfo.iOverflow);
                    sqlJetMemPage.pBt.ptrmapPut(n12, (short)3, sqlJetMemPage.pgno);
                }
            }
        }
    }

    private int allocateSpace(int n2) {
        SqlJetMemPage sqlJetMemPage = this;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage.aData;
        assert (sqlJetMemPage.pDbPage.isWriteable());
        assert (sqlJetMemPage.pBt != null);
        assert (sqlJetMemPage.pBt.mutex.held());
        assert (n2 >= 0);
        assert (sqlJetMemPage.nFree >= n2);
        assert (sqlJetMemPage.nOverflow == 0);
        int n3 = sqlJetMemPage.pBt.usableSize;
        assert (n2 < n3 - 8);
        byte by = sqlJetMemPage.hdrOffset;
        int n4 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, by + 7);
        assert (sqlJetMemPage.cellOffset == by + 12 - 4 * (sqlJetMemPage.leaf ? 1 : 0));
        int n5 = sqlJetMemPage.cellOffset + 2 * sqlJetMemPage.nCell;
        int n6 = SqlJetUtility.get2byte(iSqlJetMemoryPointer.getMoved(by + 5));
        if (n5 > n6) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        if (n4 >= 60) {
            sqlJetMemPage.defragmentPage();
            n6 = SqlJetUtility.get2byte(iSqlJetMemoryPointer.getMoved(by + 5));
        } else if (n5 + 2 <= n6) {
            int n7;
            int n8 = by + 1;
            while ((n7 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, n8)) > 0) {
                if (n7 > n3 - 4 || n7 < n8 + 4) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                int n9 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, n7 + 2);
                if (n9 >= n2) {
                    int n10 = n9 - n2;
                    if (n10 < 4) {
                        SqlJetUtility.memcpy(iSqlJetMemoryPointer, n8, iSqlJetMemoryPointer, n7, 2);
                        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, by + 7, n4 + n10);
                    } else {
                        if (n9 + n7 > n3) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        SqlJetUtility.put2byte(iSqlJetMemoryPointer, n7 + 2, n10);
                    }
                    return n7 + n10;
                }
                n8 = n7;
            }
        }
        if (n5 + 2 + n2 > n6) {
            sqlJetMemPage.defragmentPage();
            n6 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, by + 5);
            assert (n5 + n2 <= n6);
        }
        SqlJetUtility.put2byte(iSqlJetMemoryPointer, by + 5, n6 -= n2);
        assert (n6 + n2 <= sqlJetMemPage.pBt.usableSize);
        return n6;
    }

    private void defragmentPage() {
        SqlJetMemPage sqlJetMemPage = this;
        assert (sqlJetMemPage.pDbPage.isWriteable());
        assert (sqlJetMemPage.pBt != null);
        assert (sqlJetMemPage.pBt.usableSize <= 32768);
        assert (sqlJetMemPage.nOverflow == 0);
        assert (sqlJetMemPage.pBt.mutex.held());
        ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage.pBt.pPager.getTempSpace();
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = sqlJetMemPage.aData;
        byte by = sqlJetMemPage.hdrOffset;
        int n2 = sqlJetMemPage.cellOffset;
        int n3 = sqlJetMemPage.nCell;
        assert (n3 == SqlJetUtility.get2byte(iSqlJetMemoryPointer2, by + 3));
        int n4 = sqlJetMemPage.pBt.usableSize;
        int n5 = SqlJetUtility.get2byte(iSqlJetMemoryPointer2, by + 5);
        SqlJetUtility.memcpy(iSqlJetMemoryPointer, n5, iSqlJetMemoryPointer2, n5, n4 - n5);
        n5 = n4;
        int n6 = n2 + 2 * n3;
        int n7 = n4 - 4;
        for (int i2 = 0; i2 < n3; ++i2) {
            ISqlJetMemoryPointer iSqlJetMemoryPointer3 = iSqlJetMemoryPointer2.getBuffer().getPointer(n2 + i2 * 2);
            int n8 = SqlJetUtility.get2byte(iSqlJetMemoryPointer3);
            if (n8 < n6 || n8 > n7) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            assert (n8 >= n6 && n8 <= n7);
            int n9 = sqlJetMemPage.cellSizePtr(iSqlJetMemoryPointer.getBuffer().getPointer(n8));
            if ((n5 -= n9) < n6 || n8 + n9 > n4) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            assert (n5 + n9 <= n4 && n5 >= n6);
            SqlJetUtility.memcpy(iSqlJetMemoryPointer2, n5, iSqlJetMemoryPointer, n8, n9);
            SqlJetUtility.put2byte(iSqlJetMemoryPointer3, n5);
        }
        assert (n5 >= n6);
        SqlJetUtility.put2byte(iSqlJetMemoryPointer2, by + 5, n5);
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer2, by + 1, 0);
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer2, by + 2, 0);
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer2, by + 7, 0);
        SqlJetUtility.memset(iSqlJetMemoryPointer2, n6, (byte)0, n5 - n6);
        assert (sqlJetMemPage.pDbPage.isWriteable());
        if (n5 - n6 != sqlJetMemPage.nFree) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    public ISqlJetMemoryPointer findOverflowCell(int n2) {
        SqlJetMemPage sqlJetMemPage = this;
        assert (sqlJetMemPage.pBt.mutex.held());
        for (int i2 = sqlJetMemPage.nOverflow - 1; i2 >= 0; --i2) {
            SqlJetMemPage$_OvflCell sqlJetMemPage$_OvflCell = sqlJetMemPage.aOvfl[i2];
            int n3 = sqlJetMemPage$_OvflCell.idx;
            if (n3 > n2) continue;
            if (n3 == n2) {
                return sqlJetMemPage$_OvflCell.pCell;
            }
            --n2;
        }
        return sqlJetMemPage.findCell(n2);
    }

    public void assemblePage(int n2, ISqlJetMemoryPointer[] iSqlJetMemoryPointerArray, int n3, int[] nArray, int n4) {
        SqlJetMemPage sqlJetMemPage = this;
        byte by = sqlJetMemPage.hdrOffset;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage.aData;
        int n5 = sqlJetMemPage.pBt.usableSize;
        assert (sqlJetMemPage.nOverflow == 0);
        assert (sqlJetMemPage.pBt.mutex.held());
        assert (n2 >= 0 && n2 <= sqlJetMemPage.pBt.MX_CELL() && sqlJetMemPage.pBt.MX_CELL() <= 10921);
        assert (sqlJetMemPage.pDbPage.isWriteable());
        assert (sqlJetMemPage.nCell == 0);
        assert (SqlJetUtility.get2byte(iSqlJetMemoryPointer.getMoved(by + 5)) == n5);
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = iSqlJetMemoryPointer.getMoved(sqlJetMemPage.cellOffset + n2 * 2);
        int n6 = n5;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n7 = nArray[n3 + i2];
            iSqlJetMemoryPointer2 = iSqlJetMemoryPointer2.getMoved(-2);
            SqlJetUtility.put2byte(iSqlJetMemoryPointer2, n6 -= n7);
            SqlJetUtility.memcpy(iSqlJetMemoryPointer.getMoved(n6), iSqlJetMemoryPointerArray[n3 + i2], n7);
        }
        SqlJetUtility.put2byte(iSqlJetMemoryPointer.getMoved(by + 3), n2);
        SqlJetUtility.put2byte(iSqlJetMemoryPointer.getMoved(by + 5), n6);
        sqlJetMemPage.nFree -= 2 * n2 + sqlJetMemPage.pBt.usableSize - n6;
        sqlJetMemPage.nCell = n2;
    }

    public void assertParentIndex(int n2, int n3) {
        SqlJetMemPage sqlJetMemPage = this;
        assert (n2 <= sqlJetMemPage.nCell);
        if (n2 == sqlJetMemPage.nCell ? !$assertionsDisabled && SqlJetUtility.get4byte(sqlJetMemPage.aData, sqlJetMemPage.hdrOffset + 8) != n3 : !$assertionsDisabled && SqlJetUtility.get4byte(sqlJetMemPage.findCell(n2)) != n3) {
            throw new AssertionError();
        }
    }

    public int fillInCell(ISqlJetMemoryPointer iSqlJetMemoryPointer, ISqlJetMemoryPointer iSqlJetMemoryPointer2, long l2, ISqlJetMemoryPointer iSqlJetMemoryPointer3, int n2, int n3) {
        int n4;
        ISqlJetMemoryPointer iSqlJetMemoryPointer4;
        SqlJetMemPage sqlJetMemPage = this;
        int n5 = 0;
        SqlJetMemPage sqlJetMemPage2 = null;
        SqlJetMemPage sqlJetMemPage3 = null;
        SqlJetBtreeShared sqlJetBtreeShared = sqlJetMemPage.pBt;
        int[] nArray = new int[]{0};
        assert (sqlJetMemPage.pBt.mutex.held());
        assert (iSqlJetMemoryPointer.getBuffer() != sqlJetMemPage.aData.getBuffer() || sqlJetMemPage.pDbPage.isWriteable());
        int n6 = 0;
        if (!sqlJetMemPage.leaf) {
            n6 += 4;
        }
        if (sqlJetMemPage.hasData) {
            n6 += SqlJetUtility.putVarint(SqlJetUtility.pointer(iSqlJetMemoryPointer, n6), n2 + n3);
        } else {
            n3 = 0;
            n2 = 0;
        }
        n6 += SqlJetUtility.putVarint(SqlJetUtility.pointer(iSqlJetMemoryPointer, n6), l2);
        SqlJetBtreeCellInfo sqlJetBtreeCellInfo = sqlJetMemPage.parseCellPtr(iSqlJetMemoryPointer);
        assert (sqlJetBtreeCellInfo.nHeader == n6);
        assert (sqlJetBtreeCellInfo.nKey == l2);
        assert (sqlJetBtreeCellInfo.nData == n2 + n3);
        int n7 = n2 + n3;
        if (sqlJetMemPage.intKey) {
            iSqlJetMemoryPointer4 = iSqlJetMemoryPointer3;
            n4 = n2;
            n2 = 0;
        } else {
            n7 += (int)l2;
            iSqlJetMemoryPointer4 = iSqlJetMemoryPointer2;
            n4 = (int)l2;
        }
        n5 = sqlJetBtreeCellInfo.nSize;
        int n8 = sqlJetBtreeCellInfo.nLocal;
        ISqlJetMemoryPointer iSqlJetMemoryPointer5 = SqlJetUtility.pointer(iSqlJetMemoryPointer, n6);
        ISqlJetMemoryPointer iSqlJetMemoryPointer6 = SqlJetUtility.pointer(iSqlJetMemoryPointer, sqlJetBtreeCellInfo.iOverflow);
        while (n7 > 0) {
            int n9;
            if (n8 == 0) {
                int n10 = nArray[0];
                if (sqlJetBtreeShared.autoVacuum) {
                    do {
                        nArray[0] = nArray[0] + 1;
                    } while (sqlJetBtreeShared.PTRMAP_ISPAGE(nArray[0]) || nArray[0] == sqlJetBtreeShared.PENDING_BYTE_PAGE());
                }
                try {
                    sqlJetMemPage2 = sqlJetBtreeShared.allocatePage(nArray, nArray[0], false);
                    if (sqlJetBtreeShared.autoVacuum) {
                        int n11 = n10 != 0 ? 4 : 3;
                        try {
                            sqlJetBtreeShared.ptrmapPut(nArray[0], (short)n11, n10);
                        }
                        catch (SqlJetException sqlJetException) {
                            SqlJetMemPage.releasePage(sqlJetMemPage2);
                        }
                    }
                }
                catch (SqlJetException sqlJetException) {
                    SqlJetMemPage.releasePage(sqlJetMemPage3);
                    throw sqlJetException;
                }
                assert (sqlJetMemPage3 == null || sqlJetMemPage3.pDbPage.isWriteable());
                assert (iSqlJetMemoryPointer6.getBuffer() != sqlJetMemPage.aData.getBuffer() || sqlJetMemPage.pDbPage.isWriteable());
                SqlJetUtility.put4byte(iSqlJetMemoryPointer6, nArray[0]);
                SqlJetMemPage.releasePage(sqlJetMemPage3);
                sqlJetMemPage3 = sqlJetMemPage2;
                iSqlJetMemoryPointer6 = sqlJetMemPage2.aData;
                SqlJetUtility.put4byte(iSqlJetMemoryPointer6, 0L);
                iSqlJetMemoryPointer5 = SqlJetUtility.pointer(sqlJetMemPage2.aData, 4);
                n8 = sqlJetBtreeShared.usableSize - 4;
            }
            if ((n9 = n7) > n8) {
                n9 = n8;
            }
            assert (sqlJetMemPage3 == null || sqlJetMemPage3.pDbPage.isWriteable());
            assert (iSqlJetMemoryPointer5.getBuffer() != sqlJetMemPage.aData.getBuffer() || sqlJetMemPage.pDbPage.isWriteable());
            if (n4 > 0) {
                if (n9 > n4) {
                    n9 = n4;
                }
                assert (iSqlJetMemoryPointer4 != null);
                SqlJetUtility.memcpy(iSqlJetMemoryPointer5, iSqlJetMemoryPointer4, n9);
            } else {
                SqlJetUtility.memset(iSqlJetMemoryPointer5, (byte)0, n9);
            }
            n7 -= n9;
            SqlJetUtility.movePtr(iSqlJetMemoryPointer5, n9);
            iSqlJetMemoryPointer4 = SqlJetUtility.pointer(iSqlJetMemoryPointer4, n9);
            n8 -= n9;
            if ((n4 -= n9) != 0) continue;
            n4 = n2;
            iSqlJetMemoryPointer4 = iSqlJetMemoryPointer3;
        }
        SqlJetMemPage.releasePage(sqlJetMemPage3);
        return n5;
    }

    public void ptrmapPutOvfl(int n2) {
        SqlJetMemPage sqlJetMemPage = this;
        assert (sqlJetMemPage.pBt.mutex.held());
        ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage.findOverflowCell(n2);
        sqlJetMemPage.ptrmapPutOvflPtr(iSqlJetMemoryPointer);
    }

    public void copyNodeContent(SqlJetMemPage sqlJetMemPage) {
        int n2;
        SqlJetMemPage sqlJetMemPage2 = this;
        SqlJetBtreeShared sqlJetBtreeShared = sqlJetMemPage2.pBt;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage2.aData;
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = sqlJetMemPage.aData;
        byte by = sqlJetMemPage2.hdrOffset;
        int n3 = n2 = sqlJetMemPage.pgno == 1 ? 100 : 0;
        assert (sqlJetMemPage2.isInit);
        assert (sqlJetMemPage2.nFree >= n2);
        assert (SqlJetUtility.get2byte(iSqlJetMemoryPointer.getMoved(by + 5)) <= sqlJetBtreeShared.usableSize);
        int n4 = SqlJetUtility.get2byte(iSqlJetMemoryPointer.getMoved(by + 5));
        SqlJetUtility.memcpy(iSqlJetMemoryPointer2.getMoved(n4), iSqlJetMemoryPointer.getMoved(n4), sqlJetBtreeShared.usableSize - n4);
        SqlJetUtility.memcpy(iSqlJetMemoryPointer2.getMoved(n2), iSqlJetMemoryPointer.getMoved(by), sqlJetMemPage2.cellOffset + 2 * sqlJetMemPage2.nCell);
        sqlJetMemPage.isInit = false;
        sqlJetMemPage.initPage();
        if (this.ISAUTOVACUUM()) {
            sqlJetMemPage.setChildPtrmaps();
        }
    }

    public Object clone() {
        SqlJetMemPage sqlJetMemPage = (SqlJetMemPage)super.clone();
        sqlJetMemPage.aData = SqlJetUtility.allocatePtr(sqlJetMemPage.pBt.pageSize);
        sqlJetMemPage.aOvfl = (SqlJetMemPage$_OvflCell[])this.aOvfl.clone();
        for (int i2 = 0; i2 < this.aOvfl.length; ++i2) {
            sqlJetMemPage.aOvfl[i2] = (SqlJetMemPage$_OvflCell)this.aOvfl[i2].clone();
        }
        return sqlJetMemPage;
    }
}

