/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.sqljet.core.ISqlJetMutex;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree$TransMode;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCellInfo;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCursor$CursorState;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.mutex.SqlJetEmptyMutex;

public class SqlJetBtreeShared {
    public static final byte PTRMAP_ROOTPAGE = 1;
    public static final byte PTRMAP_FREEPAGE = 2;
    public static final byte PTRMAP_OVERFLOW1 = 3;
    public static final byte PTRMAP_OVERFLOW2 = 4;
    public static final byte PTRMAP_BTREE = 5;
    ISqlJetPager pPager;
    ISqlJetDbHandle db;
    SqlJetBtreeCursor pCursor;
    SqlJetMemPage pPage1;
    boolean inStmt;
    boolean readOnly;
    boolean pageSizeFixed;
    boolean autoVacuum;
    boolean incrVacuum;
    int pageSize;
    int usableSize;
    int maxLocal;
    int minLocal;
    int maxLeaf;
    int minLeaf;
    SqlJetBtree$TransMode inTransaction = SqlJetBtree$TransMode.NONE;
    int nTransaction;
    Object pSchema;
    ISqlJetMutex mutex = new SqlJetEmptyMutex();
    int nRef;
    SqlJetBtreeShared pNext;
    List pLock = new LinkedList();
    SqlJetBtree pExclusive;
    ISqlJetMemoryPointer pTmpSpace;

    public int PENDING_BYTE_PAGE() {
        return (int)(0x40000000L / (long)this.pageSize) + 1;
    }

    public int MX_CELL_SIZE() {
        return this.pageSize - 8;
    }

    public int MX_CELL() {
        return (this.pageSize - 8) / 6;
    }

    public int PTRMAP_PAGENO(int n2) {
        return this.ptrmapPageno(n2);
    }

    boolean PTRMAP_ISPAGE(int n2) {
        return this.PTRMAP_PAGENO(n2) == n2;
    }

    private int PTRMAP_PTROFFSET(int n2, int n3) {
        return 5 * (n3 - n2 - 1);
    }

    public void invalidateAllOverflowCache() {
        assert (this.mutex.held());
        SqlJetBtreeCursor sqlJetBtreeCursor = this.pCursor;
        while (sqlJetBtreeCursor != null) {
            sqlJetBtreeCursor.aOverflow = null;
            sqlJetBtreeCursor = sqlJetBtreeCursor.pNext;
        }
    }

    int getPageCount() {
        assert (this.pPage1 != null);
        return this.pPager.getPageCount();
    }

    private int ptrmapPageno(int n2) {
        assert (this.mutex.held());
        int n3 = this.usableSize / 5 + 1;
        int n4 = (n2 - 2) / n3;
        int n5 = n4 * n3 + 2;
        if (n5 == this.PENDING_BYTE_PAGE()) {
            ++n5;
        }
        return n5;
    }

    public void ptrmapPut(int n2, short s2, int n3) {
        assert (this.mutex.held());
        assert (!this.PTRMAP_ISPAGE(this.PENDING_BYTE_PAGE()));
        assert (this.autoVacuum);
        if (n2 == 0) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        int n4 = this.PTRMAP_PAGENO(n2);
        ISqlJetPage iSqlJetPage = this.pPager.getPage(n4);
        int n5 = this.PTRMAP_PTROFFSET(n4, n2);
        ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetPage.getData();
        if (s2 != SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n5) || SqlJetUtility.get4byte(iSqlJetMemoryPointer, n5 + 1) != n3) {
            SqlJetBtree.TRACE("PTRMAP_UPDATE: %d->(%d,%d)\n", n2, s2, n3);
            iSqlJetPage.write();
            SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, n5, s2);
            SqlJetUtility.put4byte(iSqlJetMemoryPointer, n5 + 1, n3);
        }
        iSqlJetPage.unref();
    }

    public void ptrmapGet(int n2, short[] sArray, int[] nArray) {
        assert (this.mutex.held());
        int n3 = this.PTRMAP_PAGENO(n2);
        ISqlJetPage iSqlJetPage = this.pPager.acquirePage(n3, true);
        ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetPage.getData();
        int n4 = this.PTRMAP_PTROFFSET(n3, n2);
        assert (sArray != null && sArray.length > 0);
        sArray[0] = (short)SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n4);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = SqlJetUtility.get4byte(iSqlJetMemoryPointer, n4 + 1);
        }
        iSqlJetPage.unref();
        if (sArray[0] < 1 || sArray[0] > 5) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private SqlJetMemPage pageFromDbPage(ISqlJetPage iSqlJetPage, int n2) {
        if (null == iSqlJetPage.getExtra()) {
            iSqlJetPage.setExtra(new SqlJetMemPage());
        }
        SqlJetMemPage sqlJetMemPage = (SqlJetMemPage)iSqlJetPage.getExtra();
        sqlJetMemPage.aData = iSqlJetPage.getData();
        sqlJetMemPage.pDbPage = iSqlJetPage;
        sqlJetMemPage.pBt = this;
        sqlJetMemPage.pgno = n2;
        sqlJetMemPage.hdrOffset = (byte)(sqlJetMemPage.pgno == 1 ? 100 : 0);
        return sqlJetMemPage;
    }

    public SqlJetMemPage getPage(int n2, boolean bl2) {
        assert (this.mutex.held());
        ISqlJetPage iSqlJetPage = this.pPager.acquirePage(n2, !bl2);
        return this.pageFromDbPage(iSqlJetPage, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlJetMemPage allocatePage(int[] nArray, int n2, boolean bl2) {
        SqlJetMemPage sqlJetMemPage = null;
        SqlJetMemPage sqlJetMemPage2 = null;
        SqlJetMemPage sqlJetMemPage3 = null;
        assert (this.mutex.held());
        long l2 = SqlJetUtility.get4byteUnsigned(this.pPage1.aData, 36);
        try {
            if (l2 > 0L) {
                Object object;
                boolean bl3 = false;
                if (bl2 && n2 <= this.getPageCount()) {
                    object = new short[]{0};
                    assert (n2 > 0);
                    assert (this.autoVacuum);
                    this.ptrmapGet(n2, (short[])object, null);
                    if (object[0] == 2) {
                        bl3 = true;
                    }
                    nArray[0] = n2;
                }
                this.pPage1.pDbPage.write();
                SqlJetUtility.put4byteUnsigned(this.pPage1.aData, 36, l2 - 1L);
                do {
                    int n3 = (sqlJetMemPage3 = sqlJetMemPage2) != null ? SqlJetUtility.get4byte(sqlJetMemPage3.aData, 0) : SqlJetUtility.get4byte(this.pPage1.aData, 32);
                    try {
                        sqlJetMemPage2 = this.getPage(n3, false);
                    }
                    catch (SqlJetException sqlJetException) {
                        sqlJetMemPage2 = null;
                        throw sqlJetException;
                    }
                    int n4 = SqlJetUtility.get4byte(sqlJetMemPage2.aData, 4);
                    if (n4 == 0 && !bl3) {
                        assert (sqlJetMemPage3 == null);
                        sqlJetMemPage2.pDbPage.write();
                        nArray[0] = n3;
                        SqlJetUtility.memcpy(this.pPage1.aData, 32, sqlJetMemPage2.aData, 0, 4);
                        sqlJetMemPage = sqlJetMemPage2;
                        sqlJetMemPage2 = null;
                        SqlJetBtree.TRACE("ALLOCATE: %d trunk - %d free pages left\n", nArray[0], l2 - 1L);
                    } else {
                        int n5;
                        if (n4 > this.usableSize / 4 - 2) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        if (bl3 && n2 == n3) {
                            assert (nArray[0] == n3);
                            sqlJetMemPage = sqlJetMemPage2;
                            bl3 = false;
                            sqlJetMemPage2.pDbPage.write();
                            if (n4 == 0) {
                                if (sqlJetMemPage3 == null) {
                                    SqlJetUtility.memcpy(this.pPage1.aData, 32, sqlJetMemPage2.aData, 0, 4);
                                } else {
                                    SqlJetUtility.memcpy(sqlJetMemPage3.aData, 0, sqlJetMemPage2.aData, 0, 4);
                                }
                            } else {
                                n5 = SqlJetUtility.get4byte(sqlJetMemPage2.aData, 8);
                                object = this.getPage(n5, false);
                                try {
                                    object.pDbPage.write();
                                }
                                catch (SqlJetException sqlJetException) {
                                    SqlJetMemPage.releasePage((SqlJetMemPage)object);
                                    throw sqlJetException;
                                }
                                SqlJetUtility.memcpy(object.aData, 0, sqlJetMemPage2.aData, 0, 4);
                                SqlJetUtility.put4byte(object.aData, 4, n4 - 1);
                                SqlJetUtility.memcpy(object.aData, 8, sqlJetMemPage2.aData, 12, (n4 - 1) * 4);
                                SqlJetMemPage.releasePage((SqlJetMemPage)object);
                                if (sqlJetMemPage3 == null) {
                                    SqlJetUtility.put4byte(this.pPage1.aData, 32, n5);
                                } else {
                                    sqlJetMemPage3.pDbPage.write();
                                    SqlJetUtility.put4byte(sqlJetMemPage3.aData, 0, n5);
                                }
                            }
                            sqlJetMemPage2 = null;
                            SqlJetBtree.TRACE("ALLOCATE: %d trunk - %d free pages left\n", nArray[0], l2 - 1L);
                        } else {
                            int n6;
                            int n7;
                            ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage2.aData;
                            sqlJetMemPage2.pDbPage.write();
                            if (n2 > 0) {
                                n7 = 0;
                                int n8 = SqlJetUtility.get4byte(iSqlJetMemoryPointer, 8) - n2;
                                if (n8 < 0) {
                                    n8 = -n8;
                                }
                                for (n6 = 1; n6 < n4; ++n6) {
                                    int n9 = SqlJetUtility.get4byte(iSqlJetMemoryPointer, 8 + n6 * 4) - n2;
                                    if (n9 < 0) {
                                        n9 = -n9;
                                    }
                                    if (n9 >= n8) continue;
                                    n7 = n6;
                                    n8 = n9;
                                }
                            } else {
                                n7 = 0;
                            }
                            n5 = SqlJetUtility.get4byte(iSqlJetMemoryPointer, 8 + n7 * 4);
                            if (!bl3 || n5 == n2) {
                                nArray[0] = n5;
                                n6 = this.getPageCount();
                                if (nArray[0] > n6) {
                                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                                }
                                SqlJetBtree.TRACE("ALLOCATE: %d was leaf %d of %d on trunk %d: %d more free pages\n", nArray[0], n7 + 1, n4, sqlJetMemPage2.pgno, l2 - 1L);
                                if (n7 < n4 - 1) {
                                    SqlJetUtility.memcpy(iSqlJetMemoryPointer, 8 + n7 * 4, iSqlJetMemoryPointer, 4 + n4 * 4, 4);
                                }
                                SqlJetUtility.put4byte(iSqlJetMemoryPointer, 4, n4 - 1);
                                sqlJetMemPage = this.getPage(nArray[0], true);
                                sqlJetMemPage.pDbPage.dontRollback();
                                try {
                                    sqlJetMemPage.pDbPage.write();
                                }
                                catch (SqlJetException sqlJetException) {
                                    SqlJetMemPage.releasePage(sqlJetMemPage);
                                }
                                bl3 = false;
                            }
                        }
                    }
                    SqlJetMemPage.releasePage(sqlJetMemPage3);
                    sqlJetMemPage3 = null;
                } while (bl3);
            } else {
                int n10 = this.getPageCount();
                nArray[0] = n10 + 1;
                if (this.autoVacuum && this.PTRMAP_ISPAGE(nArray[0])) {
                    SqlJetBtree.TRACE("ALLOCATE: %d from end of file (pointer-map page)\n", nArray[0]);
                    assert (nArray[0] != this.PENDING_BYTE_PAGE());
                    nArray[0] = nArray[0] + 1;
                    if (nArray[0] == this.PENDING_BYTE_PAGE()) {
                        nArray[0] = nArray[0] + 1;
                    }
                }
                assert (nArray[0] != this.PENDING_BYTE_PAGE());
                sqlJetMemPage = this.getPage(nArray[0], false);
                try {
                    sqlJetMemPage.pDbPage.write();
                }
                catch (SqlJetException sqlJetException) {
                    SqlJetMemPage.releasePage(sqlJetMemPage);
                }
                SqlJetBtree.TRACE("ALLOCATE: %d from end of file\n", nArray[0]);
            }
            assert (nArray[0] != this.PENDING_BYTE_PAGE());
            Object var19_23 = null;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            SqlJetMemPage.releasePage(sqlJetMemPage2);
            SqlJetMemPage.releasePage(sqlJetMemPage3);
            throw throwable;
        }
        SqlJetMemPage.releasePage(sqlJetMemPage2);
        SqlJetMemPage.releasePage(sqlJetMemPage3);
        if (sqlJetMemPage.pDbPage.getRefCount() > 1) {
            SqlJetMemPage.releasePage(sqlJetMemPage);
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        sqlJetMemPage.isInit = false;
        return sqlJetMemPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relocatePage(SqlJetMemPage sqlJetMemPage, short s2, int n2, int n3, boolean bl2) {
        int n4 = sqlJetMemPage.pgno;
        assert (s2 == 4 || s2 == 3 || s2 == 5 || s2 == 1);
        assert (this.mutex.held());
        assert (sqlJetMemPage.pBt == this);
        SqlJetBtree.TRACE("AUTOVACUUM: Moving %d to free page %d (ptr page %d type %d)\n", n4, n3, n2, s2);
        sqlJetMemPage.pDbPage.move(n3, bl2);
        sqlJetMemPage.pgno = n3;
        if (s2 == 5 || s2 == 1) {
            sqlJetMemPage.setChildPtrmaps();
        } else {
            int n5 = SqlJetUtility.get4byte(sqlJetMemPage.aData);
            if (n5 != 0) {
                this.ptrmapPut(n5, (short)4, n3);
            }
        }
        if (s2 != 1) {
            SqlJetMemPage sqlJetMemPage2 = this.getPage(n2, false);
            try {
                sqlJetMemPage2.pDbPage.write();
            }
            catch (SqlJetException sqlJetException) {
                SqlJetMemPage.releasePage(sqlJetMemPage2);
                throw sqlJetException;
            }
            try {
                sqlJetMemPage2.modifyPagePointer(n4, n3, s2);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                SqlJetMemPage.releasePage(sqlJetMemPage2);
                throw throwable;
            }
            SqlJetMemPage.releasePage(sqlJetMemPage2);
            this.ptrmapPut(n3, s2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrVacuumStep(int n2, int n3) {
        assert (this.mutex.held());
        if (!this.PTRMAP_ISPAGE(n3) && n3 != this.PENDING_BYTE_PAGE()) {
            SqlJetMemPage sqlJetMemPage;
            int[] nArray;
            short[] sArray = new short[]{0};
            int[] nArray2 = new int[]{0};
            int n4 = SqlJetUtility.get4byte(this.pPage1.aData, 36);
            if (n4 == 0 || n2 == n3) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            this.ptrmapGet(n3, sArray, nArray2);
            if (sArray[0] == 1) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            if (sArray[0] == 2) {
                if (n2 == 0) {
                    nArray = new int[1];
                    sqlJetMemPage = this.allocatePage(nArray, n3, true);
                    assert (nArray[0] == n3);
                    SqlJetMemPage.releasePage(sqlJetMemPage);
                }
            } else {
                nArray = new int[1];
                sqlJetMemPage = this.getPage(n3, false);
                do {
                    SqlJetMemPage sqlJetMemPage2;
                    try {
                        sqlJetMemPage2 = this.allocatePage(nArray, 0, false);
                    }
                    catch (SqlJetException sqlJetException) {
                        SqlJetMemPage.releasePage(sqlJetMemPage);
                        throw sqlJetException;
                    }
                    SqlJetMemPage.releasePage(sqlJetMemPage2);
                } while (n2 != 0 && nArray[0] > n2);
                assert (nArray[0] < n3);
                sqlJetMemPage.pDbPage.write();
                try {
                    this.relocatePage(sqlJetMemPage, sArray[0], nArray2[0], nArray[0], n2 != 0);
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    SqlJetMemPage.releasePage(sqlJetMemPage);
                    throw throwable;
                }
                SqlJetMemPage.releasePage(sqlJetMemPage);
                {
                }
            }
        }
        if (n2 == 0) {
            --n3;
            while (n3 == this.PENDING_BYTE_PAGE() || this.PTRMAP_ISPAGE(n3)) {
                --n3;
            }
            this.pPager.truncateImage(n3);
        }
    }

    public void autoVacuumCommit() {
        int n2 = this.pPager.getRefCount();
        assert (this.mutex.held());
        this.invalidateAllOverflowCache();
        assert (this.autoVacuum);
        if (!this.incrVacuum) {
            int n3 = this.pageSize;
            int n4 = this.getPageCount();
            if (this.PTRMAP_ISPAGE(n4)) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            if (n4 == this.PENDING_BYTE_PAGE()) {
                --n4;
            }
            int n5 = SqlJetUtility.get4byte(this.pPage1.aData, 36);
            int n6 = (n5 - n4 + this.PTRMAP_PAGENO(n4) + n3 / 5) / (n3 / 5);
            int n7 = n4 - n5 - n6;
            if (n4 > this.PENDING_BYTE_PAGE() && n7 <= this.PENDING_BYTE_PAGE()) {
                --n7;
            }
            while (this.PTRMAP_ISPAGE(n7) || n7 == this.PENDING_BYTE_PAGE()) {
                --n7;
            }
            try {
                block14: {
                    try {
                        for (int i2 = n4; i2 > n7; --i2) {
                            this.incrVacuumStep(n7, i2);
                        }
                    }
                    catch (SqlJetException sqlJetException) {
                        if (sqlJetException.getErrorCode() == SqlJetErrorCode.DONE) break block14;
                        throw sqlJetException;
                    }
                }
                if (n5 > 0) {
                    this.pPage1.pDbPage.write();
                    SqlJetUtility.put4byte(this.pPage1.aData, 32, 0L);
                    SqlJetUtility.put4byte(this.pPage1.aData, 36, 0L);
                    this.pPager.truncateImage(n7);
                }
            }
            catch (SqlJetException sqlJetException) {
                this.pPager.rollback();
                throw sqlJetException;
            }
        }
        assert (n2 == this.pPager.getRefCount());
    }

    public void unlockBtreeIfUnused() {
        assert (this.mutex.held());
        if (this.inTransaction == SqlJetBtree$TransMode.NONE && this.pCursor == null && this.pPage1 != null) {
            if (this.pPager.getRefCount() >= 1) {
                assert (this.pPage1.aData != null);
                SqlJetMemPage.releasePage(this.pPage1);
            }
            this.pPage1 = null;
            this.inStmt = false;
        }
    }

    public boolean saveAllCursors(int n2, SqlJetBtreeCursor sqlJetBtreeCursor) {
        assert (this.mutex.held());
        assert (sqlJetBtreeCursor == null || sqlJetBtreeCursor.pBt == this);
        SqlJetBtreeCursor sqlJetBtreeCursor2 = this.pCursor;
        while (sqlJetBtreeCursor2 != null) {
            if (!(sqlJetBtreeCursor2 == sqlJetBtreeCursor || 0 != n2 && sqlJetBtreeCursor2.pgnoRoot != n2 || sqlJetBtreeCursor2.eState != SqlJetBtreeCursor$CursorState.VALID || sqlJetBtreeCursor2.saveCursorPosition())) {
                return false;
            }
            sqlJetBtreeCursor2 = sqlJetBtreeCursor2.pNext;
        }
        return true;
    }

    public int countWriteCursors() {
        int n2 = 0;
        SqlJetBtreeCursor sqlJetBtreeCursor = this.pCursor;
        while (sqlJetBtreeCursor != null) {
            if (sqlJetBtreeCursor.wrFlag && sqlJetBtreeCursor.eState != SqlJetBtreeCursor$CursorState.FAULT) {
                ++n2;
            }
            sqlJetBtreeCursor = sqlJetBtreeCursor.pNext;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDatabasePage(int n2, boolean bl2, int[] nArray) {
        SqlJetMemPage sqlJetMemPage = null;
        assert (this.mutex.held());
        if (n2 > this.pPager.getPageCount()) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        try {
            sqlJetMemPage = this.getAndInitPage(n2);
            for (int i2 = 0; i2 < sqlJetMemPage.nCell; ++i2) {
                ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage.findCell(i2);
                if (!sqlJetMemPage.leaf) {
                    this.clearDatabasePage(SqlJetUtility.get4byte(iSqlJetMemoryPointer), true, nArray);
                }
                sqlJetMemPage.clearCell(iSqlJetMemoryPointer);
            }
            if (!sqlJetMemPage.leaf) {
                this.clearDatabasePage(SqlJetUtility.get4byte(sqlJetMemPage.aData, 8), true, nArray);
            } else if (nArray != null) {
                assert (sqlJetMemPage.intKey);
                nArray[0] = nArray[0] + sqlJetMemPage.nCell;
            }
            if (bl2) {
                sqlJetMemPage.freePage();
            } else {
                sqlJetMemPage.pDbPage.write();
                sqlJetMemPage.zeroPage(SqlJetUtility.getUnsignedByte(sqlJetMemPage.aData, 0) | 8);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            SqlJetMemPage.releasePage(sqlJetMemPage);
            throw throwable;
        }
        SqlJetMemPage.releasePage(sqlJetMemPage);
    }

    SqlJetMemPage getAndInitPage(int n2) {
        ISqlJetPage iSqlJetPage = null;
        SqlJetMemPage sqlJetMemPage = null;
        assert (this.mutex.held());
        if (n2 == 0) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        try {
            iSqlJetPage = this.pPager.lookupPage(n2);
            if (iSqlJetPage != null) {
                sqlJetMemPage = this.pageFromDbPage(iSqlJetPage, n2);
            } else {
                if (n2 > this.pPager.getPageCount()) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                sqlJetMemPage = this.getPage(n2, false);
            }
            if (!sqlJetMemPage.isInit) {
                sqlJetMemPage.initPage();
            }
        }
        catch (SqlJetException sqlJetException) {
            SqlJetMemPage.releasePage(sqlJetMemPage);
            throw sqlJetException;
        }
        return sqlJetMemPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getOverflowPage(int n2, SqlJetMemPage[] sqlJetMemPageArray, int[] nArray) {
        Object object;
        int n3 = 0;
        assert (this.mutex.held());
        if (!($assertionsDisabled || sqlJetMemPageArray != null && sqlJetMemPageArray.length != 0)) {
            if (nArray == null) throw new AssertionError();
            if (nArray.length == 0) {
                throw new AssertionError();
            }
        }
        if (nArray == null || nArray.length == 0 || nArray[0] == 0) {
            sqlJetMemPageArray[0] = this.getPage(n2, true);
            return;
        }
        if (this.autoVacuum) {
            int n4;
            object = new int[]{0};
            short[] sArray = new short[]{0};
            for (n4 = n2 + 1; this.PTRMAP_ISPAGE(n4) || n4 == this.PENDING_BYTE_PAGE(); ++n4) {
            }
            if (n4 <= this.pPager.getPageCount()) {
                this.ptrmapGet(n4, sArray, (int[])object);
                if (sArray[0] == 4 && object[0] == n2) {
                    n3 = n4;
                }
            }
        }
        if (n3 == 0 || sqlJetMemPageArray != null && sqlJetMemPageArray.length != 0) {
            block15: {
                object = null;
                try {
                    object = this.getPage(n2, n3 != 0);
                    Object var9_8 = null;
                    if (n3 != 0 || object == null) break block15;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (n3 == 0 && object != null) {
                        n3 = SqlJetUtility.get4byte(object.aData, 0);
                    }
                    if (sqlJetMemPageArray != null && sqlJetMemPageArray.length != 0) {
                        sqlJetMemPageArray[0] = object;
                        throw throwable;
                    }
                    SqlJetMemPage.releasePage((SqlJetMemPage)object);
                    throw throwable;
                }
                n3 = SqlJetUtility.get4byte(object.aData, 0);
            }
            if (sqlJetMemPageArray != null && sqlJetMemPageArray.length != 0) {
                sqlJetMemPageArray[0] = object;
            } else {
                SqlJetMemPage.releasePage((SqlJetMemPage)object);
            }
        }
        nArray[0] = n3;
    }

    public void allocateTempSpace() {
        if (this.pTmpSpace == null) {
            this.pTmpSpace = SqlJetUtility.allocatePtr(this.pageSize);
        }
    }

    public void ptrmapPutOvflPtr(SqlJetMemPage sqlJetMemPage, ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        assert (iSqlJetMemoryPointer != null);
        SqlJetBtreeCellInfo sqlJetBtreeCellInfo = sqlJetMemPage.parseCellPtr(iSqlJetMemoryPointer);
        assert ((long)sqlJetBtreeCellInfo.nData + (sqlJetMemPage.intKey ? 0L : sqlJetBtreeCellInfo.nKey) == (long)sqlJetBtreeCellInfo.nPayload);
        if (sqlJetBtreeCellInfo.iOverflow > 0) {
            int n2 = SqlJetUtility.get4byte(iSqlJetMemoryPointer.getMoved(sqlJetBtreeCellInfo.iOverflow));
            sqlJetMemPage.pBt.ptrmapPut(n2, (short)3, sqlJetMemPage.pgno);
        }
    }
}

