/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import java.util.Arrays;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetConfig;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree$TransMode;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCellInfo;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCursor$CursorState;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;

public class SqlJetBtreeCursor
extends SqlJetCloneable
implements ISqlJetBtreeCursor {
    private static final int NN = 1;
    private static final int NB = 3;
    SqlJetBtree pBtree;
    SqlJetBtreeShared pBt;
    SqlJetBtreeCursor pNext;
    SqlJetBtreeCursor pPrev;
    ISqlJetKeyInfo pKeyInfo;
    int pgnoRoot;
    SqlJetBtreeCellInfo info = new SqlJetBtreeCellInfo();
    boolean wrFlag;
    boolean atLast;
    boolean validNKey;
    SqlJetBtreeCursor$CursorState eState;
    ISqlJetMemoryPointer pKey;
    long nKey;
    SqlJetErrorCode error;
    int skip;
    boolean isIncrblobHandle;
    int[] aOverflow;
    boolean pagesShuffled;
    int iPage;
    SqlJetMemPage[] apPage = new SqlJetMemPage[20];
    int[] aiIdx = new int[20];

    public SqlJetBtreeCursor(SqlJetBtree sqlJetBtree, int n2, boolean bl2, ISqlJetKeyInfo iSqlJetKeyInfo) {
        SqlJetBtreeShared sqlJetBtreeShared = sqlJetBtree.pBt;
        assert (sqlJetBtree.holdsMutex());
        if (bl2) {
            assert (!sqlJetBtreeShared.readOnly);
            if (sqlJetBtreeShared.readOnly) {
                throw new SqlJetException(SqlJetErrorCode.READONLY);
            }
            if (sqlJetBtree.checkReadLocks(n2, null, 0L)) {
                throw new SqlJetException(SqlJetErrorCode.LOCKED);
            }
        }
        if (sqlJetBtreeShared.pPage1 == null) {
            sqlJetBtree.lockWithRetry();
        }
        this.pgnoRoot = n2;
        int n3 = sqlJetBtreeShared.pPager.getPageCount();
        try {
            if (n2 == 1 && n3 == 0) {
                throw new SqlJetException(SqlJetErrorCode.EMPTY);
            }
            this.apPage[0] = sqlJetBtreeShared.getAndInitPage(this.pgnoRoot);
            this.pKeyInfo = iSqlJetKeyInfo;
            this.pBtree = sqlJetBtree;
            this.pBt = sqlJetBtreeShared;
            this.wrFlag = bl2;
            this.pNext = sqlJetBtreeShared.pCursor;
            if (this.pNext != null) {
                this.pNext.pPrev = this;
            }
            sqlJetBtreeShared.pCursor = this;
            this.eState = SqlJetBtreeCursor$CursorState.INVALID;
        }
        catch (SqlJetException sqlJetException) {
            SqlJetMemPage.releasePage(this.apPage[0]);
            sqlJetBtreeShared.unlockBtreeIfUnused();
            throw sqlJetException;
        }
    }

    private boolean holdsMutex() {
        return this.pBt.mutex.held();
    }

    private boolean cursorHoldsMutex(SqlJetBtreeCursor sqlJetBtreeCursor) {
        return sqlJetBtreeCursor.holdsMutex();
    }

    public void clearCursor() {
        assert (this.holdsMutex());
        this.pKey = null;
        this.eState = SqlJetBtreeCursor$CursorState.INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCursor() {
        if (this.pBtree != null) {
            this.pBtree.enter();
            try {
                this.pBt.db = this.pBtree.db;
                this.clearCursor();
                if (this.pPrev != null) {
                    this.pPrev.pNext = this.pNext;
                } else {
                    this.pBt.pCursor = this.pNext;
                }
                if (this.pNext != null) {
                    this.pNext.pPrev = this.pPrev;
                }
                for (int i2 = 0; i2 <= this.iPage; ++i2) {
                    SqlJetMemPage.releasePage(this.apPage[i2]);
                }
                this.pBt.unlockBtreeIfUnused();
                this.invalidateOverflowCache();
                Object var3_2 = null;
                SqlJetBtree sqlJetBtree = this.pBtree;
                this.pBtree = null;
                sqlJetBtree.leave();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                SqlJetBtree sqlJetBtree = this.pBtree;
                this.pBtree = null;
                sqlJetBtree.leave();
                throw throwable;
            }
        }
    }

    private void invalidateOverflowCache() {
        assert (this.holdsMutex());
        this.aOverflow = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveTo(ISqlJetMemoryPointer iSqlJetMemoryPointer, long l2, boolean bl2) {
        int n2;
        SqlJetUnpackedRecord sqlJetUnpackedRecord;
        block8: {
            if (iSqlJetMemoryPointer != null) {
                assert (l2 == (long)((int)l2));
                sqlJetUnpackedRecord = this.pKeyInfo.recordUnpack((int)l2, iSqlJetMemoryPointer);
                if (sqlJetUnpackedRecord == null) {
                    throw new SqlJetException(SqlJetErrorCode.NOMEM);
                }
            } else {
                sqlJetUnpackedRecord = null;
            }
            try {
                n2 = this.moveToUnpacked(sqlJetUnpackedRecord, l2, bl2);
                Object var8_6 = null;
                if (iSqlJetMemoryPointer == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var8_7 = null;
                    if (iSqlJetMemoryPointer != null) {
                        SqlJetUnpackedRecord.delete(sqlJetUnpackedRecord);
                    }
                    if (sqlJetUnpackedRecord == null) break block9;
                    sqlJetUnpackedRecord.release();
                }
                throw throwable;
            }
            SqlJetUnpackedRecord.delete(sqlJetUnpackedRecord);
        }
        if (sqlJetUnpackedRecord != null) {
            sqlJetUnpackedRecord.release();
        }
        return n2;
    }

    private void moveToRoot() {
        int n2;
        assert (this.holdsMutex());
        assert (SqlJetBtreeCursor$CursorState.INVALID.compareTo(SqlJetBtreeCursor$CursorState.REQUIRESEEK) < 0);
        assert (SqlJetBtreeCursor$CursorState.VALID.compareTo(SqlJetBtreeCursor$CursorState.REQUIRESEEK) < 0);
        assert (SqlJetBtreeCursor$CursorState.FAULT.compareTo(SqlJetBtreeCursor$CursorState.REQUIRESEEK) > 0);
        if (this.eState.compareTo(SqlJetBtreeCursor$CursorState.REQUIRESEEK) >= 0) {
            if (this.eState == SqlJetBtreeCursor$CursorState.FAULT) {
                throw new SqlJetException(this.error);
            }
            this.clearCursor();
        }
        if (this.iPage >= 0) {
            for (n2 = 1; n2 <= this.iPage; ++n2) {
                SqlJetMemPage.releasePage(this.apPage[n2]);
            }
        } else {
            try {
                this.apPage[0] = this.pBt.getAndInitPage(this.pgnoRoot);
            }
            catch (SqlJetException sqlJetException) {
                this.eState = SqlJetBtreeCursor$CursorState.INVALID;
                throw sqlJetException;
            }
        }
        SqlJetMemPage sqlJetMemPage = this.apPage[0];
        assert (sqlJetMemPage.pgno == this.pgnoRoot);
        this.iPage = 0;
        this.aiIdx[0] = 0;
        this.info.nSize = 0;
        this.atLast = false;
        this.validNKey = false;
        if (sqlJetMemPage.nCell == 0 && !sqlJetMemPage.leaf) {
            assert (sqlJetMemPage.pgno == 1);
            n2 = SqlJetUtility.get4byte(sqlJetMemPage.aData, sqlJetMemPage.hdrOffset + 8);
            assert (n2 > 0);
            this.eState = SqlJetBtreeCursor$CursorState.VALID;
            this.moveToChild(n2);
        } else {
            this.eState = sqlJetMemPage.nCell > 0 ? SqlJetBtreeCursor$CursorState.VALID : SqlJetBtreeCursor$CursorState.INVALID;
        }
    }

    private void moveToChild(int n2) {
        SqlJetMemPage sqlJetMemPage;
        int n3 = this.iPage;
        assert (this.holdsMutex());
        assert (this.eState == SqlJetBtreeCursor$CursorState.VALID);
        assert (this.iPage < 20);
        if (this.iPage >= 19) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        this.apPage[n3 + 1] = sqlJetMemPage = this.pBt.getAndInitPage(n2);
        this.aiIdx[n3 + 1] = 0;
        ++this.iPage;
        this.info.nSize = 0;
        this.validNKey = false;
        if (sqlJetMemPage.nCell < 1) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private void getCellInfo() {
        if (this.info.nSize == 0) {
            this.info = this.apPage[this.iPage].parseCell(this.aiIdx[this.iPage]);
            this.validNKey = true;
        }
    }

    private ISqlJetMemoryPointer fetchPayload(int[] nArray, boolean bl2) {
        int n2;
        assert (this.iPage >= 0 && this.apPage[this.iPage] != null);
        assert (this.eState == SqlJetBtreeCursor$CursorState.VALID);
        assert (this.holdsMutex());
        SqlJetMemPage sqlJetMemPage = this.apPage[this.iPage];
        assert (this.aiIdx[this.iPage] < sqlJetMemPage.nCell);
        this.getCellInfo();
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.pointer(this.info.pCell, this.info.nHeader);
        int n3 = sqlJetMemPage.intKey ? 0 : (int)this.info.nKey;
        if (bl2) {
            SqlJetUtility.movePtr(iSqlJetMemoryPointer, n3);
            n2 = this.info.nLocal - n3;
        } else {
            n2 = this.info.nLocal;
            if (n2 > n3) {
                n2 = n3;
            }
        }
        nArray[0] = n2;
        return iSqlJetMemoryPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveToUnpacked(ISqlJetUnpackedRecord iSqlJetUnpackedRecord, long l2, boolean bl2) {
        assert (this.holdsMutex());
        assert (this.pBtree.db.getMutex().held());
        if (this.eState == SqlJetBtreeCursor$CursorState.VALID && this.validNKey && this.apPage[0].intKey) {
            if (this.info.nKey == l2) {
                return 0;
            }
            if (this.atLast && this.info.nKey < l2) {
                return -1;
            }
        }
        this.moveToRoot();
        assert (this.apPage[this.iPage] != null);
        assert (this.apPage[this.iPage].isInit);
        if (this.eState == SqlJetBtreeCursor$CursorState.INVALID) {
            assert (this.apPage[this.iPage].nCell == 0);
            return -1;
        }
        assert (this.apPage[0].intKey || iSqlJetUnpackedRecord != null);
        while (true) {
            SqlJetMemPage sqlJetMemPage = this.apPage[this.iPage];
            int n2 = -1;
            int n3 = 0;
            int n4 = sqlJetMemPage.nCell - 1;
            if (!sqlJetMemPage.intKey && iSqlJetUnpackedRecord == null || n4 < 0) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            this.aiIdx[this.iPage] = bl2 ? n4 : (n4 + n3) / 2;
            while (true) {
                Object object;
                long[] lArray = new long[1];
                int n5 = this.aiIdx[this.iPage];
                this.info.nSize = 0;
                this.validNKey = true;
                if (sqlJetMemPage.intKey) {
                    object = SqlJetUtility.pointer(sqlJetMemPage.findCell(n5), sqlJetMemPage.childPtrSize);
                    if (sqlJetMemPage.hasData) {
                        int[] nArray = new int[1];
                        SqlJetUtility.movePtr((ISqlJetMemoryPointer)object, SqlJetUtility.getVarint32((ISqlJetMemoryPointer)object, nArray));
                    }
                    SqlJetUtility.getVarint((ISqlJetMemoryPointer)object, lArray);
                    if (lArray[0] == l2) {
                        n2 = 0;
                    } else if (lArray[0] < l2) {
                        n2 = -1;
                    } else {
                        assert (lArray[0] > l2);
                        n2 = 1;
                    }
                } else {
                    object = new int[1];
                    ISqlJetMemoryPointer iSqlJetMemoryPointer = this.fetchPayload((int[])object, false);
                    lArray[0] = this.info.nKey;
                    if ((long)object[0] >= lArray[0]) {
                        n2 = iSqlJetUnpackedRecord.recordCompare((int)lArray[0], iSqlJetMemoryPointer);
                    } else {
                        Object var16_14;
                        iSqlJetMemoryPointer = SqlJetUtility.allocatePtr((int)lArray[0]);
                        try {
                            this.key(0, (int)lArray[0], iSqlJetMemoryPointer);
                            var16_14 = null;
                            n2 = iSqlJetUnpackedRecord.recordCompare((int)lArray[0], iSqlJetMemoryPointer);
                        }
                        catch (Throwable throwable) {
                            var16_14 = null;
                            n2 = iSqlJetUnpackedRecord.recordCompare((int)lArray[0], iSqlJetMemoryPointer);
                            throw throwable;
                        }
                    }
                }
                if (n2 == 0) {
                    this.info.nKey = lArray[0];
                    if (sqlJetMemPage.intKey && !sqlJetMemPage.leaf) {
                        n3 = n5;
                        n4 = n3 - 1;
                        break;
                    }
                    return 0;
                }
                if (n2 < 0) {
                    n3 = n5 + 1;
                } else {
                    n4 = n5 - 1;
                }
                if (n3 > n4) {
                    this.info.nKey = lArray[0];
                    break;
                }
                this.aiIdx[this.iPage] = (n3 + n4) / 2;
            }
            assert (n3 == n4 + 1);
            assert (sqlJetMemPage.isInit);
            int n6 = sqlJetMemPage.leaf ? 0 : (n3 >= sqlJetMemPage.nCell ? SqlJetUtility.get4byte(sqlJetMemPage.aData, sqlJetMemPage.hdrOffset + 8) : SqlJetUtility.get4byte(sqlJetMemPage.findCell(n3)));
            if (n6 == 0) {
                assert (this.aiIdx[this.iPage] < this.apPage[this.iPage].nCell);
                return n2;
            }
            this.aiIdx[this.iPage] = n3;
            this.info.nSize = 0;
            this.validNKey = false;
            this.moveToChild(n6);
        }
    }

    public void restoreCursorPosition() {
        if (this.eState.compareTo(SqlJetBtreeCursor$CursorState.REQUIRESEEK) < 0) {
            return;
        }
        assert (this.holdsMutex());
        if (this.eState == SqlJetBtreeCursor$CursorState.FAULT) {
            throw new SqlJetException(this.error);
        }
        this.eState = SqlJetBtreeCursor$CursorState.INVALID;
        this.skip = this.moveTo(this.pKey, this.nKey, false);
        this.pKey = null;
        assert (this.eState == SqlJetBtreeCursor$CursorState.VALID || this.eState == SqlJetBtreeCursor$CursorState.INVALID);
    }

    public boolean cursorHasMoved() {
        try {
            this.restoreCursorPosition();
        }
        catch (SqlJetException sqlJetException) {
            return true;
        }
        return this.eState != SqlJetBtreeCursor$CursorState.VALID || this.skip != 0;
    }

    public void delete() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        SqlJetBtree sqlJetBtree = sqlJetBtreeCursor.pBtree;
        SqlJetBtreeShared sqlJetBtreeShared = sqlJetBtree.pBt;
        assert (sqlJetBtreeCursor.holdsMutex());
        assert (sqlJetBtreeShared.inTransaction == SqlJetBtree$TransMode.WRITE);
        assert (!sqlJetBtreeShared.readOnly);
        assert (sqlJetBtreeCursor.wrFlag);
        if (sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage] >= sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage].nCell || sqlJetBtreeCursor.eState != SqlJetBtreeCursor$CursorState.VALID) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        int n2 = sqlJetBtreeCursor.iPage;
        int n3 = sqlJetBtreeCursor.aiIdx[n2];
        SqlJetMemPage sqlJetMemPage = sqlJetBtreeCursor.apPage[n2];
        ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage.findCell(n3);
        if (!sqlJetMemPage.leaf) {
            sqlJetBtreeCursor.previous();
        }
        sqlJetBtreeShared.saveAllCursors(sqlJetBtreeCursor.pgnoRoot, sqlJetBtreeCursor);
        sqlJetMemPage.pDbPage.write();
        sqlJetMemPage.clearCell(iSqlJetMemoryPointer);
        sqlJetMemPage.dropCell(n3, sqlJetMemPage.cellSizePtr(iSqlJetMemoryPointer));
        if (!sqlJetMemPage.leaf) {
            SqlJetMemPage sqlJetMemPage2 = sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage];
            int n4 = sqlJetBtreeCursor.apPage[n2 + 1].pgno;
            iSqlJetMemoryPointer = sqlJetMemPage2.findCell(sqlJetMemPage2.nCell - 1);
            int n5 = sqlJetMemPage2.cellSizePtr(iSqlJetMemoryPointer);
            assert (sqlJetBtreeShared.MX_CELL_SIZE() >= n5);
            sqlJetBtreeShared.allocateTempSpace();
            ISqlJetMemoryPointer iSqlJetMemoryPointer2 = sqlJetBtreeShared.pTmpSpace;
            sqlJetMemPage2.pDbPage.write();
            sqlJetMemPage.insertCell(n3, iSqlJetMemoryPointer.getMoved(-4), n5 + 4, iSqlJetMemoryPointer2, n4);
            sqlJetMemPage2.dropCell(sqlJetMemPage2.nCell - 1, n5);
        }
        sqlJetBtreeCursor.balance(false);
        if (sqlJetBtreeCursor.iPage > n2) {
            while (sqlJetBtreeCursor.iPage > n2) {
                SqlJetMemPage.releasePage(sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage--]);
            }
            sqlJetBtreeCursor.balance(false);
        }
        sqlJetBtreeCursor.moveToRoot();
    }

    private void balance(boolean bl2) {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        int n2 = sqlJetBtreeCursor.pBt.usableSize * 2 / 3;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(13);
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = --sqlJetBtreeCursor.iPage;
            SqlJetMemPage sqlJetMemPage = sqlJetBtreeCursor.apPage[n5];
            if (n5 == 0) {
                if (sqlJetMemPage.nOverflow <= 0) break;
                assert (n4++ == 0);
                sqlJetBtreeCursor.apPage[1] = this.balance_deeper(sqlJetMemPage);
                sqlJetBtreeCursor.iPage = 1;
                sqlJetBtreeCursor.aiIdx[0] = 0;
                sqlJetBtreeCursor.aiIdx[1] = 0;
                assert (sqlJetBtreeCursor.apPage[1].nOverflow > 0);
                continue;
            }
            if (sqlJetMemPage.nOverflow == 0 && sqlJetMemPage.nFree <= n2) break;
            SqlJetMemPage sqlJetMemPage2 = sqlJetBtreeCursor.apPage[n5 - 1];
            int n6 = sqlJetBtreeCursor.aiIdx[n5 - 1];
            sqlJetMemPage2.pDbPage.write();
            if (sqlJetMemPage.hasData && sqlJetMemPage.nOverflow == 1 && sqlJetMemPage.aOvfl[0].idx == sqlJetMemPage.nCell && sqlJetMemPage2.pgno != 1 && sqlJetMemPage2.nCell == n6) {
                assert (n3++ == 0);
                this.balance_quick(sqlJetMemPage2, sqlJetMemPage, iSqlJetMemoryPointer);
            } else {
                ISqlJetMemoryPointer iSqlJetMemoryPointer2 = SqlJetUtility.allocatePtr(sqlJetBtreeCursor.pBt.pageSize);
                this.balance_nonroot(sqlJetMemPage2, n6, iSqlJetMemoryPointer2, n5 == 1);
            }
            sqlJetMemPage.nOverflow = 0;
            SqlJetMemPage.releasePage(sqlJetMemPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void balance_nonroot(SqlJetMemPage sqlJetMemPage, int n2, ISqlJetMemoryPointer iSqlJetMemoryPointer, boolean bl2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Object[] objectArray = new SqlJetMemPage[3];
        SqlJetMemPage[] sqlJetMemPageArray = new SqlJetMemPage[3];
        SqlJetMemPage[] sqlJetMemPageArray2 = new SqlJetMemPage[5];
        ISqlJetMemoryPointer[] iSqlJetMemoryPointerArray = new ISqlJetMemoryPointer[2];
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        SqlJetBtreeShared sqlJetBtreeShared = sqlJetMemPage.pBt;
        assert (SqlJetUtility.mutex_held(sqlJetBtreeShared.mutex));
        assert (sqlJetMemPage.pDbPage.isWriteable());
        assert (sqlJetMemPage.nOverflow == 0 || sqlJetMemPage.nOverflow == 1);
        assert (sqlJetMemPage.nOverflow == 0 || sqlJetMemPage.aOvfl[0].idx == n2);
        if (iSqlJetMemoryPointer == null) {
            throw new SqlJetException(SqlJetErrorCode.NOMEM);
        }
        try {
            int n10;
            int n11;
            int n12;
            n3 = sqlJetMemPage.nOverflow + sqlJetMemPage.nCell;
            if (n3 < 2) {
                n12 = 0;
                n7 = n3 + 1;
            } else {
                n7 = 3;
                n12 = n2 == 0 ? 0 : (n2 == n3 ? n3 - 2 : n2 - 1);
                n3 = 2;
            }
            ISqlJetMemoryPointer iSqlJetMemoryPointer2 = n3 + n12 - sqlJetMemPage.nOverflow == sqlJetMemPage.nCell ? sqlJetMemPage.aData.getMoved(sqlJetMemPage.hdrOffset + 8) : sqlJetMemPage.findCell(n3 + n12 - sqlJetMemPage.nOverflow);
            int n13 = SqlJetUtility.get4byte(iSqlJetMemoryPointer2);
            while (true) {
                objectArray[n3] = sqlJetBtreeShared.getAndInitPage(n13);
                n5 += 1 + objectArray[n3].nCell + objectArray[n3].nOverflow;
                if (n3-- == 0) break;
                if (n3 + n12 == sqlJetMemPage.aOvfl[0].idx && sqlJetMemPage.nOverflow > 0) {
                    iSqlJetMemoryPointerArray[n3] = sqlJetMemPage.aOvfl[0].pCell;
                    n13 = SqlJetUtility.get4byte(iSqlJetMemoryPointerArray[n3]);
                    nArray2[n3] = sqlJetMemPage.cellSizePtr(iSqlJetMemoryPointerArray[n3]);
                    sqlJetMemPage.nOverflow = 0;
                    continue;
                }
                iSqlJetMemoryPointerArray[n3] = sqlJetMemPage.findCell(n3 + n12 - sqlJetMemPage.nOverflow);
                n13 = SqlJetUtility.get4byte(iSqlJetMemoryPointerArray[n3]);
                nArray2[n3] = sqlJetMemPage.cellSizePtr(iSqlJetMemoryPointerArray[n3]);
                if (ISqlJetConfig.SECURE_DELETE) {
                    int n14 = iSqlJetMemoryPointerArray[n3].getPointer() - sqlJetMemPage.aData.getPointer();
                    if (n14 + nArray2[n3] > sqlJetBtreeShared.usableSize) {
                        Arrays.fill(objectArray, 0, n3, null);
                        throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                    }
                    SqlJetUtility.memcpy(iSqlJetMemoryPointer.getMoved(n14), iSqlJetMemoryPointerArray[n3], nArray2[n3]);
                    iSqlJetMemoryPointerArray[n3] = iSqlJetMemoryPointer.getMoved(iSqlJetMemoryPointerArray[n3].getPointer() - sqlJetMemPage.aData.getPointer());
                }
                try {
                    sqlJetMemPage.dropCell(n3 + n12 - sqlJetMemPage.nOverflow, nArray2[n3]);
                }
                catch (SqlJetException sqlJetException) {
                    SqlJetBtree.TRACE("exception in dropCell call: %s", sqlJetException.getMessage());
                }
            }
            n5 = n5 + 3 & 0xFFFFFFFC;
            ISqlJetMemoryPointer[] iSqlJetMemoryPointerArray2 = new SqlJetMemoryPointer[n5];
            int[] nArray3 = new int[n5];
            int n15 = objectArray[0].leaf ? 4 : 0;
            boolean bl3 = objectArray[0].hasData;
            for (n3 = 0; n3 < n7; ++n3) {
                SqlJetMemPage sqlJetMemPage2 = sqlJetMemPageArray[n3] = (SqlJetMemPage)SqlJetUtility.memcpy(objectArray[n3]);
                sqlJetMemPage2.aData.copyFrom(objectArray[n3].aData, sqlJetBtreeShared.pageSize);
                int n16 = sqlJetMemPage2.nCell + sqlJetMemPage2.nOverflow;
                if (sqlJetMemPage2.nOverflow > 0) {
                    for (n11 = 0; n11 < n16; ++n11) {
                        assert (n4 < n5);
                        iSqlJetMemoryPointerArray2[n4] = sqlJetMemPage2.findOverflowCell(n11);
                        nArray3[n4] = sqlJetMemPage2.cellSizePtr(iSqlJetMemoryPointerArray2[n4]);
                        ++n4;
                    }
                } else {
                    ISqlJetMemoryPointer iSqlJetMemoryPointer3 = sqlJetMemPage2.aData;
                    n10 = sqlJetMemPage2.maskPage;
                    int n17 = sqlJetMemPage2.cellOffset;
                    for (n11 = 0; n11 < n16; ++n11) {
                        assert (n4 < n5);
                        iSqlJetMemoryPointerArray2[n4] = this.findCellv2(iSqlJetMemoryPointer3, n10, n17, n11);
                        nArray3[n4] = sqlJetMemPage2.cellSizePtr(iSqlJetMemoryPointerArray2[n4]);
                        ++n4;
                    }
                }
                if (n3 >= n7 - 1 || bl3) continue;
                int n18 = nArray2[n3];
                assert (n4 < n5);
                nArray3[n4] = n18;
                ISqlJetMemoryPointer iSqlJetMemoryPointer4 = SqlJetUtility.allocatePtr(n18);
                n8 += n18;
                assert (n18 <= sqlJetBtreeShared.maxLocal + 23);
                assert (n8 <= sqlJetBtreeShared.pageSize);
                SqlJetUtility.memcpy(iSqlJetMemoryPointer4, iSqlJetMemoryPointerArray[n3], n18);
                iSqlJetMemoryPointerArray2[n4] = iSqlJetMemoryPointer4.getMoved(n15);
                assert (n15 == 0 || n15 == 4);
                nArray3[n4] = nArray3[n4] - n15;
                if (!sqlJetMemPage2.leaf) {
                    assert (n15 == 0);
                    assert (sqlJetMemPage2.hdrOffset == 0);
                    SqlJetUtility.memcpy(iSqlJetMemoryPointerArray2[n4], sqlJetMemPage2.aData.getMoved(8), 4);
                } else {
                    assert (n15 == 4);
                    if (nArray3[n4] < 4) {
                        nArray3[n4] = 4;
                    }
                }
                ++n4;
            }
            int n19 = sqlJetBtreeShared.usableSize - 12 + n15;
            int n20 = 0;
            int n21 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                assert (n3 < n5);
                if ((n21 += nArray3[n3] + 2) <= n19) continue;
                nArray2[n20] = n21 - nArray3[n3];
                nArray[n20] = n3--;
                if (bl3) {
                    // empty if block
                }
                n21 = 0;
                if (++n20 <= 4) continue;
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            nArray2[n20] = n21;
            nArray[n20] = n4;
            for (n3 = ++n20 - 1; n3 > 0; --n3) {
                int n22 = nArray2[n3];
                int n23 = nArray2[n3 - 1];
                int n24 = nArray[n3 - 1] - 1;
                n10 = n24 + 1 - (bl3 ? 1 : 0);
                assert (n10 < n5);
                assert (n24 < n5);
                while (n22 == 0 || n22 + nArray3[n10] + 2 <= n23 - (nArray3[n24] + 2)) {
                    n22 += nArray3[n10] + 2;
                    n23 -= nArray3[n24] + 2;
                    int n25 = n3 - 1;
                    nArray[n25] = nArray[n25] - 1;
                    n24 = nArray[n3 - 1] - 1;
                    n10 = n24 + 1 - (bl3 ? 1 : 0);
                }
                nArray2[n3] = n22;
                nArray2[n3 - 1] = n23;
            }
            assert (nArray[0] > 0 || sqlJetMemPage.pgno == 1 && sqlJetMemPage.nCell == 0);
            SqlJetBtree.TRACE("BALANCE: old: %d %d %d  ", ((SqlJetMemPage)objectArray[0]).pgno, n7 >= 2 ? ((SqlJetMemPage)objectArray[1]).pgno : 0, n7 >= 3 ? ((SqlJetMemPage)objectArray[2]).pgno : 0);
            if (((SqlJetMemPage)objectArray[0]).pgno <= 1) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            int n26 = ((SqlJetMemPage)objectArray[0]).aData.getByteUnsigned(0);
            for (n3 = 0; n3 < n20; ++n3) {
                Object object;
                if (n3 < n7) {
                    object = sqlJetMemPageArray2[n3] = objectArray[n3];
                    objectArray[n3] = null;
                    ++n6;
                    ((SqlJetMemPage)object).pDbPage.write();
                    continue;
                }
                assert (n3 > 0);
                int[] nArray4 = new int[]{0};
                object = sqlJetBtreeShared.allocatePage(nArray4, n13, false);
                n13 = nArray4[0];
                sqlJetMemPageArray2[n3] = object;
                ++n6;
                if (!sqlJetBtreeShared.autoVacuum) continue;
                sqlJetBtreeShared.ptrmapPut(((SqlJetMemPage)object).pgno, (short)5, sqlJetMemPage.pgno);
            }
            while (n3 < n7) {
                ((SqlJetMemPage)objectArray[n3]).freePage();
                SqlJetMemPage.releasePage((SqlJetMemPage)objectArray[n3]);
                objectArray[n3] = null;
                ++n3;
            }
            for (n3 = 0; n3 < n20 - 1; ++n3) {
                int n27 = sqlJetMemPageArray2[n3].pgno;
                int n28 = n3;
                for (n11 = n3 + 1; n11 < n20; ++n11) {
                    if (sqlJetMemPageArray2[n11].pgno >= n27) continue;
                    n28 = n11;
                    n27 = sqlJetMemPageArray2[n11].pgno;
                }
                if (n28 <= n3) continue;
                SqlJetMemPage sqlJetMemPage3 = sqlJetMemPageArray2[n3];
                sqlJetMemPageArray2[n3] = sqlJetMemPageArray2[n28];
                sqlJetMemPageArray2[n28] = sqlJetMemPage3;
            }
            SqlJetBtree.TRACE("new: %d(%d) %d(%d) %d(%d) %d(%d) %d(%d)\n", sqlJetMemPageArray2[0].pgno, nArray2[0], n6 >= 2 ? sqlJetMemPageArray2[1].pgno : 0, n6 >= 2 ? nArray2[1] : 0, n6 >= 3 ? sqlJetMemPageArray2[2].pgno : 0, n6 >= 3 ? nArray2[2] : 0, n6 >= 4 ? sqlJetMemPageArray2[3].pgno : 0, n6 >= 4 ? nArray2[3] : 0, n6 >= 5 ? sqlJetMemPageArray2[4].pgno : 0, n6 >= 5 ? nArray2[4] : 0);
            assert (sqlJetMemPage.pDbPage.isWriteable());
            SqlJetUtility.put4byte(iSqlJetMemoryPointer2, sqlJetMemPageArray2[n6 - 1].pgno);
            n11 = 0;
            for (n3 = 0; n3 < n6; ++n3) {
                SqlJetMemPage sqlJetMemPage4 = sqlJetMemPageArray2[n3];
                assert (n11 < n5);
                sqlJetMemPage4.zeroPage(n26);
                sqlJetMemPage4.assemblePage(nArray[n3] - n11, iSqlJetMemoryPointerArray2, n11, nArray3, n11);
                assert (sqlJetMemPage4.nCell > 0 || n6 == 1 && nArray[0] == 0);
                assert (sqlJetMemPage4.nOverflow == 0);
                n11 = nArray[n3];
                assert (n3 < n6 - 1 || n11 == n4);
                if (n11 >= n4) continue;
                assert (n11 < n5);
                ISqlJetMemoryPointer iSqlJetMemoryPointer5 = iSqlJetMemoryPointerArray2[n11];
                n10 = nArray3[n11] + n15;
                ISqlJetMemoryPointer iSqlJetMemoryPointer6 = iSqlJetMemoryPointer.getMoved(n9);
                if (!sqlJetMemPage4.leaf) {
                    SqlJetUtility.memcpy(sqlJetMemPage4.aData.getMoved(8), iSqlJetMemoryPointer5, 4);
                } else if (bl3) {
                    SqlJetBtreeCellInfo sqlJetBtreeCellInfo = sqlJetMemPage4.parseCellPtr(iSqlJetMemoryPointerArray2[--n11]);
                    iSqlJetMemoryPointer5 = iSqlJetMemoryPointer6;
                    n10 = 4 + SqlJetUtility.putVarint(iSqlJetMemoryPointer5.getMoved(4), sqlJetBtreeCellInfo.nKey);
                    SqlJetUtility.put4byte(iSqlJetMemoryPointer5, sqlJetMemPage4.pgno);
                    iSqlJetMemoryPointer6 = null;
                } else {
                    iSqlJetMemoryPointer5 = SqlJetUtility.getMoved(n11 > 0 ? iSqlJetMemoryPointerArray2[n11 - 1] : null, iSqlJetMemoryPointer5, -4);
                    if (nArray3[n11] == 4) {
                        assert (n15 == 4);
                        n10 = sqlJetMemPage.cellSizePtr(iSqlJetMemoryPointer5);
                    }
                }
                n9 += n10;
                assert (n10 <= sqlJetBtreeShared.maxLocal + 23);
                assert (n9 <= sqlJetBtreeShared.pageSize);
                sqlJetMemPage.insertCell(n12, iSqlJetMemoryPointer5, n10, iSqlJetMemoryPointer6, sqlJetMemPage4.pgno);
                assert (sqlJetMemPage.pDbPage.isWriteable());
                ++n11;
                ++n12;
            }
            assert (n11 == n4);
            assert (n7 > 0);
            assert (n6 > 0);
            if ((n26 & 8) == 0) {
                ISqlJetMemoryPointer iSqlJetMemoryPointer7 = sqlJetMemPageArray[n7 - 1].aData.getMoved(8);
                SqlJetUtility.memcpy(sqlJetMemPageArray2[n6 - 1].aData.getMoved(8), iSqlJetMemoryPointer7, 4);
            }
            if (bl2 && sqlJetMemPage.nCell == 0 && sqlJetMemPage.hdrOffset <= sqlJetMemPageArray2[0].nFree) {
                assert (n6 == 1);
                assert (sqlJetMemPageArray2[0].nFree == SqlJetUtility.get2byte(sqlJetMemPageArray2[0].aData.getMoved(5)) - sqlJetMemPageArray2[0].cellOffset - sqlJetMemPageArray2[0].nCell * 2);
                sqlJetMemPageArray2[0].copyNodeContent(sqlJetMemPage);
                sqlJetMemPageArray2[0].freePage();
            } else if (sqlJetBtreeShared.autoVacuum) {
                SqlJetMemPage sqlJetMemPage5 = sqlJetMemPageArray2[0];
                SqlJetMemPage sqlJetMemPage6 = sqlJetMemPageArray[0];
                int n29 = sqlJetMemPage6.nOverflow;
                n10 = sqlJetMemPage6.nCell + n29;
                int n30 = n29 > 0 ? sqlJetMemPage6.aOvfl[0].idx : -1;
                n11 = 0;
                n20 = 0;
                boolean bl4 = false;
                for (n3 = 0; n3 < n4; ++n3) {
                    while (n3 == n10) {
                        assert (n11 + 1 < sqlJetMemPageArray.length);
                        sqlJetMemPage6 = sqlJetMemPageArray[++n11];
                        n10 = n3 + (!bl3 ? 1 : 0) + sqlJetMemPage6.nCell + sqlJetMemPage6.nOverflow;
                        if (sqlJetMemPage6.nOverflow > 0) {
                            n29 = sqlJetMemPage6.nOverflow;
                            n30 = n3 + (!bl3 ? 1 : 0) + sqlJetMemPage6.aOvfl[0].idx;
                        }
                        bl4 = !bl3;
                    }
                    assert (n29 > 0 || n30 < n3);
                    assert (n29 < 2 || sqlJetMemPage6.aOvfl[0].idx == sqlJetMemPage6.aOvfl[1].idx - 1);
                    assert (n29 < 3 || sqlJetMemPage6.aOvfl[1].idx == sqlJetMemPage6.aOvfl[2].idx - 1);
                    if (n3 == n30) {
                        bl4 = true;
                        if (--n29 > 0) {
                            ++n30;
                        }
                    }
                    if (n3 == nArray[n20]) {
                        sqlJetMemPage5 = sqlJetMemPageArray2[++n20];
                        if (!bl3) continue;
                    }
                    assert (n11 < n7);
                    assert (n20 < n6);
                    if (!bl4 && sqlJetMemPage6.pgno == sqlJetMemPage5.pgno) continue;
                    if (n15 <= 0) {
                        sqlJetBtreeShared.ptrmapPut(SqlJetUtility.get4byte(iSqlJetMemoryPointerArray2[n3]), (short)5, sqlJetMemPage5.pgno);
                    }
                    if (nArray3[n3] <= sqlJetMemPage5.minLocal) continue;
                    sqlJetBtreeShared.ptrmapPutOvflPtr(sqlJetMemPage5, iSqlJetMemoryPointerArray2[n3]);
                }
                if (n15 <= 0) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        int n31 = SqlJetUtility.get4byte(sqlJetMemPageArray2[n3].aData.getMoved(8));
                        sqlJetBtreeShared.ptrmapPut(n31, (short)5, sqlJetMemPageArray2[n3].pgno);
                    }
                }
            }
            assert (sqlJetMemPage.isInit);
            SqlJetBtree.TRACE("BALANCE: finished: old=%d new=%d cells=%d\n", n7, n6, n4);
            Object var39_60 = null;
        }
        catch (Throwable throwable) {
            int n32;
            Object var39_61 = null;
            for (n32 = 0; n32 < n7; ++n32) {
                SqlJetMemPage.releasePage(objectArray[n32]);
            }
            for (n32 = 0; n32 < n6; ++n32) {
                SqlJetMemPage.releasePage(sqlJetMemPageArray2[n32]);
            }
            throw throwable;
        }
        for (n3 = 0; n3 < n7; ++n3) {
            SqlJetMemPage.releasePage((SqlJetMemPage)objectArray[n3]);
        }
        for (n3 = 0; n3 < n6; ++n3) {
            SqlJetMemPage.releasePage(sqlJetMemPageArray2[n3]);
        }
    }

    private ISqlJetMemoryPointer findCellv2(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, int n3, int n4) {
        return iSqlJetMemoryPointer.getMoved(n2 & SqlJetUtility.get2byte(iSqlJetMemoryPointer.getMoved(n3 + 2 * n4)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void balance_quick(SqlJetMemPage sqlJetMemPage, SqlJetMemPage sqlJetMemPage2, ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        SqlJetBtreeShared sqlJetBtreeShared = sqlJetMemPage2.pBt;
        int[] nArray = new int[]{0};
        assert (SqlJetUtility.mutex_held(sqlJetMemPage2.pBt.mutex));
        assert (sqlJetMemPage.pDbPage.isWriteable());
        assert (sqlJetMemPage2.nOverflow == 1);
        if (sqlJetMemPage2.nCell <= 0) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        SqlJetMemPage sqlJetMemPage3 = sqlJetBtreeShared.allocatePage(nArray, 0, false);
        try {
            boolean bl2;
            ISqlJetMemoryPointer iSqlJetMemoryPointer2 = iSqlJetMemoryPointer.getMoved(4);
            ISqlJetMemoryPointer iSqlJetMemoryPointer3 = sqlJetMemPage2.aOvfl[0].pCell;
            int n2 = sqlJetMemPage2.cellSizePtr(iSqlJetMemoryPointer3);
            assert (sqlJetMemPage3.pDbPage.isWriteable());
            assert (sqlJetMemPage2.aData.getByteUnsigned(0) == 13);
            sqlJetMemPage3.zeroPage(13);
            sqlJetMemPage3.assemblePage(1, new ISqlJetMemoryPointer[]{iSqlJetMemoryPointer3}, 0, new int[]{n2}, 0);
            if (sqlJetBtreeShared.autoVacuum) {
                sqlJetBtreeShared.ptrmapPut(nArray[0], (short)5, sqlJetMemPage.pgno);
                if (n2 > sqlJetMemPage3.minLocal) {
                    sqlJetMemPage3.ptrmapPutOvflPtr(iSqlJetMemoryPointer3);
                }
            }
            iSqlJetMemoryPointer3 = sqlJetMemPage2.findCell(sqlJetMemPage2.nCell - 1);
            ISqlJetMemoryPointer iSqlJetMemoryPointer4 = iSqlJetMemoryPointer3.getMoved(9);
            do {
                bl2 = (iSqlJetMemoryPointer3.getByteUnsigned() & 0x80) == 0;
                iSqlJetMemoryPointer3.movePointer(1);
            } while (!bl2 && iSqlJetMemoryPointer3.getPointer() < iSqlJetMemoryPointer4.getPointer());
            iSqlJetMemoryPointer4 = iSqlJetMemoryPointer3.getMoved(9);
            do {
                iSqlJetMemoryPointer2.putByteUnsigned(iSqlJetMemoryPointer3.getByteUnsigned());
                iSqlJetMemoryPointer2.movePointer(1);
                bl2 = (iSqlJetMemoryPointer3.getByteUnsigned() & 0x80) == 0;
                iSqlJetMemoryPointer3.movePointer(1);
            } while (!bl2 && iSqlJetMemoryPointer3.getPointer() < iSqlJetMemoryPointer4.getPointer());
            sqlJetMemPage.insertCell(sqlJetMemPage.nCell, iSqlJetMemoryPointer, iSqlJetMemoryPointer2.getPointer() - iSqlJetMemoryPointer.getPointer(), null, sqlJetMemPage2.pgno);
            SqlJetUtility.put4byte(sqlJetMemPage.aData.getMoved(sqlJetMemPage.hdrOffset + 8), nArray[0]);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            SqlJetMemPage.releasePage(sqlJetMemPage3);
            throw throwable;
        }
        SqlJetMemPage.releasePage(sqlJetMemPage3);
    }

    private SqlJetMemPage balance_deeper(SqlJetMemPage sqlJetMemPage) {
        SqlJetMemPage sqlJetMemPage2 = null;
        int[] nArray = new int[]{0};
        SqlJetBtreeShared sqlJetBtreeShared = sqlJetMemPage.pBt;
        assert (sqlJetMemPage.nOverflow > 0);
        assert (SqlJetUtility.mutex_held(sqlJetBtreeShared.mutex));
        sqlJetMemPage.pDbPage.write();
        try {
            sqlJetMemPage2 = sqlJetBtreeShared.allocatePage(nArray, sqlJetMemPage.pgno, false);
            sqlJetMemPage.copyNodeContent(sqlJetMemPage2);
            if (sqlJetBtreeShared.autoVacuum) {
                sqlJetBtreeShared.ptrmapPut(nArray[0], (short)5, sqlJetMemPage.pgno);
            }
        }
        catch (SqlJetException sqlJetException) {
            SqlJetMemPage.releasePage(sqlJetMemPage2);
            throw sqlJetException;
        }
        assert (sqlJetMemPage2.pDbPage.isWriteable());
        assert (sqlJetMemPage.pDbPage.isWriteable());
        assert (sqlJetMemPage2.nCell == sqlJetMemPage.nCell);
        SqlJetBtree.TRACE("BALANCE: copy root %d into %d\n", sqlJetMemPage.pgno, sqlJetMemPage2.pgno);
        SqlJetUtility.memcpy(sqlJetMemPage2.aOvfl, sqlJetMemPage.aOvfl, sqlJetMemPage.nOverflow);
        sqlJetMemPage2.nOverflow = sqlJetMemPage.nOverflow;
        sqlJetMemPage.zeroPage(SqlJetUtility.getUnsignedByte(sqlJetMemPage2.aData, 0) & 0xFFFFFFF7);
        SqlJetUtility.put4byte(sqlJetMemPage.aData.getMoved(sqlJetMemPage.hdrOffset + 8), nArray[0]);
        return sqlJetMemPage2;
    }

    void releaseTempCursor() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        for (int i2 = 0; i2 <= sqlJetBtreeCursor.iPage; ++i2) {
            sqlJetBtreeCursor.apPage[i2].pDbPage.unref();
        }
        sqlJetBtreeCursor.pKey = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ISqlJetMemoryPointer iSqlJetMemoryPointer, long l2, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n2, int n3, boolean bl2) {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        SqlJetBtree sqlJetBtree = sqlJetBtreeCursor.pBtree;
        SqlJetBtreeShared sqlJetBtreeShared = sqlJetBtree.pBt;
        ISqlJetMemoryPointer iSqlJetMemoryPointer3 = null;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        assert (sqlJetBtreeShared.inTransaction == SqlJetBtree$TransMode.WRITE);
        assert (!sqlJetBtreeShared.readOnly);
        assert (sqlJetBtreeCursor.wrFlag);
        if (sqlJetBtreeCursor.pBtree.checkReadLocks(sqlJetBtreeCursor.pgnoRoot, sqlJetBtreeCursor, l2)) {
            throw new SqlJetException(SqlJetErrorCode.LOCKED);
        }
        if (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.FAULT) {
            throw new SqlJetException(sqlJetBtreeCursor.error);
        }
        sqlJetBtreeShared.saveAllCursors(sqlJetBtreeCursor.pgnoRoot, sqlJetBtreeCursor);
        int n4 = sqlJetBtreeCursor.moveTo(iSqlJetMemoryPointer, l2, bl2);
        assert (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.VALID || sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.INVALID && n4 != 0);
        SqlJetMemPage sqlJetMemPage = sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage];
        assert (sqlJetMemPage.intKey || l2 >= 0L);
        assert (sqlJetMemPage.leaf || !sqlJetMemPage.intKey);
        SqlJetBtree.TRACE("INSERT: table=%d nkey=%d ndata=%b page=%d %s\n", sqlJetBtreeCursor.pgnoRoot, l2, iSqlJetMemoryPointer2, sqlJetMemPage.pgno, n4 == 0 ? "overwrite" : "new entry");
        assert (sqlJetMemPage.isInit);
        sqlJetBtreeShared.allocateTempSpace();
        iSqlJetMemoryPointer3 = sqlJetBtreeShared.pTmpSpace;
        int n5 = sqlJetMemPage.fillInCell(iSqlJetMemoryPointer3, iSqlJetMemoryPointer, l2, iSqlJetMemoryPointer2, n2, n3);
        assert (n5 == sqlJetMemPage.cellSizePtr(iSqlJetMemoryPointer3));
        assert (n5 <= sqlJetBtreeShared.MX_CELL_SIZE());
        int n6 = sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage];
        if (n4 == 0 && SqlJetBtreeCursor$CursorState.VALID == sqlJetBtreeCursor.eState) {
            assert (n6 < sqlJetMemPage.nCell);
            sqlJetMemPage.pDbPage.write();
            ISqlJetMemoryPointer iSqlJetMemoryPointer4 = sqlJetMemPage.findCell(n6);
            if (!sqlJetMemPage.leaf) {
                SqlJetUtility.memcpy(iSqlJetMemoryPointer3, iSqlJetMemoryPointer4, 4);
            }
            int n7 = sqlJetMemPage.cellSizePtr(iSqlJetMemoryPointer4);
            sqlJetMemPage.clearCell(iSqlJetMemoryPointer4);
            sqlJetMemPage.dropCell(n6, n7);
        } else if (n4 < 0 && sqlJetMemPage.nCell > 0) {
            assert (sqlJetMemPage.leaf);
            int n8 = sqlJetBtreeCursor.iPage;
            int n9 = sqlJetBtreeCursor.aiIdx[n8] + 1;
            sqlJetBtreeCursor.aiIdx[n8] = n9;
            n6 = n9;
        } else assert (sqlJetMemPage.leaf);
        try {
            sqlJetMemPage.insertCell(n6, iSqlJetMemoryPointer3, n5, null, 0);
            assert (sqlJetMemPage.nCell > 0 || sqlJetMemPage.nOverflow > 0);
            Object var19_17 = null;
            sqlJetBtreeCursor.info.nSize = 0;
            sqlJetBtreeCursor.validNKey = false;
        }
        catch (Throwable throwable) {
            Object var19_18 = null;
            sqlJetBtreeCursor.info.nSize = 0;
            sqlJetBtreeCursor.validNKey = false;
            throw throwable;
        }
        if (sqlJetMemPage.nOverflow > 0) {
            try {
                sqlJetBtreeCursor.balance(true);
                Object var21_20 = null;
                sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage].nOverflow = 0;
                sqlJetBtreeCursor.eState = SqlJetBtreeCursor$CursorState.INVALID;
            }
            catch (Throwable throwable) {
                Object var21_21 = null;
                sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage].nOverflow = 0;
                sqlJetBtreeCursor.eState = SqlJetBtreeCursor$CursorState.INVALID;
                throw throwable;
            }
        }
        assert (sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage].nOverflow == 0);
    }

    public boolean first() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        assert (sqlJetBtreeCursor.pBtree.db.getMutex().held());
        sqlJetBtreeCursor.moveToRoot();
        if (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.INVALID) {
            assert (sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage].nCell == 0);
            return true;
        }
        assert (sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage].nCell > 0);
        sqlJetBtreeCursor.moveToLeftmost();
        return false;
    }

    private void moveToLeftmost() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        assert (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.VALID);
        while (true) {
            SqlJetMemPage sqlJetMemPage = sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage];
            if (sqlJetMemPage.leaf) break;
            assert (sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage] < sqlJetMemPage.nCell);
            int n2 = SqlJetUtility.get4byte(sqlJetMemPage.findCell(sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage]));
            sqlJetBtreeCursor.moveToChild(n2);
        }
    }

    private void moveToRightmost() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        SqlJetMemPage sqlJetMemPage = null;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        assert (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.VALID);
        while (true) {
            sqlJetMemPage = sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage];
            if (sqlJetMemPage.leaf) break;
            int n2 = SqlJetUtility.get4byte(sqlJetMemPage.aData, sqlJetMemPage.hdrOffset + 8);
            sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage] = sqlJetMemPage.nCell;
            sqlJetBtreeCursor.moveToChild(n2);
        }
        sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage] = sqlJetMemPage.nCell - 1;
        sqlJetBtreeCursor.info.nSize = 0;
        sqlJetBtreeCursor.validNKey = false;
    }

    public boolean last() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        assert (sqlJetBtreeCursor.pBtree.db.getMutex().held());
        sqlJetBtreeCursor.moveToRoot();
        if (SqlJetBtreeCursor$CursorState.INVALID == sqlJetBtreeCursor.eState) {
            assert (sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage].nCell == 0);
            return true;
        }
        assert (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.VALID);
        try {
            try {
                sqlJetBtreeCursor.moveToRightmost();
            }
            catch (SqlJetException sqlJetException) {
                sqlJetBtreeCursor.atLast = false;
                throw sqlJetException;
            }
            Object var4_2 = null;
            sqlJetBtreeCursor.getCellInfo();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            sqlJetBtreeCursor.getCellInfo();
            throw throwable;
        }
        sqlJetBtreeCursor.atLast = true;
        return false;
    }

    public boolean next() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        sqlJetBtreeCursor.restoreCursorPosition();
        if (SqlJetBtreeCursor$CursorState.INVALID == sqlJetBtreeCursor.eState) {
            return true;
        }
        if (sqlJetBtreeCursor.skip > 0) {
            sqlJetBtreeCursor.skip = 0;
            return false;
        }
        sqlJetBtreeCursor.skip = 0;
        SqlJetMemPage sqlJetMemPage = sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage];
        int n2 = sqlJetBtreeCursor.iPage;
        int n3 = sqlJetBtreeCursor.aiIdx[n2] + 1;
        sqlJetBtreeCursor.aiIdx[n2] = n3;
        int n4 = n3;
        assert (sqlJetMemPage.isInit);
        assert (n4 <= sqlJetMemPage.nCell);
        sqlJetBtreeCursor.info.nSize = 0;
        sqlJetBtreeCursor.validNKey = false;
        if (n4 >= sqlJetMemPage.nCell) {
            if (!sqlJetMemPage.leaf) {
                sqlJetBtreeCursor.moveToChild(SqlJetUtility.get4byte(sqlJetMemPage.aData, sqlJetMemPage.hdrOffset + 8));
                sqlJetBtreeCursor.moveToLeftmost();
                return false;
            }
            do {
                if (sqlJetBtreeCursor.iPage == 0) {
                    sqlJetBtreeCursor.eState = SqlJetBtreeCursor$CursorState.INVALID;
                    return true;
                }
                sqlJetBtreeCursor.moveToParent();
                sqlJetMemPage = sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage];
            } while (sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage] >= sqlJetMemPage.nCell);
            if (sqlJetMemPage.intKey) {
                return sqlJetBtreeCursor.next();
            }
            return false;
        }
        if (sqlJetMemPage.leaf) {
            return false;
        }
        sqlJetBtreeCursor.moveToLeftmost();
        return false;
    }

    private void moveToParent() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        assert (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.VALID);
        assert (sqlJetBtreeCursor.iPage > 0);
        assert (sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage] != null);
        sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage - 1].assertParentIndex(sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage - 1], sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage].pgno);
        SqlJetMemPage.releasePage(sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage]);
        --sqlJetBtreeCursor.iPage;
        sqlJetBtreeCursor.info.nSize = 0;
        sqlJetBtreeCursor.validNKey = false;
    }

    public boolean previous() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        sqlJetBtreeCursor.restoreCursorPosition();
        sqlJetBtreeCursor.atLast = false;
        if (SqlJetBtreeCursor$CursorState.INVALID == sqlJetBtreeCursor.eState) {
            return true;
        }
        if (sqlJetBtreeCursor.skip < 0) {
            sqlJetBtreeCursor.skip = 0;
            return false;
        }
        sqlJetBtreeCursor.skip = 0;
        SqlJetMemPage sqlJetMemPage = sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage];
        assert (sqlJetMemPage.isInit);
        if (!sqlJetMemPage.leaf) {
            int n2 = sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage];
            sqlJetBtreeCursor.moveToChild(SqlJetUtility.get4byte(sqlJetMemPage.findCell(n2)));
            sqlJetBtreeCursor.moveToRightmost();
        } else {
            while (sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage] == 0) {
                if (sqlJetBtreeCursor.iPage == 0) {
                    sqlJetBtreeCursor.eState = SqlJetBtreeCursor$CursorState.INVALID;
                    return true;
                }
                sqlJetBtreeCursor.moveToParent();
            }
            sqlJetBtreeCursor.info.nSize = 0;
            sqlJetBtreeCursor.validNKey = false;
            int n3 = sqlJetBtreeCursor.iPage;
            sqlJetBtreeCursor.aiIdx[n3] = sqlJetBtreeCursor.aiIdx[n3] - 1;
            sqlJetMemPage = sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage];
            if (sqlJetMemPage.intKey && !sqlJetMemPage.leaf) {
                return sqlJetBtreeCursor.previous();
            }
        }
        return false;
    }

    public boolean eof() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        return SqlJetBtreeCursor$CursorState.VALID != sqlJetBtreeCursor.eState;
    }

    public short flags() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        sqlJetBtreeCursor.restoreCursorPosition();
        SqlJetMemPage sqlJetMemPage = sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage];
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        assert (sqlJetMemPage != null);
        assert (sqlJetMemPage.pBt == sqlJetBtreeCursor.pBt);
        return (short)SqlJetUtility.getUnsignedByte(sqlJetMemPage.aData, sqlJetMemPage.hdrOffset);
    }

    public long getKeySize() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        sqlJetBtreeCursor.restoreCursorPosition();
        assert (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.INVALID || sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.VALID);
        if (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.INVALID) {
            return 0L;
        }
        sqlJetBtreeCursor.getCellInfo();
        return sqlJetBtreeCursor.info.nKey;
    }

    public void key(int n2, int n3, ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        sqlJetBtreeCursor.restoreCursorPosition();
        assert (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.VALID);
        assert (sqlJetBtreeCursor.iPage >= 0 && sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage] != null);
        if (sqlJetBtreeCursor.apPage[0].intKey) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        assert (sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage] < sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage].nCell);
        sqlJetBtreeCursor.accessPayload(n2, n3, iSqlJetMemoryPointer, 0, false);
    }

    private void accessPayload(int n2, int n3, ISqlJetMemoryPointer iSqlJetMemoryPointer, int n4, boolean bl2) {
        int n5;
        int n6;
        iSqlJetMemoryPointer = SqlJetUtility.pointer(iSqlJetMemoryPointer);
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        int n7 = 0;
        SqlJetMemPage sqlJetMemPage = sqlJetBtreeCursor.apPage[sqlJetBtreeCursor.iPage];
        SqlJetBtreeShared sqlJetBtreeShared = sqlJetBtreeCursor.pBt;
        assert (sqlJetMemPage != null);
        assert (sqlJetBtreeCursor.eState == SqlJetBtreeCursor$CursorState.VALID);
        assert (sqlJetBtreeCursor.aiIdx[sqlJetBtreeCursor.iPage] < sqlJetMemPage.nCell);
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        sqlJetBtreeCursor.getCellInfo();
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = SqlJetUtility.pointer(sqlJetBtreeCursor.info.pCell, sqlJetBtreeCursor.info.nHeader);
        int n8 = n6 = sqlJetMemPage.intKey ? 0 : (int)sqlJetBtreeCursor.info.nKey;
        if (n4 != 0) {
            n2 += n6;
        }
        if (n2 + n3 > n6 + sqlJetBtreeCursor.info.nData || iSqlJetMemoryPointer2.getPointer() + sqlJetBtreeCursor.info.nLocal > sqlJetMemPage.aData.getPointer() + sqlJetBtreeShared.usableSize) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        if (n2 < sqlJetBtreeCursor.info.nLocal) {
            n5 = n3;
            if (n5 + n2 > sqlJetBtreeCursor.info.nLocal) {
                n5 = sqlJetBtreeCursor.info.nLocal - n2;
            }
            this.copyPayload(iSqlJetMemoryPointer2, n2, iSqlJetMemoryPointer, 0, n5, bl2, sqlJetMemPage.pDbPage);
            n2 = 0;
            iSqlJetMemoryPointer.movePointer(n5);
            n3 -= n5;
        } else {
            n2 -= sqlJetBtreeCursor.info.nLocal;
        }
        if (n3 > 0) {
            n5 = sqlJetBtreeShared.usableSize - 4;
            int n9 = SqlJetUtility.get4byte(iSqlJetMemoryPointer2, sqlJetBtreeCursor.info.nLocal);
            if (sqlJetBtreeCursor.isIncrblobHandle && sqlJetBtreeCursor.aOverflow == null) {
                int n10 = (sqlJetBtreeCursor.info.nPayload - sqlJetBtreeCursor.info.nLocal + n5 - 1) / n5;
                sqlJetBtreeCursor.aOverflow = new int[n10];
            }
            if (sqlJetBtreeCursor.aOverflow != null && sqlJetBtreeCursor.aOverflow[n2 / n5] != 0) {
                n7 = n2 / n5;
                n9 = sqlJetBtreeCursor.aOverflow[n7];
                n2 %= n5;
            }
            while (n3 > 0 && n9 != 0) {
                if (sqlJetBtreeCursor.aOverflow != null) {
                    assert (sqlJetBtreeCursor.aOverflow[n7] == 0 || sqlJetBtreeCursor.aOverflow[n7] == n9);
                    sqlJetBtreeCursor.aOverflow[n7] = n9;
                }
                if (n2 >= n5) {
                    if (sqlJetBtreeCursor.aOverflow != null && sqlJetBtreeCursor.aOverflow[n7 + 1] != 0) {
                        n9 = sqlJetBtreeCursor.aOverflow[n7 + 1];
                    } else {
                        int[] nArray = new int[]{n9};
                        sqlJetBtreeShared.getOverflowPage(n9, null, nArray);
                        n9 = nArray[0];
                    }
                    n2 -= n5;
                } else {
                    int n11 = n3;
                    ISqlJetPage iSqlJetPage = sqlJetBtreeShared.pPager.getPage(n9);
                    iSqlJetMemoryPointer2 = iSqlJetPage.getData();
                    n9 = SqlJetUtility.get4byte(iSqlJetMemoryPointer2);
                    if (n11 + n2 > n5) {
                        n11 = n5 - n2;
                    }
                    this.copyPayload(iSqlJetMemoryPointer2, n2 + 4, iSqlJetMemoryPointer, 0, n11, bl2, iSqlJetPage);
                    iSqlJetPage.unref();
                    n2 = 0;
                    n3 -= n11;
                    iSqlJetMemoryPointer.movePointer(n11);
                }
                ++n7;
            }
        }
        if (n3 > 0) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private void copyPayload(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n3, int n4, boolean bl2, ISqlJetPage iSqlJetPage) {
        if (bl2) {
            iSqlJetPage.write();
            SqlJetUtility.memcpy(iSqlJetMemoryPointer, n2, iSqlJetMemoryPointer2, n3, n4);
        } else {
            SqlJetUtility.memcpy(iSqlJetMemoryPointer2, n3, iSqlJetMemoryPointer, n2, n4);
        }
    }

    public ISqlJetDbHandle getCursorDb() {
        assert (SqlJetUtility.mutex_held(this.pBtree.db.getMutex()));
        return this.pBtree.db;
    }

    public ISqlJetMemoryPointer keyFetch(int[] nArray) {
        assert (this.cursorHoldsMutex(this));
        if (this.eState == SqlJetBtreeCursor$CursorState.VALID) {
            return this.fetchPayload(nArray, false);
        }
        return null;
    }

    public ISqlJetMemoryPointer dataFetch(int[] nArray) {
        assert (this.cursorHoldsMutex(this));
        if (this.eState == SqlJetBtreeCursor$CursorState.VALID) {
            return this.fetchPayload(nArray, true);
        }
        return null;
    }

    public int getDataSize() {
        assert (this.cursorHoldsMutex(this));
        this.restoreCursorPosition();
        assert (this.eState == SqlJetBtreeCursor$CursorState.INVALID || this.eState == SqlJetBtreeCursor$CursorState.VALID);
        if (this.eState == SqlJetBtreeCursor$CursorState.INVALID) {
            return 0;
        }
        this.getCellInfo();
        return this.info.nData;
    }

    public void data(int n2, int n3, ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        if (this.eState == SqlJetBtreeCursor$CursorState.INVALID) {
            throw new SqlJetException(SqlJetErrorCode.ABORT);
        }
        assert (this.cursorHoldsMutex(this));
        this.restoreCursorPosition();
        assert (this.eState == SqlJetBtreeCursor$CursorState.VALID);
        assert (this.iPage >= 0 && this.apPage[this.iPage] != null);
        assert (this.aiIdx[this.iPage] < this.apPage[this.iPage].nCell);
        this.accessPayload(n2, n3, iSqlJetMemoryPointer, 1, false);
    }

    public void putData(int n2, int n3, ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        assert (this.cursorHoldsMutex(this));
        assert (SqlJetUtility.mutex_held(this.pBtree.db.getMutex()));
        assert (this.isIncrblobHandle);
        this.restoreCursorPosition();
        assert (this.eState != SqlJetBtreeCursor$CursorState.REQUIRESEEK);
        if (this.eState != SqlJetBtreeCursor$CursorState.VALID) {
            throw new SqlJetException(SqlJetErrorCode.ABORT);
        }
        if (!this.wrFlag) {
            throw new SqlJetException(SqlJetErrorCode.READONLY);
        }
        assert (!this.pBt.readOnly && this.pBt.inTransaction == SqlJetBtree$TransMode.WRITE);
        if (this.pBtree.checkReadLocks(this.pgnoRoot, this, 0L)) {
            throw new SqlJetException(SqlJetErrorCode.LOCKED);
        }
        if (this.eState == SqlJetBtreeCursor$CursorState.INVALID || !this.apPage[this.iPage].intKey) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.accessPayload(n2, n3, iSqlJetMemoryPointer, 0, true);
    }

    public void cacheOverflow() {
        assert (this.cursorHoldsMutex(this));
        assert (SqlJetUtility.mutex_held(this.pBtree.db.getMutex()));
        assert (!this.isIncrblobHandle);
        assert (this.aOverflow == null);
        this.isIncrblobHandle = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveCursorPosition() {
        SqlJetBtreeCursor sqlJetBtreeCursor = this;
        assert (SqlJetBtreeCursor$CursorState.VALID == sqlJetBtreeCursor.eState);
        assert (null == sqlJetBtreeCursor.pKey);
        assert (this.cursorHoldsMutex(sqlJetBtreeCursor));
        try {
            sqlJetBtreeCursor.nKey = sqlJetBtreeCursor.getKeySize();
            if (!sqlJetBtreeCursor.apPage[0].intKey) {
                ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr((int)sqlJetBtreeCursor.nKey);
                sqlJetBtreeCursor.key(0, (int)sqlJetBtreeCursor.nKey, iSqlJetMemoryPointer);
                sqlJetBtreeCursor.pKey = iSqlJetMemoryPointer;
            }
            assert (!sqlJetBtreeCursor.apPage[0].intKey || sqlJetBtreeCursor.pKey == null);
            for (int i2 = 0; i2 <= sqlJetBtreeCursor.iPage; ++i2) {
                SqlJetMemPage.releasePage(sqlJetBtreeCursor.apPage[i2]);
                sqlJetBtreeCursor.apPage[i2] = null;
            }
            sqlJetBtreeCursor.iPage = -1;
            sqlJetBtreeCursor.eState = SqlJetBtreeCursor$CursorState.REQUIRESEEK;
            Object var4_4 = null;
            sqlJetBtreeCursor.invalidateOverflowCache();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            sqlJetBtreeCursor.invalidateOverflowCache();
            throw throwable;
        }
        return true;
    }

    public void enterCursor() {
        if (this.pBtree != null) {
            this.pBtree.enter();
        }
    }

    public void leaveCursor() {
        if (this.pBtree != null) {
            this.pBtree.leave();
        }
    }
}

