/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.ISqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetAutoVacuumMode;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetDbFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.internal.SqlJetSavepointOperation;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree$1;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree$2;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree$TransMode;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCursor$CursorState;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeLock;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeLockMode;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.mutex.SqlJetMutex;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPager;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;

public class SqlJetBtree
implements ISqlJetBtree {
    private static Logger btreeLogger = Logger.getLogger("SQLJET_LOG_BTREE");
    private static final boolean SQLJET_LOG_BTREE = SqlJetUtility.getBoolSysProp("SQLJET_LOG_BTREE", false);
    private static final ISqlJetMemoryPointer PAGE1_21 = SqlJetUtility.wrapPtr(new byte[]{64, 32, 32});
    ISqlJetDbHandle db;
    SqlJetBtreeShared pBt;
    SqlJetBtree$TransMode inTrans;
    boolean sharable;
    boolean locked;
    int wantToLock;
    SqlJetBtree pNext;
    SqlJetBtree pPrev;
    private SqlJetTransactionMode transMode = null;
    static List sharedCacheList = new LinkedList();

    static void TRACE(String string, Object ... objectArray) {
        if (SQLJET_LOG_BTREE) {
            SqlJetUtility.log(btreeLogger, string, objectArray);
        }
    }

    private void integrity() {
        assert (this.pBt.inTransaction != SqlJetBtree$TransMode.NONE || this.pBt.nTransaction == 0);
        assert (this.pBt.inTransaction.compareTo(this.inTrans) >= 0);
    }

    public ISqlJetDbHandle getDb() {
        return this.db;
    }

    public SqlJetTransactionMode getTransMode() {
        return this.transMode;
    }

    public boolean invokeBusyHandler(int n2) {
        assert (this.db != null);
        assert (this.db.getMutex().held());
        ISqlJetBusyHandler iSqlJetBusyHandler = this.db.getBusyHandler();
        if (iSqlJetBusyHandler == null) {
            return false;
        }
        return iSqlJetBusyHandler.call(n2);
    }

    public void enter() {
        SqlJetBtree sqlJetBtree = this;
        assert (sqlJetBtree.pNext == null || sqlJetBtree.pNext.pBt.hashCode() > sqlJetBtree.pBt.hashCode());
        assert (sqlJetBtree.pPrev == null || sqlJetBtree.pPrev.pBt.hashCode() < sqlJetBtree.pBt.hashCode());
        assert (sqlJetBtree.pNext == null || sqlJetBtree.pNext.db == sqlJetBtree.db);
        assert (sqlJetBtree.pPrev == null || sqlJetBtree.pPrev.db == sqlJetBtree.db);
        assert (sqlJetBtree.sharable || sqlJetBtree.pNext == null && sqlJetBtree.pPrev == null);
        assert (!sqlJetBtree.locked || sqlJetBtree.wantToLock > 0);
        assert (sqlJetBtree.sharable || sqlJetBtree.wantToLock == 0);
        assert (sqlJetBtree.db.getMutex().held());
        if (!sqlJetBtree.sharable) {
            return;
        }
        ++sqlJetBtree.wantToLock;
        if (sqlJetBtree.locked) {
            return;
        }
        if (sqlJetBtree.pBt.mutex.attempt()) {
            sqlJetBtree.locked = true;
            return;
        }
        SqlJetBtree sqlJetBtree2 = sqlJetBtree.pNext;
        while (sqlJetBtree2 != null) {
            assert (sqlJetBtree2.sharable);
            assert (sqlJetBtree2.pNext == null || sqlJetBtree2.pNext.pBt.hashCode() > sqlJetBtree2.pBt.hashCode());
            assert (!sqlJetBtree2.locked || sqlJetBtree2.wantToLock > 0);
            if (sqlJetBtree2.locked) {
                sqlJetBtree2.pBt.mutex.leave();
                sqlJetBtree2.locked = false;
            }
            sqlJetBtree2 = sqlJetBtree2.pNext;
        }
        sqlJetBtree.pBt.mutex.enter();
        sqlJetBtree.locked = true;
        sqlJetBtree2 = sqlJetBtree.pNext;
        while (sqlJetBtree2 != null) {
            if (sqlJetBtree2.wantToLock > 0) {
                sqlJetBtree2.pBt.mutex.enter();
                sqlJetBtree2.locked = true;
            }
            sqlJetBtree2 = sqlJetBtree2.pNext;
        }
    }

    public void leave() {
        SqlJetBtree sqlJetBtree = this;
        if (sqlJetBtree.sharable) {
            assert (sqlJetBtree.wantToLock > 0);
            --sqlJetBtree.wantToLock;
            if (sqlJetBtree.wantToLock == 0) {
                assert (sqlJetBtree.locked);
                sqlJetBtree.pBt.mutex.leave();
                sqlJetBtree.locked = false;
            }
        }
    }

    boolean holdsMutex() {
        return !this.sharable || this.locked && this.wantToLock != 0 && this.pBt.mutex.held();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file, ISqlJetDbHandle iSqlJetDbHandle, Set set, SqlJetFileType sqlJetFileType, Set set2) {
        block25: {
            Object object;
            Object object2;
            boolean bl2;
            SqlJetBtreeShared sqlJetBtreeShared2 = null;
            ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(100);
            boolean bl3 = bl2 = file != null && ":memory:".equals(file.getPath());
            assert (iSqlJetDbHandle != null);
            ISqlJetFileSystem iSqlJetFileSystem = iSqlJetDbHandle.getFileSystem();
            this.inTrans = SqlJetBtree$TransMode.NONE;
            this.db = iSqlJetDbHandle;
            if (!bl2 && !iSqlJetDbHandle.getFlags().contains((Object)SqlJetDbFlags.Vtab) && file != null && !"".equals(file.getPath()) && iSqlJetDbHandle.getConfig().isSharedCacheEnabled()) {
                this.sharable = true;
                iSqlJetDbHandle.getFlags().add(SqlJetDbFlags.SharedCache);
                object2 = iSqlJetFileSystem.getFullPath(file);
                Object object3 = sharedCacheList;
                synchronized (object3) {
                    for (SqlJetBtreeShared sqlJetBtreeShared2 : sharedCacheList) {
                        assert (sqlJetBtreeShared2.nRef > 0);
                        object = iSqlJetFileSystem.getFullPath(sqlJetBtreeShared2.pPager.getFileName());
                        if (!((String)object2).equals(object) || iSqlJetFileSystem != sqlJetBtreeShared2.pPager.getFileSystem()) continue;
                        this.pBt = sqlJetBtreeShared2;
                        ++sqlJetBtreeShared2.nRef;
                        break;
                    }
                }
            }
            try {
                if (this.pBt == null) {
                    int n2;
                    sqlJetBtreeShared2 = new SqlJetBtreeShared();
                    sqlJetBtreeShared2.pPager = new SqlJetPager();
                    sqlJetBtreeShared2.pPager.open(iSqlJetFileSystem, file, SqlJetBtreeFlags.toPagerFlags(set), sqlJetFileType, set2);
                    sqlJetBtreeShared2.pPager.readFileHeader(iSqlJetMemoryPointer.remaining(), iSqlJetMemoryPointer);
                    sqlJetBtreeShared2.pPager.setBusyhandler(new SqlJetBtree$1(this));
                    this.pBt = sqlJetBtreeShared2;
                    sqlJetBtreeShared2.pPager.setReiniter(new SqlJetBtree$2(this));
                    sqlJetBtreeShared2.pCursor = null;
                    sqlJetBtreeShared2.pPage1 = null;
                    sqlJetBtreeShared2.readOnly = sqlJetBtreeShared2.pPager.isReadOnly();
                    sqlJetBtreeShared2.pageSize = SqlJetUtility.get2byte(iSqlJetMemoryPointer, 16);
                    if (sqlJetBtreeShared2.pageSize < 512 || sqlJetBtreeShared2.pageSize > 32768 || (sqlJetBtreeShared2.pageSize - 1 & sqlJetBtreeShared2.pageSize) != 0) {
                        sqlJetBtreeShared2.pageSize = 1024;
                        sqlJetBtreeShared2.pageSize = sqlJetBtreeShared2.pPager.setPageSize(sqlJetBtreeShared2.pageSize);
                        if (null != file && !bl2) {
                            sqlJetBtreeShared2.autoVacuum = SQLJET_DEFAULT_AUTOVACUUM != SqlJetAutoVacuumMode.NONE;
                            sqlJetBtreeShared2.incrVacuum = SQLJET_DEFAULT_AUTOVACUUM == SqlJetAutoVacuumMode.FULL;
                        }
                        n2 = 0;
                    } else {
                        n2 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, 20);
                        sqlJetBtreeShared2.pageSizeFixed = true;
                        sqlJetBtreeShared2.autoVacuum = SqlJetUtility.get4byte(iSqlJetMemoryPointer, 52) != 0;
                        sqlJetBtreeShared2.incrVacuum = SqlJetUtility.get4byte(iSqlJetMemoryPointer, 64) != 0;
                    }
                    sqlJetBtreeShared2.usableSize = sqlJetBtreeShared2.pageSize - n2;
                    assert ((sqlJetBtreeShared2.pageSize & 7) == 0);
                    sqlJetBtreeShared2.pageSize = sqlJetBtreeShared2.pPager.setPageSize(sqlJetBtreeShared2.pageSize);
                    if (this.sharable) {
                        sqlJetBtreeShared2.mutex = new SqlJetMutex();
                        sqlJetBtreeShared2.nRef = 1;
                        object2 = sharedCacheList;
                        synchronized (object2) {
                            sharedCacheList.add(sqlJetBtreeShared2);
                        }
                    }
                }
                if (!this.sharable) break block25;
                for (Object object3 : iSqlJetDbHandle.getBackends()) {
                    ISqlJetBtree iSqlJetBtree = object3.getBtree();
                    if (iSqlJetBtree == null || !(iSqlJetBtree instanceof SqlJetBtree)) continue;
                    object = (SqlJetBtree)iSqlJetBtree;
                    if (!((SqlJetBtree)object).sharable) continue;
                    while (((SqlJetBtree)object).pPrev != null) {
                        object = ((SqlJetBtree)object).pPrev;
                    }
                    if (this.pBt.hashCode() < ((SqlJetBtree)object).pBt.hashCode()) {
                        this.pNext = object;
                        this.pPrev = null;
                        ((SqlJetBtree)object).pPrev = this;
                    } else {
                        while (((SqlJetBtree)object).pNext != null && ((SqlJetBtree)object).pNext.pBt.hashCode() < this.pBt.hashCode()) {
                            object = ((SqlJetBtree)object).pNext;
                        }
                        this.pNext = ((SqlJetBtree)object).pNext;
                        this.pPrev = object;
                        if (this.pNext != null) {
                            this.pNext.pPrev = this;
                        }
                        ((SqlJetBtree)object).pNext = this;
                    }
                    break;
                }
            }
            catch (SqlJetException sqlJetException) {
                if (sqlJetBtreeShared2 != null && sqlJetBtreeShared2.pPager != null) {
                    sqlJetBtreeShared2.pPager.close();
                }
                throw sqlJetException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SqlJetBtree sqlJetBtree = this;
        assert (sqlJetBtree.db.getMutex().held());
        sqlJetBtree.enter();
        try {
            this.pBt.db = this.db;
            SqlJetBtreeCursor sqlJetBtreeCursor = this.pBt.pCursor;
            while (sqlJetBtreeCursor != null) {
                SqlJetBtreeCursor sqlJetBtreeCursor2 = sqlJetBtreeCursor;
                sqlJetBtreeCursor = sqlJetBtreeCursor.pNext;
                if (sqlJetBtreeCursor2.pBtree != sqlJetBtree) continue;
                sqlJetBtreeCursor2.closeCursor();
            }
            sqlJetBtree.rollback();
        }
        finally {
            sqlJetBtree.leave();
        }
        assert (sqlJetBtree.wantToLock == 0 && !sqlJetBtree.locked);
        if (!sqlJetBtree.sharable || SqlJetBtree.removeFromSharingList(this.pBt)) {
            assert (this.pBt.pCursor == null);
            this.pBt.pPager.close();
            this.pBt.pSchema = null;
            this.pBt.pTmpSpace = null;
        }
        this.pBt = null;
        assert (sqlJetBtree.wantToLock == 0);
        assert (!sqlJetBtree.locked);
        if (sqlJetBtree.pPrev != null) {
            sqlJetBtree.pPrev.pNext = sqlJetBtree.pNext;
        }
        if (sqlJetBtree.pNext != null) {
            sqlJetBtree.pNext.pPrev = sqlJetBtree.pPrev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeFromSharingList(SqlJetBtreeShared sqlJetBtreeShared) {
        boolean bl2 = false;
        List list = sharedCacheList;
        synchronized (list) {
            sqlJetBtreeShared.mutex.enter();
            try {
                --sqlJetBtreeShared.nRef;
            }
            finally {
                sqlJetBtreeShared.mutex.leave();
            }
            if (sqlJetBtreeShared.nRef <= 0) {
                sharedCacheList.remove(sqlJetBtreeShared);
                bl2 = true;
            }
        }
        return bl2;
    }

    public void setCacheSize(int n2) {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            this.pBt.pPager.setCacheSize(n2);
        }
        finally {
            this.leave();
        }
    }

    public int getCacheSize() {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            int n2 = this.pBt.pPager.getCacheSize();
            return n2;
        }
        finally {
            this.leave();
        }
    }

    public void setSafetyLevel(SqlJetSafetyLevel sqlJetSafetyLevel) {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            this.pBt.pPager.setSafetyLevel(sqlJetSafetyLevel);
        }
        finally {
            this.leave();
        }
    }

    public SqlJetSafetyLevel getSafetyLevel() {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            SqlJetSafetyLevel sqlJetSafetyLevel = this.pBt.pPager.getSafetyLevel();
            return sqlJetSafetyLevel;
        }
        finally {
            this.leave();
        }
    }

    public void setJournalMode(SqlJetPagerJournalMode sqlJetPagerJournalMode) {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            this.pBt.pPager.setJournalMode(sqlJetPagerJournalMode);
        }
        finally {
            this.leave();
        }
    }

    public SqlJetPagerJournalMode getJournalMode() {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            SqlJetPagerJournalMode sqlJetPagerJournalMode = this.pBt.pPager.getJournalMode();
            return sqlJetPagerJournalMode;
        }
        finally {
            this.leave();
        }
    }

    public boolean isSyncDisabled() {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            assert (this.pBt != null && this.pBt.pPager != null);
            boolean bl2 = this.pBt.pPager.isNoSync();
            return bl2;
        }
        finally {
            this.leave();
        }
    }

    public void setPageSize(int n2, int n3) {
        assert (n3 >= -1 && n3 <= 255);
        this.enter();
        try {
            if (this.pBt.pageSizeFixed) {
                throw new SqlJetException(SqlJetErrorCode.READONLY);
            }
            if (n3 < 0) {
                n3 = this.pBt.pageSize - this.pBt.usableSize;
            }
            assert (n3 >= 0 && n3 <= 255);
            if (n2 >= 512 && n2 <= 32768 && (n2 - 1 & n2) == 0) {
                assert ((n2 & 7) == 0);
                assert (this.pBt.pPage1 == null && this.pBt.pCursor == null);
                this.pBt.pageSize = n2;
                this.pBt.pTmpSpace = null;
                this.pBt.pageSize = this.pBt.pPager.setPageSize(this.pBt.pageSize);
            }
            this.pBt.usableSize = this.pBt.pageSize - n3;
        }
        finally {
            this.leave();
        }
    }

    public int getPageSize() {
        return this.pBt.pageSize;
    }

    public void setMaxPageCount(int n2) {
        this.enter();
        try {
            this.pBt.pPager.setMaxPageCount(n2);
        }
        finally {
            this.leave();
        }
    }

    public int getReserve() {
        this.enter();
        try {
            int n2 = this.pBt.pageSize - this.pBt.usableSize;
            return n2;
        }
        finally {
            this.leave();
        }
    }

    public void setAutoVacuum(SqlJetAutoVacuumMode sqlJetAutoVacuumMode) {
        boolean bl2 = sqlJetAutoVacuumMode != SqlJetAutoVacuumMode.NONE;
        this.enter();
        try {
            if (this.pBt.pageSizeFixed && bl2 != this.pBt.autoVacuum) {
                throw new SqlJetException(SqlJetErrorCode.READONLY);
            }
            this.pBt.autoVacuum = bl2;
        }
        finally {
            this.leave();
        }
    }

    public SqlJetAutoVacuumMode getAutoVacuum() {
        this.enter();
        try {
            SqlJetAutoVacuumMode sqlJetAutoVacuumMode = !this.pBt.autoVacuum ? SqlJetAutoVacuumMode.NONE : (!this.pBt.incrVacuum ? SqlJetAutoVacuumMode.FULL : SqlJetAutoVacuumMode.INCR);
            return sqlJetAutoVacuumMode;
        }
        finally {
            this.leave();
        }
    }

    private void lockBtree() {
        SqlJetErrorCode sqlJetErrorCode = null;
        assert (this.pBt.mutex.held());
        if (this.pBt.pPage1 != null) {
            return;
        }
        SqlJetMemPage sqlJetMemPage = this.pBt.getPage(1, false);
        try {
            int n2 = this.pBt.pPager.getPageCount();
            if (n2 > 0) {
                ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage.aData;
                sqlJetErrorCode = SqlJetErrorCode.NOTADB;
                if (SqlJetUtility.memcmp(iSqlJetMemoryPointer, zMagicHeader, 16) != 0) {
                    throw new SqlJetException(sqlJetErrorCode);
                }
                if (SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, 18) > 1) {
                    this.pBt.readOnly = true;
                }
                if (SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, 19) > 1) {
                    throw new SqlJetException(sqlJetErrorCode);
                }
                if (SqlJetUtility.memcmp(iSqlJetMemoryPointer, 21, PAGE1_21, 0, 3) != 0) {
                    throw new SqlJetException(sqlJetErrorCode);
                }
                int n3 = SqlJetUtility.get2byte(iSqlJetMemoryPointer, 16);
                if ((n3 - 1 & n3) != 0 || n3 < 512) {
                    throw new SqlJetException(sqlJetErrorCode);
                }
                assert ((n3 & 7) == 0);
                int n4 = n3 - SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, 20);
                if (n3 != this.pBt.pageSize) {
                    SqlJetMemPage.releasePage(sqlJetMemPage);
                    this.pBt.usableSize = n4;
                    this.pBt.pageSize = n3;
                    this.freeTempSpace(this.pBt);
                    this.pBt.pageSize = this.pBt.pPager.setPageSize(this.pBt.pageSize);
                    return;
                }
                if (n4 < 500) {
                    throw new SqlJetException(sqlJetErrorCode);
                }
                this.pBt.pageSize = n3;
                this.pBt.usableSize = n4;
                this.pBt.autoVacuum = SqlJetUtility.get4byte(iSqlJetMemoryPointer, 52) > 0;
                this.pBt.incrVacuum = SqlJetUtility.get4byte(iSqlJetMemoryPointer, 64) > 0;
            }
            this.pBt.maxLocal = (this.pBt.usableSize - 12) * 64 / 255 - 23;
            this.pBt.minLocal = (this.pBt.usableSize - 12) * 32 / 255 - 23;
            this.pBt.maxLeaf = this.pBt.usableSize - 35;
            this.pBt.minLeaf = (this.pBt.usableSize - 12) * 32 / 255 - 23;
            assert (this.pBt.maxLeaf + 23 <= this.pBt.MX_CELL_SIZE());
            this.pBt.pPage1 = sqlJetMemPage;
            return;
        }
        catch (SqlJetException sqlJetException) {
            SqlJetMemPage.releasePage(sqlJetMemPage);
            this.pBt.pPage1 = null;
            throw sqlJetException;
        }
    }

    private void freeTempSpace(SqlJetBtreeShared sqlJetBtreeShared) {
        sqlJetBtreeShared.pTmpSpace = null;
    }

    private void newDatabase() {
        assert (this.pBt.mutex.held());
        int n2 = this.pBt.pPager.getPageCount();
        if (n2 > 0) {
            return;
        }
        SqlJetMemPage sqlJetMemPage = this.pBt.pPage1;
        assert (sqlJetMemPage != null);
        ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetMemPage.aData;
        sqlJetMemPage.pDbPage.write();
        SqlJetUtility.memcpy(iSqlJetMemoryPointer, zMagicHeader, zMagicHeader.remaining());
        assert (zMagicHeader.remaining() == 16);
        SqlJetUtility.put2byte(iSqlJetMemoryPointer, 16, this.pBt.pageSize);
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 18, 1);
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 19, 1);
        assert (this.pBt.usableSize <= this.pBt.pageSize && this.pBt.usableSize + 255 >= this.pBt.pageSize);
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 20, (byte)(this.pBt.pageSize - this.pBt.usableSize));
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 21, 64);
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 22, 32);
        SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 23, 32);
        SqlJetUtility.memset(iSqlJetMemoryPointer, 24, (byte)0, 76);
        sqlJetMemPage.zeroPage(13);
        this.pBt.pageSizeFixed = true;
        SqlJetUtility.put4byte(iSqlJetMemoryPointer, 52, this.pBt.autoVacuum ? 1L : 0L);
        SqlJetUtility.put4byte(iSqlJetMemoryPointer, 64, this.pBt.incrVacuum ? 1L : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTrans(SqlJetTransactionMode sqlJetTransactionMode) {
        block32: {
            SqlJetException sqlJetException = null;
            this.enter();
            try {
                this.pBt.db = this.db;
                this.integrity();
                if (this.inTrans == SqlJetBtree$TransMode.WRITE || this.inTrans == SqlJetBtree$TransMode.READ && sqlJetTransactionMode == SqlJetTransactionMode.READ_ONLY) {
                    return;
                }
                if (this.pBt.readOnly && sqlJetTransactionMode != SqlJetTransactionMode.READ_ONLY) {
                    throw new SqlJetException(SqlJetErrorCode.READONLY);
                }
                if (this.pBt.inTransaction == SqlJetBtree$TransMode.WRITE && sqlJetTransactionMode != SqlJetTransactionMode.READ_ONLY) {
                    throw new SqlJetException(SqlJetErrorCode.BUSY);
                }
                if (sqlJetTransactionMode == SqlJetTransactionMode.EXCLUSIVE) {
                    Iterator iterator = this.pBt.pLock.iterator();
                    while (iterator.hasNext()) {
                        if (((SqlJetBtreeLock)iterator.next()).pBtree == this) continue;
                        throw new SqlJetException(SqlJetErrorCode.BUSY);
                    }
                }
                int n2 = 0;
                do {
                    sqlJetException = null;
                    try {
                        if (this.pBt.pPage1 == null) {
                            do {
                                this.lockBtree();
                            } while (this.pBt.pPage1 == null);
                        }
                        if (sqlJetTransactionMode != SqlJetTransactionMode.READ_ONLY) {
                            if (this.pBt.readOnly) {
                                throw new SqlJetException(SqlJetErrorCode.READONLY);
                            }
                            this.pBt.pPager.begin(sqlJetTransactionMode == SqlJetTransactionMode.EXCLUSIVE);
                            this.newDatabase();
                        }
                        if (sqlJetTransactionMode == SqlJetTransactionMode.READ_ONLY) continue;
                        this.pBt.inStmt = false;
                    }
                    catch (SqlJetException sqlJetException2) {
                        sqlJetException = sqlJetException2;
                        this.pBt.unlockBtreeIfUnused();
                    }
                } while (sqlJetException != null && sqlJetException.getErrorCode() == SqlJetErrorCode.BUSY && this.pBt.inTransaction == SqlJetBtree$TransMode.NONE && this.invokeBusyHandler(n2) && n2++ > -1);
                if (sqlJetException == null) {
                    if (this.inTrans == SqlJetBtree$TransMode.NONE) {
                        ++this.pBt.nTransaction;
                    }
                    SqlJetBtree$TransMode sqlJetBtree$TransMode = this.inTrans = sqlJetTransactionMode != SqlJetTransactionMode.READ_ONLY ? SqlJetBtree$TransMode.WRITE : SqlJetBtree$TransMode.READ;
                    if (this.inTrans.compareTo(this.pBt.inTransaction) > 0) {
                        this.pBt.inTransaction = this.inTrans;
                    }
                    if (sqlJetTransactionMode == SqlJetTransactionMode.EXCLUSIVE) {
                        assert (this.pBt.pExclusive == null);
                        this.pBt.pExclusive = this;
                    }
                }
                this.transMode = sqlJetTransactionMode;
            }
            catch (SqlJetException sqlJetException3) {
                sqlJetException = sqlJetException3;
            }
            finally {
                if (sqlJetException == null && sqlJetTransactionMode != SqlJetTransactionMode.READ_ONLY) {
                    try {
                        this.pBt.pPager.openSavepoint(this.db.getSavepointNum());
                    }
                    catch (SqlJetException sqlJetException4) {
                        sqlJetException = sqlJetException4;
                    }
                }
                this.integrity();
                this.leave();
                if (sqlJetException == null) break block32;
                throw sqlJetException;
            }
        }
    }

    public void commitPhaseOne(String string) {
        if (this.inTrans == SqlJetBtree$TransMode.WRITE) {
            this.enter();
            try {
                this.pBt.db = this.db;
                if (this.pBt.autoVacuum) {
                    this.pBt.autoVacuumCommit();
                }
                this.pBt.pPager.commitPhaseOne(string, false);
            }
            finally {
                this.leave();
            }
        }
    }

    private void unlockAllTables() {
        Iterator iterator = this.pBt.pLock.iterator();
        assert (this.holdsMutex());
        assert (this.sharable || !iterator.hasNext());
        while (iterator.hasNext()) {
            SqlJetBtreeLock sqlJetBtreeLock = (SqlJetBtreeLock)iterator.next();
            assert (this.pBt.pExclusive == null || this.pBt.pExclusive == sqlJetBtreeLock.pBtree);
            if (sqlJetBtreeLock.pBtree != this) continue;
            iterator.remove();
        }
        if (this.pBt.pExclusive == this) {
            this.pBt.pExclusive = null;
        }
    }

    public void commitPhaseTwo() {
        this.enter();
        try {
            this.pBt.db = this.db;
            this.integrity();
            if (this.inTrans == SqlJetBtree$TransMode.WRITE) {
                assert (this.pBt.inTransaction == SqlJetBtree$TransMode.WRITE);
                assert (this.pBt.nTransaction > 0);
                this.pBt.pPager.commitPhaseTwo();
                this.pBt.inTransaction = SqlJetBtree$TransMode.READ;
                this.pBt.inStmt = false;
            }
            this.unlockAllTables();
            if (this.inTrans != SqlJetBtree$TransMode.NONE) {
                --this.pBt.nTransaction;
                if (0 == this.pBt.nTransaction) {
                    this.pBt.inTransaction = SqlJetBtree$TransMode.NONE;
                }
            }
            this.inTrans = SqlJetBtree$TransMode.NONE;
            this.pBt.unlockBtreeIfUnused();
            this.integrity();
        }
        finally {
            this.leave();
        }
    }

    public void commit() {
        this.enter();
        try {
            this.commitPhaseOne(null);
            this.commitPhaseTwo();
            this.transMode = null;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        this.enter();
        try {
            block17: {
                block18: {
                    this.pBt.db = this.db;
                    try {
                        this.pBt.saveAllCursors(0, null);
                    }
                    catch (SqlJetException sqlJetException) {
                        this.tripAllCursors(sqlJetException.getErrorCode());
                    }
                    this.integrity();
                    this.unlockAllTables();
                    try {
                        if (this.inTrans == SqlJetBtree$TransMode.WRITE) {
                            assert (SqlJetBtree$TransMode.WRITE == this.pBt.inTransaction);
                            try {
                                this.pBt.pPager.rollback();
                                Object var4_2 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_3 = null;
                                try {
                                    SqlJetMemPage sqlJetMemPage = this.pBt.getPage(1, false);
                                    SqlJetMemPage.releasePage(sqlJetMemPage);
                                    Object var6_8 = null;
                                    this.pBt.inTransaction = SqlJetBtree$TransMode.READ;
                                }
                                catch (Throwable throwable2) {
                                    Object var6_9 = null;
                                    this.pBt.inTransaction = SqlJetBtree$TransMode.READ;
                                    throw throwable2;
                                }
                                throw throwable;
                            }
                            try {
                                SqlJetMemPage sqlJetMemPage = this.pBt.getPage(1, false);
                                SqlJetMemPage.releasePage(sqlJetMemPage);
                                Object var6_6 = null;
                                this.pBt.inTransaction = SqlJetBtree$TransMode.READ;
                            }
                            catch (Throwable throwable) {
                                Object var6_7 = null;
                                this.pBt.inTransaction = SqlJetBtree$TransMode.READ;
                                throw throwable;
                            }
                        }
                        Object var8_13 = null;
                        if (this.inTrans == SqlJetBtree$TransMode.NONE) break block17;
                        if ($assertionsDisabled || this.pBt.nTransaction > 0) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        if (this.inTrans != SqlJetBtree$TransMode.NONE) {
                            assert (this.pBt.nTransaction > 0);
                            --this.pBt.nTransaction;
                            if (0 == this.pBt.nTransaction) {
                                this.pBt.inTransaction = SqlJetBtree$TransMode.NONE;
                            }
                        }
                        this.inTrans = SqlJetBtree$TransMode.NONE;
                        this.pBt.inStmt = false;
                        this.pBt.unlockBtreeIfUnused();
                        this.integrity();
                        throw throwable;
                    }
                    throw new AssertionError();
                }
                --this.pBt.nTransaction;
                if (0 == this.pBt.nTransaction) {
                    this.pBt.inTransaction = SqlJetBtree$TransMode.NONE;
                }
            }
            this.inTrans = SqlJetBtree$TransMode.NONE;
            this.pBt.inStmt = false;
            this.pBt.unlockBtreeIfUnused();
            this.integrity();
            this.transMode = null;
            Object var10_16 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginStmt() {
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (this.inTrans == SqlJetBtree$TransMode.WRITE);
            assert (!this.pBt.inStmt);
            assert (!this.pBt.readOnly);
            if (this.inTrans != SqlJetBtree$TransMode.WRITE || this.pBt.inStmt || this.pBt.readOnly) {
                throw new SqlJetException(SqlJetErrorCode.INTERNAL);
            }
            assert (this.pBt.inTransaction == SqlJetBtree$TransMode.WRITE);
            try {
                this.pBt.pPager.openSavepoint(this.db.getSavepointNum() + 1);
                Object var2_1 = null;
                this.pBt.inStmt = true;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.pBt.inStmt = true;
                throw throwable;
            }
            Object var4_4 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitStmt() {
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (!this.pBt.readOnly);
            if (this.pBt.inStmt) {
                try {
                    int n2 = this.db.getSavepointNum();
                    this.pBt.pPager.savepoint(SqlJetSavepointOperation.RELEASE, n2);
                    Object var3_2 = null;
                    this.pBt.inStmt = false;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.pBt.inStmt = false;
                    throw throwable;
                }
            }
            Object var5_5 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackStmt() {
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (!this.pBt.readOnly);
            if (this.pBt.inStmt) {
                try {
                    int n2 = this.db.getSavepointNum();
                    this.pBt.pPager.savepoint(SqlJetSavepointOperation.ROLLBACK, n2);
                    this.pBt.pPager.savepoint(SqlJetSavepointOperation.RELEASE, n2);
                    Object var3_2 = null;
                    this.pBt.inStmt = false;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.pBt.inStmt = false;
                    throw throwable;
                }
            }
            Object var5_5 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.leave();
            throw throwable;
        }
    }

    protected void pageReinit(ISqlJetPage iSqlJetPage) {
        SqlJetMemPage sqlJetMemPage = (SqlJetMemPage)iSqlJetPage.getExtra();
        if (sqlJetMemPage != null && sqlJetMemPage.isInit) {
            assert (sqlJetMemPage.pBt.mutex.held());
            sqlJetMemPage.isInit = false;
            if (iSqlJetPage.getRefCount() > 0) {
                sqlJetMemPage.initPage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createTable(Set set) {
        this.enter();
        try {
            this.pBt.db = this.db;
            int n2 = this.doCreateTable(set);
            Object var4_3 = null;
            this.leave();
            return n2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCreateTable(Set set) {
        SqlJetMemPage sqlJetMemPage;
        int n2;
        assert (this.holdsMutex());
        assert (this.pBt.inTransaction == SqlJetBtree$TransMode.WRITE);
        assert (!this.pBt.readOnly);
        if (this.pBt.autoVacuum) {
            int[] nArray = new int[1];
            this.pBt.invalidateAllOverflowCache();
            n2 = this.getMeta(4);
            ++n2;
            while (n2 == this.pBt.PTRMAP_PAGENO(n2) || n2 == this.pBt.PENDING_BYTE_PAGE()) {
                ++n2;
            }
            assert (n2 >= 3);
            SqlJetMemPage sqlJetMemPage2 = this.pBt.allocatePage(nArray, n2, true);
            if (nArray[0] != n2) {
                short[] sArray = new short[]{0};
                int[] nArray2 = new int[]{0};
                SqlJetMemPage.releasePage(sqlJetMemPage2);
                sqlJetMemPage = this.pBt.getPage(n2, false);
                try {
                    this.pBt.ptrmapGet(n2, sArray, nArray2);
                    if (sArray[0] == 1 || sArray[0] == 2) {
                        throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                    }
                }
                catch (SqlJetException sqlJetException) {
                    SqlJetMemPage.releasePage(sqlJetMemPage);
                    throw sqlJetException;
                }
                assert (sArray[0] != 1);
                assert (sArray[0] != 2);
                try {
                    sqlJetMemPage.pDbPage.write();
                }
                catch (SqlJetException sqlJetException) {
                    SqlJetMemPage.releasePage(sqlJetMemPage);
                    throw sqlJetException;
                }
                try {
                    this.pBt.relocatePage(sqlJetMemPage, sArray[0], nArray2[0], nArray[0], false);
                    Object var10_14 = null;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    SqlJetMemPage.releasePage(sqlJetMemPage);
                    throw throwable;
                }
                SqlJetMemPage.releasePage(sqlJetMemPage);
                sqlJetMemPage = this.pBt.getPage(n2, false);
                try {
                    sqlJetMemPage.pDbPage.write();
                }
                catch (SqlJetException sqlJetException) {
                    SqlJetMemPage.releasePage(sqlJetMemPage);
                    throw sqlJetException;
                }
            }
            sqlJetMemPage = sqlJetMemPage2;
            try {
                this.pBt.ptrmapPut(n2, (short)1, 0);
            }
            catch (SqlJetException sqlJetException) {
                SqlJetMemPage.releasePage(sqlJetMemPage);
                throw sqlJetException;
            }
            try {
                this.updateMeta(4, n2);
            }
            catch (SqlJetException sqlJetException) {
                SqlJetMemPage.releasePage(sqlJetMemPage);
                throw sqlJetException;
            }
        }
        int[] nArray = new int[1];
        sqlJetMemPage = this.pBt.allocatePage(nArray, 1, false);
        n2 = nArray[0];
        try {
            sqlJetMemPage.zeroPage(SqlJetBtreeTableCreateFlags.toByte(set) | 8);
            Object var12_17 = null;
            sqlJetMemPage.pDbPage.unref();
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            sqlJetMemPage.pDbPage.unref();
            throw throwable;
        }
        return n2;
    }

    public boolean isInTrans() {
        assert (this.db.getMutex().held());
        return this.inTrans == SqlJetBtree$TransMode.WRITE;
    }

    public boolean isInStmt() {
        assert (this.holdsMutex());
        return this.pBt != null && this.pBt.inStmt;
    }

    public boolean isInReadTrans() {
        assert (this.db.getMutex().held());
        return this.inTrans == SqlJetBtree$TransMode.NONE;
    }

    public SqlJetSchema getSchema() {
        return (SqlJetSchema)this.pBt.pSchema;
    }

    public void setSchema(SqlJetSchema sqlJetSchema) {
        this.pBt.pSchema = sqlJetSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSchemaLocked() {
        assert (this.db.getMutex().held());
        this.enter();
        try {
            boolean bl2 = this.queryTableLock(1, SqlJetBtreeLockMode.READ);
            Object var3_2 = null;
            this.leave();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.leave();
            throw throwable;
        }
    }

    private boolean queryTableLock(int n2, SqlJetBtreeLockMode sqlJetBtreeLockMode) {
        assert (this.holdsMutex());
        assert (sqlJetBtreeLockMode != null);
        assert (this.db != null);
        if (!this.sharable) {
            return true;
        }
        if (this.pBt.pExclusive != null && this.pBt.pExclusive != this) {
            return false;
        }
        if (!this.db.getFlags().contains((Object)SqlJetDbFlags.ReadUncommitted) || sqlJetBtreeLockMode == SqlJetBtreeLockMode.WRITE || n2 == 1) {
            for (SqlJetBtreeLock sqlJetBtreeLock : this.pBt.pLock) {
                if (sqlJetBtreeLock.pBtree == this || sqlJetBtreeLock.iTable != n2 || sqlJetBtreeLock.eLock == sqlJetBtreeLockMode && sqlJetBtreeLockMode == SqlJetBtreeLockMode.READ) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTable(int n2, boolean bl2) {
        if (this.sharable) {
            this.enter();
            try {
                SqlJetBtreeLockMode sqlJetBtreeLockMode;
                SqlJetBtreeLockMode sqlJetBtreeLockMode2 = sqlJetBtreeLockMode = bl2 ? SqlJetBtreeLockMode.WRITE : SqlJetBtreeLockMode.READ;
                if (this.queryTableLock(n2, sqlJetBtreeLockMode)) {
                    this.lockTable(n2, sqlJetBtreeLockMode);
                }
                Object var5_4 = null;
                this.leave();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.leave();
                throw throwable;
            }
        }
    }

    private void lockTable(int n2, SqlJetBtreeLockMode sqlJetBtreeLockMode) {
        assert (this.holdsMutex());
        assert (sqlJetBtreeLockMode != null);
        assert (this.db != null);
        if (!this.sharable) {
            return;
        }
        assert (this.queryTableLock(n2, sqlJetBtreeLockMode));
        if (this.db.getFlags().contains((Object)SqlJetDbFlags.ReadUncommitted) && sqlJetBtreeLockMode == SqlJetBtreeLockMode.READ && n2 != 1) {
            return;
        }
        SqlJetBtreeLock sqlJetBtreeLock = null;
        for (SqlJetBtreeLock sqlJetBtreeLock2 : this.pBt.pLock) {
            if (sqlJetBtreeLock2.iTable != n2 || sqlJetBtreeLock2.pBtree != this) continue;
            sqlJetBtreeLock = sqlJetBtreeLock2;
            break;
        }
        if (null == sqlJetBtreeLock) {
            sqlJetBtreeLock = new SqlJetBtreeLock();
            sqlJetBtreeLock.iTable = n2;
            sqlJetBtreeLock.pBtree = this;
            this.pBt.pLock.add(sqlJetBtreeLock);
            sqlJetBtreeLock.eLock = sqlJetBtreeLockMode;
        }
        if (sqlJetBtreeLockMode == SqlJetBtreeLockMode.WRITE && sqlJetBtreeLock.eLock == SqlJetBtreeLockMode.READ) {
            sqlJetBtreeLock.eLock = sqlJetBtreeLockMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savepoint(SqlJetSavepointOperation sqlJetSavepointOperation, int n2) {
        if (this.inTrans == SqlJetBtree$TransMode.WRITE) {
            assert (!this.pBt.inStmt);
            assert (sqlJetSavepointOperation == SqlJetSavepointOperation.RELEASE || sqlJetSavepointOperation == SqlJetSavepointOperation.ROLLBACK);
            assert (n2 >= 0 || n2 == -1 && sqlJetSavepointOperation == SqlJetSavepointOperation.ROLLBACK);
            this.enter();
            try {
                this.pBt.db = this.db;
                this.pBt.pPager.savepoint(sqlJetSavepointOperation, n2);
                this.newDatabase();
                Object var4_3 = null;
                this.leave();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.leave();
                throw throwable;
            }
        }
    }

    public File getFilename() {
        assert (this.pBt.pPager != null);
        return this.pBt.pPager.getFileName();
    }

    public File getDirname() {
        assert (this.pBt.pPager != null);
        return this.pBt.pPager.getDirectoryName();
    }

    public File getJournalname() {
        assert (this.pBt.pPager != null);
        return this.pBt.pPager.getJournalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(ISqlJetBtree iSqlJetBtree) {
        this.enter();
        try {
            SqlJetBtree sqlJetBtree = (SqlJetBtree)iSqlJetBtree;
            sqlJetBtree.enter();
            try {
                this.doCopyFile(sqlJetBtree);
                Object var4_3 = null;
                this.leave();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.leave();
                throw throwable;
            }
            Object var6_6 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyFile(SqlJetBtree sqlJetBtree) {
        long l2;
        Object object;
        SqlJetBtree sqlJetBtree2 = this;
        SqlJetBtreeShared sqlJetBtreeShared = sqlJetBtree2.pBt;
        SqlJetBtreeShared sqlJetBtreeShared2 = sqlJetBtree.pBt;
        sqlJetBtreeShared.db = sqlJetBtree2.db;
        sqlJetBtreeShared2.db = sqlJetBtree.db;
        int n2 = sqlJetBtreeShared.pageSize;
        int n3 = sqlJetBtreeShared2.pageSize;
        assert (sqlJetBtree2.inTrans == SqlJetBtree$TransMode.WRITE);
        assert (sqlJetBtree.inTrans == SqlJetBtree$TransMode.WRITE);
        if (sqlJetBtreeShared.pCursor != null) {
            throw new SqlJetException(SqlJetErrorCode.BUSY);
        }
        int n4 = sqlJetBtreeShared.pPager.getPageCount();
        int n5 = sqlJetBtreeShared2.pPager.getPageCount();
        int n6 = sqlJetBtreeShared.PENDING_BYTE_PAGE();
        int n7 = (int)(((long)n5 * (long)n3 + (long)n2 - 1L) / (long)n2);
        for (int i2 = 1; i2 <= n4 || i2 <= n7; ++i2) {
            Object object2;
            if (i2 != n6 && i2 <= n4) {
                Object var14_15;
                object = null;
                object = sqlJetBtreeShared.pPager.getPage(i2);
                try {
                    object.write();
                    if (i2 > n5) {
                        object.dontWrite();
                    }
                    var14_15 = null;
                    object.unref();
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    object.unref();
                    throw throwable;
                }
            }
            if (i2 == n6 || i2 > n7) continue;
            object = null;
            object = sqlJetBtreeShared.pPager.getPage(i2);
            object.write();
            for (l2 = (long)(i2 - 1) * (long)n2; l2 < (long)i2 * (long)n2; l2 += (long)n3) {
                int n8;
                object2 = null;
                int n9 = (int)(l2 / (long)n3) + 1;
                if (n9 == sqlJetBtreeShared2.PENDING_BYTE_PAGE()) continue;
                object2 = sqlJetBtreeShared2.pPager.getPage(n9);
                ISqlJetMemoryPointer iSqlJetMemoryPointer = object.getData();
                ISqlJetMemoryPointer iSqlJetMemoryPointer2 = object2.getData();
                int n10 = 0;
                int n11 = 0;
                if (n3 >= n2) {
                    n10 += (i2 - 1) * n2 - (n9 - 1) * n3;
                    n8 = n2;
                } else {
                    n11 += (n9 - 1) * n3 - (i2 - 1) * n2;
                    n8 = n3;
                }
                SqlJetUtility.memcpy(iSqlJetMemoryPointer, n11, iSqlJetMemoryPointer2, n10, n8);
                object2.unref();
            }
            if (object == null) continue;
            object2 = (SqlJetMemPage)object.getExtra();
            ((SqlJetMemPage)object2).isInit = false;
            object.unref();
        }
        object = sqlJetBtreeShared.pPager.getFile();
        l2 = (long)n3 * (long)n5;
        long l3 = (long)(n4 > n7 ? n4 : n7) * (long)n2;
        long l4 = ((long)sqlJetBtreeShared.PENDING_BYTE_PAGE() - 1L) * (long)n2;
        assert (l2 <= l3);
        sqlJetBtreeShared.db = sqlJetBtree2.db;
        sqlJetBtreeShared.pPager.commitPhaseOne(null, true);
        if (l2 < l3) {
            object.truncate(l2);
        }
        if (n3 < n2 && l2 > l4) {
            for (long i3 = l4; i3 < l4 + (long)n2; i3 += (long)n3) {
                ISqlJetPage iSqlJetPage = null;
                int n12 = (int)(i3 / (long)n3) + 1;
                if (n12 == sqlJetBtreeShared2.PENDING_BYTE_PAGE() || n12 > n5) continue;
                iSqlJetPage = sqlJetBtreeShared2.pPager.getPage(n12);
                ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetPage.getData();
                object.write(iSqlJetMemoryPointer, n3, i3);
                iSqlJetPage.unref();
            }
        }
        try {
            sqlJetBtreeShared.pPager.sync();
            sqlJetBtreeShared.pageSizeFixed = false;
        }
        catch (SqlJetException sqlJetException) {
            sqlJetBtree2.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrVacuum() {
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (this.pBt.inTransaction == SqlJetBtree$TransMode.WRITE && this.inTrans == SqlJetBtree$TransMode.WRITE);
            if (!this.pBt.autoVacuum) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            this.pBt.invalidateAllOverflowCache();
            this.pBt.incrVacuumStep(0, this.pBt.pPager.imageSize());
            Object var2_1 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dropTable(int n2) {
        this.enter();
        try {
            this.pBt.db = this.db;
            int n3 = this.doDropTable(n2);
            Object var4_3 = null;
            this.leave();
            return n3;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doDropTable(int n2) {
        SqlJetMemPage sqlJetMemPage = null;
        assert (this.holdsMutex());
        assert (this.inTrans == SqlJetBtree$TransMode.WRITE);
        if (this.pBt.pCursor != null) {
            throw new SqlJetException(SqlJetErrorCode.LOCKED);
        }
        sqlJetMemPage = this.pBt.getPage(n2, false);
        try {
            this.clearTable(n2, null);
        }
        catch (SqlJetException sqlJetException) {
            SqlJetMemPage.releasePage(sqlJetMemPage);
            throw sqlJetException;
        }
        int n3 = 0;
        if (n2 > 1) {
            if (this.pBt.autoVacuum) {
                int n4;
                block23: {
                    try {
                        n4 = this.getMeta(4);
                    }
                    catch (SqlJetException sqlJetException) {
                        SqlJetMemPage.releasePage(sqlJetMemPage);
                        throw sqlJetException;
                    }
                    if (n2 == n4) {
                        try {
                            sqlJetMemPage.freePage();
                            Object var7_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_9 = null;
                            SqlJetMemPage.releasePage(sqlJetMemPage);
                            throw throwable;
                        }
                        SqlJetMemPage.releasePage(sqlJetMemPage);
                        {
                            break block23;
                        }
                    }
                    SqlJetMemPage.releasePage(sqlJetMemPage);
                    SqlJetMemPage sqlJetMemPage2 = this.pBt.getPage(n4, false);
                    try {
                        this.pBt.relocatePage(sqlJetMemPage2, (short)1, 0, n2, false);
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        SqlJetMemPage.releasePage(sqlJetMemPage2);
                        throw throwable;
                    }
                    SqlJetMemPage.releasePage(sqlJetMemPage2);
                    sqlJetMemPage2 = this.pBt.getPage(n4, false);
                    try {
                        sqlJetMemPage2.freePage();
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        SqlJetMemPage.releasePage(sqlJetMemPage2);
                        throw throwable;
                    }
                    SqlJetMemPage.releasePage(sqlJetMemPage2);
                    n3 = n4;
                }
                if (--n4 == this.pBt.PENDING_BYTE_PAGE()) {
                    --n4;
                }
                if (n4 == this.pBt.PTRMAP_PAGENO(n4)) {
                    --n4;
                }
                assert (n4 != this.pBt.PENDING_BYTE_PAGE());
                this.updateMeta(4, n4);
                return n3;
            }
            try {
                sqlJetMemPage.freePage();
                Object var13_17 = null;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                SqlJetMemPage.releasePage(sqlJetMemPage);
                throw throwable;
            }
            SqlJetMemPage.releasePage(sqlJetMemPage);
            return n3;
        }
        try {
            sqlJetMemPage.zeroPage(9);
            Object var15_20 = null;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            SqlJetMemPage.releasePage(sqlJetMemPage);
            throw throwable;
        }
        SqlJetMemPage.releasePage(sqlJetMemPage);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTable(int n2, int[] nArray) {
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (this.inTrans == SqlJetBtree$TransMode.WRITE);
            if (!this.checkReadLocks(n2, null, 1L) && this.pBt.saveAllCursors(n2, null)) {
                this.pBt.clearDatabasePage(n2, false, nArray);
            }
            Object var4_3 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.leave();
            throw throwable;
        }
    }

    boolean checkReadLocks(int n2, SqlJetBtreeCursor sqlJetBtreeCursor, long l2) {
        assert (this.holdsMutex());
        SqlJetBtreeCursor sqlJetBtreeCursor2 = this.pBt.pCursor;
        while (sqlJetBtreeCursor2 != null) {
            if (sqlJetBtreeCursor2 != sqlJetBtreeCursor && sqlJetBtreeCursor2.pgnoRoot == n2) {
                ISqlJetDbHandle iSqlJetDbHandle;
                if (sqlJetBtreeCursor2.isIncrblobHandle && (sqlJetBtreeCursor == null && l2 != 0L || sqlJetBtreeCursor != null && !sqlJetBtreeCursor.isIncrblobHandle && sqlJetBtreeCursor2.info.nKey == l2)) {
                    sqlJetBtreeCursor2.eState = SqlJetBtreeCursor$CursorState.INVALID;
                }
                if (!(sqlJetBtreeCursor2.eState != SqlJetBtreeCursor$CursorState.VALID || sqlJetBtreeCursor2.wrFlag && !sqlJetBtreeCursor2.isIncrblobHandle || (iSqlJetDbHandle = sqlJetBtreeCursor2.pBtree.db) != null && (iSqlJetDbHandle == this.db || iSqlJetDbHandle.getFlags().contains((Object)SqlJetDbFlags.ReadUncommitted)))) {
                    return true;
                }
            }
            sqlJetBtreeCursor2 = sqlJetBtreeCursor2.pNext;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMeta(int n2) {
        this.enter();
        try {
            ISqlJetMemoryPointer iSqlJetMemoryPointer;
            ISqlJetPage iSqlJetPage = null;
            this.pBt.db = this.db;
            this.queryTableLock(1, SqlJetBtreeLockMode.READ);
            assert (n2 >= 0 && n2 <= 15);
            if (this.pBt.pPage1 != null) {
                iSqlJetMemoryPointer = this.pBt.pPage1.aData;
            } else {
                iSqlJetPage = this.pBt.pPager.acquirePage(1, true);
                iSqlJetMemoryPointer = iSqlJetPage.getData();
            }
            int n3 = SqlJetUtility.get4byte(iSqlJetMemoryPointer, 36 + n2 * 4);
            if (this.pBt.pPage1 == null) {
                iSqlJetPage.unref();
            }
            this.lockTable(1, SqlJetBtreeLockMode.READ);
            int n4 = n3;
            Object var7_6 = null;
            this.leave();
            return n4;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMeta(int n2, int n3) {
        assert (n2 >= 1 && n2 <= 15);
        this.enter();
        try {
            this.pBt.db = this.db;
            assert (this.inTrans == SqlJetBtree$TransMode.WRITE);
            assert (this.pBt.pPage1 != null);
            ISqlJetMemoryPointer iSqlJetMemoryPointer = this.pBt.pPage1.aData;
            this.pBt.pPage1.pDbPage.write();
            SqlJetUtility.put4byte(iSqlJetMemoryPointer, 36 + n2 * 4, n3);
            if (n2 == 7) {
                assert (this.pBt.autoVacuum || n3 == 0);
                assert (n3 == 0 || n3 == 1);
                this.pBt.incrVacuum = n3 != 0;
            }
            Object var5_4 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tripAllCursors(SqlJetErrorCode sqlJetErrorCode) {
        this.enter();
        try {
            SqlJetBtreeCursor sqlJetBtreeCursor = this.pBt.pCursor;
            while (sqlJetBtreeCursor != null) {
                sqlJetBtreeCursor.clearCursor();
                sqlJetBtreeCursor.eState = SqlJetBtreeCursor$CursorState.FAULT;
                sqlJetBtreeCursor.error = sqlJetErrorCode;
                sqlJetBtreeCursor.skip = sqlJetErrorCode != null ? 1 : 0;
                for (int i2 = 0; i2 <= sqlJetBtreeCursor.iPage; ++i2) {
                    SqlJetMemPage.releasePage(sqlJetBtreeCursor.apPage[i2]);
                    sqlJetBtreeCursor.apPage[i2] = null;
                }
                sqlJetBtreeCursor = sqlJetBtreeCursor.pNext;
            }
            Object var5_4 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.leave();
            throw throwable;
        }
    }

    public ISqlJetPager getPager() {
        return this.pBt.pPager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetBtreeCursor getCursor(int n2, boolean bl2, ISqlJetKeyInfo iSqlJetKeyInfo) {
        this.enter();
        try {
            this.pBt.db = this.db;
            SqlJetBtreeCursor sqlJetBtreeCursor = new SqlJetBtreeCursor(this, n2, bl2, iSqlJetKeyInfo);
            Object var6_5 = null;
            this.leave();
            return sqlJetBtreeCursor;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockWithRetry() {
        assert (this.holdsMutex());
        if (this.inTrans == SqlJetBtree$TransMode.NONE) {
            SqlJetBtree$TransMode sqlJetBtree$TransMode = this.pBt.inTransaction;
            this.integrity();
            try {
                this.beginTrans(SqlJetTransactionMode.READ_ONLY);
                Object var3_2 = null;
                this.pBt.inTransaction = sqlJetBtree$TransMode;
                this.inTrans = SqlJetBtree$TransMode.NONE;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.pBt.inTransaction = sqlJetBtree$TransMode;
                this.inTrans = SqlJetBtree$TransMode.NONE;
                throw throwable;
            }
            --this.pBt.nTransaction;
            this.integrity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllCursors() {
        this.enter();
        try {
            SqlJetBtreeCursor sqlJetBtreeCursor = this.pBt.pCursor;
            while (sqlJetBtreeCursor != null) {
                sqlJetBtreeCursor.closeCursor();
                sqlJetBtreeCursor = sqlJetBtreeCursor.pNext;
            }
            Object var3_2 = null;
            this.leave();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.leave();
            throw throwable;
        }
    }

    public String integrityCheck(int[] nArray, int n2, int n3, int[] nArray2) {
        return null;
    }
}

