/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.tmatesoft.sqljet.core.ISqlJetMutex;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetError;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryManager;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetMemoryBufferType;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetByteBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryManager;
import org.tmatesoft.sqljet.core.table.SqlJetScope;
import org.tmatesoft.sqljet.core.table.SqlJetScope$SqlJetScopeBound;

public final class SqlJetUtility {
    public static final String SQLJET_PACKAGENAME = "org.tmatesoft.sqljet";
    private static final boolean SQLJET_LOG_STACKTRACE = SqlJetUtility.getBoolSysProp("SQLJET_LOG_STACKTRACE", false);
    private static final boolean SQLJET_LOG_SIGNED = SqlJetUtility.getBoolSysProp("SQLJET_LOG_SIGNED", false);
    private static final Logger signedLogger = Logger.getLogger("SQLJET_LOG_SIGNED");
    public static final ISqlJetMemoryManager memoryManager = new SqlJetMemoryManager();
    private static final Pattern NUMBER_PATTER = Pattern.compile("[-+]?(([0-9]+)|([0-9]*\\.))[0-9]+([eE][-+]?[0-9]+)?");
    private static final Pattern REAL_PATTERN = Pattern.compile("[-+]?[0-9]*\\.[0-9]+([eE][-+]?[0-9]+)?");

    public static void log(Logger logger, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format(string, objectArray)).append('\n');
        if (SQLJET_LOG_STACKTRACE) {
            SqlJetUtility.logStackTrace(stringBuilder);
        }
        logger.info(stringBuilder.toString());
    }

    private static void logStackTrace(StringBuilder stringBuilder) {
        StackTraceElement[] stackTraceElementArray;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
            String string = stackTraceElement.toString();
            if (!string.startsWith(SQLJET_PACKAGENAME)) continue;
            stringBuilder.append('\t').append(string).append('\n');
        }
    }

    private static void logSigned(long l2) {
        if (SQLJET_LOG_SIGNED && l2 < 0L) {
            SqlJetUtility.log(signedLogger, "signed %d", l2);
        }
    }

    public static final ISqlJetMemoryPointer allocatePtr(int n2) {
        return memoryManager.allocatePtr(n2);
    }

    public static final ISqlJetMemoryPointer allocatePtr(int n2, SqlJetMemoryBufferType sqlJetMemoryBufferType) {
        return memoryManager.allocatePtr(n2, sqlJetMemoryBufferType);
    }

    public static final ISqlJetMemoryPointer pointer(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        return iSqlJetMemoryPointer.getBuffer().getPointer(iSqlJetMemoryPointer.getPointer());
    }

    public static final ISqlJetMemoryPointer pointer(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        return iSqlJetMemoryPointer.getBuffer().getPointer(iSqlJetMemoryPointer.getAbsolute(n2));
    }

    public static final void movePtr(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        iSqlJetMemoryPointer.movePointer(n2);
    }

    public static final ISqlJetMemoryPointer wrapPtr(byte[] byArray) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(byArray.length);
        iSqlJetMemoryPointer.putBytes(byArray);
        return iSqlJetMemoryPointer;
    }

    public static String getSysProp(String string, String string2) {
        if (null == string) {
            throw new SqlJetError("Undefined property name");
        }
        try {
            return System.getProperty(string, string2);
        }
        catch (Throwable throwable) {
            throw new SqlJetError("Error while get int value for property " + string, throwable);
        }
    }

    public static int getIntSysProp(String string, int n2) {
        if (null == string) {
            throw new SqlJetError("Undefined property name");
        }
        try {
            return Integer.valueOf(System.getProperty(string, Integer.toString(n2)));
        }
        catch (Throwable throwable) {
            throw new SqlJetError("Error while get int value for property " + string, throwable);
        }
    }

    public static boolean getBoolSysProp(String string, boolean bl2) {
        if (null == string) {
            throw new SqlJetError("Undefined property name");
        }
        try {
            return Boolean.valueOf(System.getProperty(string, Boolean.toString(bl2)));
        }
        catch (Throwable throwable) {
            throw new SqlJetError("Error while get int value for property " + string, throwable);
        }
    }

    public static Enum getEnumSysProp(String string, Enum enum_) {
        if (null == string) {
            throw new SqlJetError("Undefined property name");
        }
        if (null == enum_) {
            throw new SqlJetError("Undefined default value");
        }
        try {
            return Enum.valueOf(enum_.getDeclaringClass(), System.getProperty(string, enum_.toString()));
        }
        catch (Throwable throwable) {
            throw new SqlJetError("Error while get int value for property " + string, throwable);
        }
    }

    public static final int get2byte(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        return SqlJetUtility.get2byte(iSqlJetMemoryPointer, 0);
    }

    public static final int get2byte(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        return iSqlJetMemoryPointer.getShortUnsigned(n2);
    }

    public static final void put2byte(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        SqlJetUtility.put2byte(iSqlJetMemoryPointer, 0, n2);
    }

    public static final void put2byte(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, int n3) {
        iSqlJetMemoryPointer.putShortUnsigned(n2, n3);
    }

    public static final ISqlJetMemoryPointer put4byte(int n2) {
        SqlJetUtility.logSigned(n2);
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(4);
        iSqlJetMemoryPointer.putInt(0, n2);
        return iSqlJetMemoryPointer;
    }

    public static final int get4byte(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        return SqlJetUtility.get4byte(iSqlJetMemoryPointer, 0);
    }

    public static final int get4byte(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        int n3 = iSqlJetMemoryPointer.getInt(n2);
        SqlJetUtility.logSigned(n3);
        return n3;
    }

    public static final void put4byte(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, long l2) {
        if (null == iSqlJetMemoryPointer || iSqlJetMemoryPointer.remaining() - n2 < 4) {
            throw new SqlJetError("Wrong destination");
        }
        SqlJetUtility.logSigned(l2);
        iSqlJetMemoryPointer.putIntUnsigned(n2, l2);
    }

    public static final void put4byte(ISqlJetMemoryPointer iSqlJetMemoryPointer, long l2) {
        SqlJetUtility.put4byte(iSqlJetMemoryPointer, 0, l2);
    }

    public static final void memcpy(byte[] byArray, byte[] byArray2, int n2) {
        System.arraycopy(byArray2, 0, byArray, 0, n2);
    }

    public static final void memcpy(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        System.arraycopy(byArray2, n3, byArray, n2, n4);
    }

    public static final void memcpy(ISqlJetMemoryPointer iSqlJetMemoryPointer, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n2) {
        iSqlJetMemoryPointer.copyFrom(iSqlJetMemoryPointer2, n2);
    }

    public static final void memcpy(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n3, int n4) {
        iSqlJetMemoryPointer.copyFrom(n2, iSqlJetMemoryPointer2, n3, n4);
    }

    public static final void memcpy(SqlJetCloneable[] sqlJetCloneableArray, SqlJetCloneable[] sqlJetCloneableArray2, int n2) {
        SqlJetUtility.memcpy(sqlJetCloneableArray2, 0, sqlJetCloneableArray, 0, n2);
    }

    public static final SqlJetCloneable memcpy(SqlJetCloneable sqlJetCloneable) {
        try {
            return (SqlJetCloneable)sqlJetCloneable.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL, (Throwable)cloneNotSupportedException);
        }
    }

    private static final void memcpy(SqlJetCloneable[] sqlJetCloneableArray, int n2, SqlJetCloneable[] sqlJetCloneableArray2, int n3, int n4) {
        int n5 = n2;
        for (int i2 = n3; n5 < sqlJetCloneableArray.length && i2 < sqlJetCloneableArray2.length; ++n5, ++i2) {
            SqlJetCloneable sqlJetCloneable = sqlJetCloneableArray[n5];
            if (null == sqlJetCloneable) continue;
            try {
                sqlJetCloneableArray2[i2] = (SqlJetCloneable)sqlJetCloneable.clone();
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new SqlJetException(SqlJetErrorCode.INTERNAL, (Throwable)cloneNotSupportedException);
            }
        }
    }

    public static final void memset(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, byte by, int n3) {
        iSqlJetMemoryPointer.fill(n2, n3, by);
    }

    public static final void memset(ISqlJetMemoryPointer iSqlJetMemoryPointer, byte by, int n2) {
        SqlJetUtility.memset(iSqlJetMemoryPointer, 0, by, n2);
    }

    public static final void memset(ISqlJetMemoryPointer iSqlJetMemoryPointer, byte by) {
        SqlJetUtility.memset(iSqlJetMemoryPointer, by, iSqlJetMemoryPointer.remaining());
    }

    public static int strlen(byte[] byArray, int n2) {
        int n3;
        for (n3 = n2; n3 < byArray.length && byArray[n3] != 0; ++n3) {
        }
        return n3 - n2;
    }

    public static int strlen(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        int n3;
        for (n3 = n2; n3 < iSqlJetMemoryPointer.remaining() && SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n3) != 0; ++n3) {
        }
        return n3 - n2;
    }

    public static boolean bitSetTest(BitSet bitSet, int n2) {
        if (bitSet == null) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        return bitSet.get(n2);
    }

    public static final int memcmp(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Byte by;
            Byte by2 = byArray[i2];
            int n3 = by2.compareTo(by = Byte.valueOf(byArray2[i2]));
            if (0 == n3) continue;
            return n3;
        }
        return 0;
    }

    public static final int memcmp(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            Byte by;
            Byte by2 = byArray[n2 + i2];
            int n5 = by2.compareTo(by = Byte.valueOf(byArray2[n3 + i2]));
            if (0 == n5) continue;
            return n5;
        }
        return 0;
    }

    public static final int memcmp(ISqlJetMemoryPointer iSqlJetMemoryPointer, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, i2);
            int n5 = n4 - (n3 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer2, i2));
            if (0 == n5) continue;
            return n5;
        }
        return 0;
    }

    public static final int memcmp(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            int n6 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + i2);
            int n7 = n6 - (n5 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer2, n3 + i2));
            if (0 == n7) continue;
            return n7;
        }
        return 0;
    }

    public static byte[] addZeroByteEnd(byte[] byArray) {
        if (null == byArray) {
            throw new SqlJetError("Undefined byte array");
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        SqlJetUtility.memcpy(byArray2, byArray, byArray.length);
        byArray2[byArray.length] = 0;
        return byArray2;
    }

    public static byte[] getBytes(String string) {
        if (null == string) {
            throw new SqlJetError("Undefined string");
        }
        try {
            return string.getBytes("UTF8");
        }
        catch (Throwable throwable) {
            throw new SqlJetError("Error while get bytes for string \"" + string + "\"", throwable);
        }
    }

    public static int putVarint(ISqlJetMemoryPointer iSqlJetMemoryPointer, long l2) {
        if ((l2 & 0xFF00000000000000L) != 0L) {
            SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 8, (byte)l2);
            l2 >>= 8;
            for (int i2 = 7; i2 >= 0; --i2) {
                SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, i2, (byte)(l2 & 0x7FL | 0x80L));
                l2 >>= 7;
            }
            return 9;
        }
        int n2 = 0;
        byte[] byArray = new byte[10];
        do {
            byArray[n2++] = (byte)(l2 & 0x7FL | 0x80L);
        } while ((l2 >>= 7) != 0L);
        byArray[0] = (byte)(byArray[0] & 0x7F);
        assert (n2 <= 9);
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, n3, byArray[n4]);
            --n4;
            ++n3;
        }
        return n2;
    }

    public static int putVarint32(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        if (n2 < 128) {
            SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 0, (byte)n2);
            return 1;
        }
        if ((n2 & 0xFFFFFF80) == 0) {
            SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 0, (byte)n2);
            return 1;
        }
        if ((n2 & 0xFFFFC000) == 0) {
            SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 0, (byte)(n2 >> 7 | 0x80));
            SqlJetUtility.putUnsignedByte(iSqlJetMemoryPointer, 1, (byte)(n2 & 0x7F));
            return 2;
        }
        return SqlJetUtility.putVarint(iSqlJetMemoryPointer, n2);
    }

    public static byte getVarint(ISqlJetMemoryPointer iSqlJetMemoryPointer, long[] lArray) {
        return SqlJetUtility.getVarint(iSqlJetMemoryPointer, 0, lArray);
    }

    public static byte getVarint(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, long[] lArray) {
        byte by;
        long l2 = 0L;
        for (by = 0; by < 8; by = (byte)((byte)(by + 1))) {
            int n3 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, by + n2);
            l2 = l2 << 7 | (long)(n3 & 0x7F);
            if ((n3 & 0x80) != 0) continue;
            lArray[0] = l2;
            by = (byte)(by + 1);
            return by;
        }
        by = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, 8 + n2);
        lArray[0] = l2 = l2 << 8 | (long)by;
        return 9;
    }

    public static byte getVarint32(ISqlJetMemoryPointer iSqlJetMemoryPointer, int[] nArray) {
        return SqlJetUtility.getVarint32(iSqlJetMemoryPointer, 0, nArray);
    }

    public static byte getVarint32(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, int[] nArray) {
        int n3;
        int n4 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, 0 + n2);
        if (n4 < 128) {
            nArray[0] = n4;
            return 1;
        }
        int n5 = 0;
        int n6 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n5 + n2);
        if ((n6 & 0x80) == 0) {
            nArray[0] = n6;
            return 1;
        }
        if (((n3 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, ++n5 + n2)) & 0x80) == 0) {
            n6 &= 0x7F;
            nArray[0] = (n6 <<= 7) | n3;
            return 2;
        }
        n6 <<= 14;
        if (((n6 |= SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, ++n5 + n2)) & 0x80) == 0) {
            n3 &= 0x7F;
            nArray[0] = (n6 &= 0x1FC07F) | (n3 <<= 7);
            return 3;
        }
        n3 <<= 14;
        if (((n3 |= SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, ++n5 + n2)) & 0x80) == 0) {
            n6 &= 0x1FC07F;
            nArray[0] = (n6 <<= 7) | (n3 &= 0x1FC07F);
            return 4;
        }
        n6 <<= 14;
        if (((n6 |= SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, ++n5 + n2)) & 0x80) == 0) {
            n3 &= 0xF01FC07F;
            nArray[0] = (n6 &= 0xF01FC07F) | (n3 <<= 7);
            return 5;
        }
        long[] lArray = new long[1];
        n5 -= 4;
        byte by = SqlJetUtility.getVarint(iSqlJetMemoryPointer, n2, lArray);
        assert (by > 5 && by <= 9);
        nArray[0] = (int)lArray[0];
        return by;
    }

    public static int sqlite3VarintLen(long l2) {
        int n2 = 0;
        while ((l2 >>= 7) != 0L && ++n2 < 9) {
        }
        return n2;
    }

    public static final boolean mutex_held(ISqlJetMutex iSqlJetMutex) {
        return iSqlJetMutex == null || iSqlJetMutex.held();
    }

    public static int strlen30(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        int n2;
        int n3 = iSqlJetMemoryPointer.getPointer();
        for (n2 = 0; n2 < n3 && SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2) != 0; ++n2) {
        }
        return 0x3FFFFFFF & n2;
    }

    public static final int getUnsignedByte(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        return iSqlJetMemoryPointer.getByteUnsigned(n2);
    }

    public static final ISqlJetMemoryPointer putUnsignedByte(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, int n3) {
        iSqlJetMemoryPointer.putByteUnsigned(n2, n3);
        return iSqlJetMemoryPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = iSqlJetMemoryPointer;
        synchronized (iSqlJetMemoryPointer2) {
            byte[] byArray = new byte[iSqlJetMemoryPointer.remaining()];
            iSqlJetMemoryPointer.getBytes(byArray);
            return new String(byArray);
        }
    }

    public static String toString(ISqlJetMemoryPointer iSqlJetMemoryPointer, SqlJetEncoding sqlJetEncoding) {
        if (iSqlJetMemoryPointer == null) {
            return null;
        }
        if (sqlJetEncoding == null) {
            return null;
        }
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = iSqlJetMemoryPointer;
        synchronized (iSqlJetMemoryPointer2) {
            byte[] byArray = new byte[iSqlJetMemoryPointer.remaining()];
            iSqlJetMemoryPointer.getBytes(byArray);
            try {
                String string = new String(byArray, sqlJetEncoding.getCharsetName());
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    if (string.charAt(i2) != '\u0000') continue;
                    return string.substring(0, i2);
                }
                return string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Unknown charset " + sqlJetEncoding.name());
            }
        }
    }

    public static ISqlJetMemoryPointer fromString(String string, SqlJetEncoding sqlJetEncoding) {
        try {
            return SqlJetUtility.wrapPtr(string.getBytes(sqlJetEncoding.getCharsetName()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Unknown charset " + sqlJetEncoding.name());
        }
    }

    public static ISqlJetMemoryPointer translate(ISqlJetMemoryPointer iSqlJetMemoryPointer, SqlJetEncoding sqlJetEncoding, SqlJetEncoding sqlJetEncoding2) {
        return SqlJetUtility.fromString(SqlJetUtility.toString(iSqlJetMemoryPointer, sqlJetEncoding), sqlJetEncoding2);
    }

    public static final String trim(String string) {
        return null != string ? string.trim() : null;
    }

    public static int varintLen(long l2) {
        int n2 = 0;
        while ((l2 >>= 7) != 0L && ++n2 < 9) {
        }
        return n2;
    }

    public static final short toUnsigned(byte by) {
        return (short)(by & 0xFF);
    }

    public static final byte fromUnsigned(short s2) {
        return (byte)(s2 & 0xFF);
    }

    public static final int toUnsigned(short s2) {
        return s2 & 0xFFFF;
    }

    public static final short fromUnsigned(int n2) {
        return (short)(n2 & 0xFFFF);
    }

    public static long toUnsigned(int n2) {
        return (long)n2 & 0xFFFFFFFFL;
    }

    public static final int fromUnsigned(long l2) {
        return (int)(l2 & 0xFFFFFFFFL);
    }

    public static final long get4byteUnsigned(byte[] byArray) {
        return SqlJetUtility.get4byteUnsigned(SqlJetUtility.wrapPtr(byArray));
    }

    public static final long get4byteUnsigned(byte[] byArray, int n2) {
        return SqlJetUtility.get4byteUnsigned(SqlJetUtility.wrapPtr(byArray));
    }

    public static final ISqlJetMemoryPointer put4byteUnsigned(long l2) {
        SqlJetUtility.logSigned(l2);
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(4);
        iSqlJetMemoryPointer.putIntUnsigned(l2);
        return iSqlJetMemoryPointer;
    }

    public static final void put4byteUnsigned(byte[] byArray, int n2, long l2) {
        SqlJetUtility.put4byteUnsigned(SqlJetUtility.wrapPtr(byArray), n2, l2);
    }

    public static final long get4byteUnsigned(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        return iSqlJetMemoryPointer.getIntUnsigned();
    }

    public static final long get4byteUnsigned(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        return iSqlJetMemoryPointer.getIntUnsigned(n2);
    }

    public static final void put4byteUnsigned(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, long l2) {
        iSqlJetMemoryPointer.putIntUnsigned(n2, l2);
    }

    public static final void put4byteUnsigned(ISqlJetMemoryPointer iSqlJetMemoryPointer, long l2) {
        iSqlJetMemoryPointer.putIntUnsigned(l2);
    }

    public static final void memmove(ISqlJetMemoryPointer iSqlJetMemoryPointer, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n2) {
        SqlJetUtility.memmove(iSqlJetMemoryPointer, 0, iSqlJetMemoryPointer2, 0, n2);
    }

    public static final void memmove(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n3, int n4) {
        byte[] byArray = new byte[n4];
        iSqlJetMemoryPointer2.getBytes(n3, byArray, n4);
        iSqlJetMemoryPointer.putBytes(n2, byArray, n4);
    }

    public static final double atof(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        String string = SqlJetUtility.toString(iSqlJetMemoryPointer);
        return Double.valueOf(string);
    }

    public static final Long atoi64(String string) {
        return Long.valueOf(string);
    }

    public static final long absolute(long l2) {
        long l3;
        long l4 = l3 = l2 < 0L ? -l2 : l2;
        if (l3 == Integer.MIN_VALUE || l3 == Long.MIN_VALUE) {
            --l3;
        }
        return l3;
    }

    public static final Object[] addArrays(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    public static final Object[] insertArray(Object[] objectArray, Object[] objectArray2, int n2) {
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, n2);
        System.arraycopy(objectArray2, 0, objectArray3, n2, objectArray2.length);
        System.arraycopy(objectArray, n2, objectArray3, objectArray2.length + n2, objectArray.length - n2);
        return objectArray3;
    }

    public static final EnumSet of(Enum enum_, Enum ... enumArray) {
        return EnumSet.of(enum_, enumArray);
    }

    public static final EnumSet of(Enum enum_) {
        return EnumSet.of(enum_);
    }

    public static final EnumSet of(Enum enum_, Enum enum_2) {
        return EnumSet.of(enum_, enum_2);
    }

    public static final EnumSet of(Enum enum_, Enum enum_2, Enum enum_3) {
        return EnumSet.of(enum_, enum_2, enum_3);
    }

    public static final EnumSet noneOf(Class clazz) {
        return EnumSet.noneOf(clazz);
    }

    public static final Object[] adjustNumberTypes(Object[] objectArray) {
        if (null == objectArray) {
            return null;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = SqlJetUtility.adjustNumberType(objectArray[i2]);
        }
        return objectArray;
    }

    public static final SqlJetScope adjustScopeNumberTypes(SqlJetScope sqlJetScope) {
        if (null == sqlJetScope) {
            return null;
        }
        SqlJetScope$SqlJetScopeBound sqlJetScope$SqlJetScopeBound = sqlJetScope.getLeftBound();
        SqlJetScope$SqlJetScopeBound sqlJetScope$SqlJetScopeBound2 = sqlJetScope.getRightBound();
        if (sqlJetScope$SqlJetScopeBound != null) {
            sqlJetScope$SqlJetScopeBound = new SqlJetScope$SqlJetScopeBound(SqlJetUtility.adjustNumberTypes(sqlJetScope$SqlJetScopeBound.getValue()), sqlJetScope$SqlJetScopeBound.isInclusive());
        }
        if (sqlJetScope$SqlJetScopeBound2 != null) {
            sqlJetScope$SqlJetScopeBound2 = new SqlJetScope$SqlJetScopeBound(SqlJetUtility.adjustNumberTypes(sqlJetScope$SqlJetScopeBound2.getValue()), sqlJetScope$SqlJetScopeBound2.isInclusive());
        }
        return new SqlJetScope(sqlJetScope$SqlJetScopeBound, sqlJetScope$SqlJetScopeBound2);
    }

    public static final Object adjustNumberType(Object object) {
        if (null == object) {
            return null;
        }
        if (object instanceof Number) {
            if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
                return ((Number)object).longValue();
            }
            if (object instanceof Float) {
                return Double.parseDouble(Float.toString(((Float)object).floatValue()));
            }
        }
        return object;
    }

    public static ISqlJetMemoryPointer streamToBuffer(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            inputStream.reset();
            return SqlJetUtility.wrapPtr(byArray);
        }
        catch (IOException iOException) {
            throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)iOException);
        }
    }

    public static byte[] readByteBuffer(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        if (iSqlJetMemoryPointer == null) {
            return null;
        }
        byte[] byArray = new byte[iSqlJetMemoryPointer.remaining()];
        iSqlJetMemoryPointer.getBytes(byArray);
        return byArray;
    }

    public static Object[] copyArray(Object[] objectArray) {
        if (null == objectArray) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static boolean isNumber(String string, boolean[] blArray) {
        if (string == null) {
            return false;
        }
        if (!NUMBER_PATTER.matcher(string).matches()) {
            return false;
        }
        if (blArray != null && blArray.length > 0) {
            blArray[0] = REAL_PATTERN.matcher(string).matches();
        }
        return true;
    }

    public static Long doubleToInt64(Double d2) {
        double d3;
        if (d2 == null) {
            return null;
        }
        if (d2 == Double.NaN) {
            return null;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return null;
        }
        double d4 = d2;
        if (d4 != (d3 = Math.rint(d4))) {
            return null;
        }
        return d2.longValue();
    }

    public static ISqlJetMemoryPointer fromByteBuffer(ByteBuffer byteBuffer) {
        return new SqlJetByteBuffer(byteBuffer).getPointer(0);
    }

    public static ISqlJetMemoryPointer getMoved(ISqlJetMemoryPointer iSqlJetMemoryPointer, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n2) {
        if (iSqlJetMemoryPointer2.getPointer() + n2 >= 0) {
            return iSqlJetMemoryPointer2.getMoved(n2);
        }
        assert (iSqlJetMemoryPointer != null);
        int n3 = -(iSqlJetMemoryPointer2.getPointer() + n2);
        int n4 = iSqlJetMemoryPointer2.getLimit() - iSqlJetMemoryPointer2.getPointer();
        int n5 = iSqlJetMemoryPointer.getLimit() - iSqlJetMemoryPointer.getPointer();
        ISqlJetMemoryPointer iSqlJetMemoryPointer3 = SqlJetUtility.allocatePtr(n4 + n3);
        iSqlJetMemoryPointer3.copyFrom(0, iSqlJetMemoryPointer, n5 - n3, n3);
        iSqlJetMemoryPointer3.copyFrom(n3, iSqlJetMemoryPointer2, 0, n4);
        return iSqlJetMemoryPointer3;
    }
}

