/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.logging.AbstractLoggerProvider;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.jboss.logging.Slf4jLocationAwareLogger;
import org.jboss.logging.Slf4jLogger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.LocationAwareLogger;

public final class Slf4jLoggerProvider
extends AbstractLoggerProvider
implements LoggerProvider {
    @Override
    public Logger getLogger(String string) {
        org.slf4j.Logger logger = LoggerFactory.getLogger((String)string);
        if (logger instanceof LocationAwareLogger) {
            return new Slf4jLocationAwareLogger(string, (LocationAwareLogger)logger);
        }
        return new Slf4jLogger(string, logger);
    }

    @Override
    public void clearMdc() {
        MDC.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putMdc(String string, Object object) {
        try {
            String string2 = MDC.get((String)string);
            return string2;
        }
        finally {
            if (object == null) {
                MDC.remove((String)string);
            } else {
                MDC.put((String)string, (String)String.valueOf(object));
            }
        }
    }

    @Override
    public Object getMdc(String string) {
        return MDC.get((String)string);
    }

    @Override
    public void removeMdc(String string) {
        MDC.remove((String)string);
    }

    @Override
    public Map getMdcMap() {
        Map map = MDC.getCopyOfContextMap();
        return map == null ? Collections.emptyMap() : new LinkedHashMap(map);
    }
}

