/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.text.MessageFormat;
import org.jboss.logging.Logger;
import org.jboss.logging.Logger$Level;

final class Slf4jLogger
extends Logger {
    private static final long serialVersionUID = 8685757928087758380L;
    private final org.slf4j.Logger logger;

    Slf4jLogger(String string, org.slf4j.Logger logger) {
        super(string);
        this.logger = logger;
    }

    @Override
    public boolean isEnabled(Logger$Level logger$Level) {
        if (logger$Level == Logger$Level.TRACE) {
            return this.logger.isTraceEnabled();
        }
        if (logger$Level == Logger$Level.DEBUG) {
            return this.logger.isDebugEnabled();
        }
        return this.infoOrHigherEnabled(logger$Level);
    }

    private boolean infoOrHigherEnabled(Logger$Level logger$Level) {
        if (logger$Level == Logger$Level.INFO) {
            return this.logger.isInfoEnabled();
        }
        if (logger$Level == Logger$Level.WARN) {
            return this.logger.isWarnEnabled();
        }
        if (logger$Level == Logger$Level.ERROR || logger$Level == Logger$Level.FATAL) {
            return this.logger.isErrorEnabled();
        }
        return true;
    }

    @Override
    protected void doLog(Logger$Level logger$Level, String string, Object object, Object[] objectArray, Throwable throwable) {
        if (this.isEnabled(logger$Level)) {
            try {
                String string2;
                String string3 = string2 = objectArray == null || objectArray.length == 0 ? String.valueOf(object) : MessageFormat.format(String.valueOf(object), objectArray);
                if (logger$Level == Logger$Level.INFO) {
                    this.logger.info(string2, throwable);
                } else if (logger$Level == Logger$Level.WARN) {
                    this.logger.warn(string2, throwable);
                } else if (logger$Level == Logger$Level.ERROR || logger$Level == Logger$Level.FATAL) {
                    this.logger.error(string2, throwable);
                } else if (logger$Level == Logger$Level.DEBUG) {
                    this.logger.debug(string2, throwable);
                } else if (logger$Level == Logger$Level.TRACE) {
                    this.logger.debug(string2, throwable);
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doLogf(Logger$Level logger$Level, String string, String string2, Object[] objectArray, Throwable throwable) {
        if (this.isEnabled(logger$Level)) {
            try {
                String string3;
                String string4 = string3 = objectArray == null ? String.format(string2, new Object[0]) : String.format(string2, objectArray);
                if (logger$Level == Logger$Level.INFO) {
                    this.logger.info(string3, throwable);
                } else if (logger$Level == Logger$Level.WARN) {
                    this.logger.warn(string3, throwable);
                } else if (logger$Level == Logger$Level.ERROR || logger$Level == Logger$Level.FATAL) {
                    this.logger.error(string3, throwable);
                } else if (logger$Level == Logger$Level.DEBUG) {
                    this.logger.debug(string3, throwable);
                } else if (logger$Level == Logger$Level.TRACE) {
                    this.logger.debug(string3, throwable);
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }
}

