/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.MessageFormat;
import org.jboss.logging.Logger;
import org.jboss.logging.Logger$Level;
import org.slf4j.spi.LocationAwareLogger;

final class Slf4jLocationAwareLogger
extends Logger {
    private static final long serialVersionUID = 8685757928087758380L;
    private static final Object[] EMPTY = new Object[0];
    private static final boolean POST_1_6;
    private static final Method LOG_METHOD;
    private final LocationAwareLogger logger;

    Slf4jLocationAwareLogger(String string, LocationAwareLogger locationAwareLogger) {
        super(string);
        this.logger = locationAwareLogger;
    }

    @Override
    public boolean isEnabled(Logger$Level logger$Level) {
        if (logger$Level != null) {
            switch (logger$Level) {
                case FATAL: {
                    return this.logger.isErrorEnabled();
                }
                case ERROR: {
                    return this.logger.isErrorEnabled();
                }
                case WARN: {
                    return this.logger.isWarnEnabled();
                }
                case INFO: {
                    return this.logger.isInfoEnabled();
                }
                case DEBUG: {
                    return this.logger.isDebugEnabled();
                }
                case TRACE: {
                    return this.logger.isTraceEnabled();
                }
            }
        }
        return true;
    }

    @Override
    protected void doLog(Logger$Level logger$Level, String string, Object object, Object[] objectArray, Throwable throwable) {
        if (this.isEnabled(logger$Level)) {
            String string2 = objectArray == null || objectArray.length == 0 ? String.valueOf(object) : MessageFormat.format(String.valueOf(object), objectArray);
            Slf4jLocationAwareLogger.doLog(this.logger, string, Slf4jLocationAwareLogger.translate(logger$Level), string2, throwable);
        }
    }

    @Override
    protected void doLogf(Logger$Level logger$Level, String string, String string2, Object[] objectArray, Throwable throwable) {
        if (this.isEnabled(logger$Level)) {
            String string3 = objectArray == null ? String.format(string2, new Object[0]) : String.format(string2, objectArray);
            Slf4jLocationAwareLogger.doLog(this.logger, string, Slf4jLocationAwareLogger.translate(logger$Level), string3, throwable);
        }
    }

    private static void doLog(LocationAwareLogger locationAwareLogger, String string, int n2, String string2, Throwable throwable) {
        try {
            if (POST_1_6) {
                LOG_METHOD.invoke((Object)locationAwareLogger, null, string, n2, string2, EMPTY, throwable);
            } else {
                LOG_METHOD.invoke((Object)locationAwareLogger, null, string, n2, string2, throwable);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                throw invocationTargetException.getCause();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable2) {
                throw new UndeclaredThrowableException(throwable2);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    private static int translate(Logger$Level logger$Level) {
        if (logger$Level != null) {
            switch (logger$Level) {
                case FATAL: 
                case ERROR: {
                    return 40;
                }
                case WARN: {
                    return 30;
                }
                case INFO: {
                    return 20;
                }
                case DEBUG: {
                    return 10;
                }
                case TRACE: {
                    return 0;
                }
            }
        }
        return 0;
    }

    static {
        Method[] methodArray = LocationAwareLogger.class.getDeclaredMethods();
        Method method = null;
        boolean bl2 = false;
        for (Method method2 : methodArray) {
            if (!method2.getName().equals("log")) continue;
            method = method2;
            Class<?>[] classArray = method2.getParameterTypes();
            bl2 = classArray.length == 6;
        }
        if (method == null) {
            throw new NoSuchMethodError("Cannot find LocationAwareLogger.log() method");
        }
        POST_1_6 = bl2;
        LOG_METHOD = method;
    }
}

