/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.Locale;
import org.jboss.logging.SecurityActions;

class LoggingLocale {
    private static final Locale LOCALE = LoggingLocale.getDefaultLocale();

    LoggingLocale() {
    }

    static Locale getLocale() {
        return LOCALE;
    }

    private static Locale getDefaultLocale() {
        String string = SecurityActions.getSystemProperty("org.jboss.logging.locale", "");
        if (string.trim().isEmpty()) {
            return Locale.getDefault();
        }
        return LoggingLocale.forLanguageTag(string);
    }

    private static Locale forLanguageTag(String string) {
        if ("en-CA".equalsIgnoreCase(string)) {
            return Locale.CANADA;
        }
        if ("fr-CA".equalsIgnoreCase(string)) {
            return Locale.CANADA_FRENCH;
        }
        if ("zh".equalsIgnoreCase(string)) {
            return Locale.CHINESE;
        }
        if ("en".equalsIgnoreCase(string)) {
            return Locale.ENGLISH;
        }
        if ("fr-FR".equalsIgnoreCase(string)) {
            return Locale.FRANCE;
        }
        if ("fr".equalsIgnoreCase(string)) {
            return Locale.FRENCH;
        }
        if ("de".equalsIgnoreCase(string)) {
            return Locale.GERMAN;
        }
        if ("de-DE".equalsIgnoreCase(string)) {
            return Locale.GERMANY;
        }
        if ("it".equalsIgnoreCase(string)) {
            return Locale.ITALIAN;
        }
        if ("it-IT".equalsIgnoreCase(string)) {
            return Locale.ITALY;
        }
        if ("ja-JP".equalsIgnoreCase(string)) {
            return Locale.JAPAN;
        }
        if ("ja".equalsIgnoreCase(string)) {
            return Locale.JAPANESE;
        }
        if ("ko-KR".equalsIgnoreCase(string)) {
            return Locale.KOREA;
        }
        if ("ko".equalsIgnoreCase(string)) {
            return Locale.KOREAN;
        }
        if ("zh-CN".equalsIgnoreCase(string)) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        if ("zh-TW".equalsIgnoreCase(string)) {
            return Locale.TRADITIONAL_CHINESE;
        }
        if ("en-UK".equalsIgnoreCase(string)) {
            return Locale.UK;
        }
        if ("en-US".equalsIgnoreCase(string)) {
            return Locale.US;
        }
        String[] stringArray = string.split("-");
        int n2 = stringArray.length;
        int n3 = 0;
        int n4 = 0;
        String string2 = stringArray[n3++];
        String string3 = "";
        String string4 = "";
        while (n3 < n2 && n4++ != 2 && LoggingLocale.isAlpha(stringArray[n3], 3, 3)) {
            ++n3;
        }
        if (n3 != n2 && LoggingLocale.isAlpha(stringArray[n3], 4, 4)) {
            ++n3;
        }
        if (n3 != n2 && (LoggingLocale.isAlpha(stringArray[n3], 2, 2) || LoggingLocale.isNumeric(stringArray[n3], 3, 3))) {
            string3 = stringArray[n3++];
        }
        if (n3 != n2 && LoggingLocale.isAlphaOrNumeric(stringArray[n3], 5, 8)) {
            string4 = stringArray[n3];
        }
        return new Locale(string2, string3, string4);
    }

    private static boolean isAlpha(String string, int n2, int n3) {
        int n4 = string.length();
        if (n4 < n2 || n4 > n3) {
            return false;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            if (Character.isLetter(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumeric(String string, int n2, int n3) {
        int n4 = string.length();
        if (n4 < n2 || n4 > n3) {
            return false;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            if (Character.isDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlphaOrNumeric(String string, int n2, int n3) {
        int n4 = string.length();
        if (n4 < n2 || n4 > n3) {
            return false;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            if (Character.isLetterOrDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }
}

