/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.LogManager;
import org.jboss.logging.JBossLogManagerProvider;
import org.jboss.logging.JDKLoggerProvider;
import org.jboss.logging.Log4j2LoggerProvider;
import org.jboss.logging.Log4jLoggerProvider;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.jboss.logging.SecurityActions;
import org.jboss.logging.Slf4jLoggerProvider;

final class LoggerProviders {
    static final String LOGGING_PROVIDER_KEY = "org.jboss.logging.provider";
    static final LoggerProvider PROVIDER = LoggerProviders.find();

    private static LoggerProvider find() {
        return LoggerProviders.findProvider();
    }

    private static LoggerProvider findProvider() {
        Object object;
        ClassLoader classLoader = LoggerProviders.class.getClassLoader();
        try {
            object = SecurityActions.getSystemProperty(LOGGING_PROVIDER_KEY);
            if (object != null) {
                if ("jboss".equalsIgnoreCase((String)object)) {
                    return LoggerProviders.tryJBossLogManager(classLoader, "system property");
                }
                if ("jdk".equalsIgnoreCase((String)object)) {
                    return LoggerProviders.tryJDK("system property");
                }
                if ("log4j2".equalsIgnoreCase((String)object)) {
                    return LoggerProviders.tryLog4j2(classLoader, "system property");
                }
                if ("log4j".equalsIgnoreCase((String)object)) {
                    return LoggerProviders.tryLog4j(classLoader, "system property");
                }
                if ("slf4j".equalsIgnoreCase((String)object)) {
                    return LoggerProviders.trySlf4j("system property");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            object = ServiceLoader.load(LoggerProvider.class, classLoader);
            Iterator iterator = ((ServiceLoader)object).iterator();
            while (true) {
                try {
                    if (iterator.hasNext()) {
                        LoggerProvider loggerProvider = (LoggerProvider)iterator.next();
                        LoggerProviders.logProvider(loggerProvider, "service loader");
                        return loggerProvider;
                    }
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            return LoggerProviders.tryJBossLogManager(classLoader, null);
        }
        catch (Throwable throwable) {
            try {
                return LoggerProviders.tryLog4j2(classLoader, null);
            }
            catch (Throwable throwable2) {
                try {
                    Class.forName("ch.qos.logback.classic.Logger", false, classLoader);
                    return LoggerProviders.trySlf4j(null);
                }
                catch (Throwable throwable3) {
                    try {
                        return LoggerProviders.tryLog4j(classLoader, null);
                    }
                    catch (Throwable throwable4) {
                        return LoggerProviders.tryJDK(null);
                    }
                }
            }
        }
    }

    private static JDKLoggerProvider tryJDK(String string) {
        JDKLoggerProvider jDKLoggerProvider = new JDKLoggerProvider();
        LoggerProviders.logProvider(jDKLoggerProvider, string);
        return jDKLoggerProvider;
    }

    private static LoggerProvider trySlf4j(String string) {
        Slf4jLoggerProvider slf4jLoggerProvider = new Slf4jLoggerProvider();
        LoggerProviders.logProvider(slf4jLoggerProvider, string);
        return slf4jLoggerProvider;
    }

    private static LoggerProvider tryLog4j2(ClassLoader classLoader, String string) {
        Class.forName("org.apache.logging.log4j.Logger", true, classLoader);
        Class.forName("org.apache.logging.log4j.LogManager", true, classLoader);
        Class.forName("org.apache.logging.log4j.spi.AbstractLogger", true, classLoader);
        Log4j2LoggerProvider log4j2LoggerProvider = new Log4j2LoggerProvider();
        LoggerProviders.logProvider(log4j2LoggerProvider, string);
        return log4j2LoggerProvider;
    }

    private static LoggerProvider tryLog4j(ClassLoader classLoader, String string) {
        Class.forName("org.apache.log4j.LogManager", true, classLoader);
        Class.forName("org.apache.log4j.config.PropertySetter", true, classLoader);
        Log4jLoggerProvider log4jLoggerProvider = new Log4jLoggerProvider();
        LoggerProviders.logProvider(log4jLoggerProvider, string);
        return log4jLoggerProvider;
    }

    private static LoggerProvider tryJBossLogManager(ClassLoader classLoader, String string) {
        Class<?> clazz;
        Class<?> clazz2 = LogManager.getLogManager().getClass();
        if (clazz2 == (clazz = Class.forName("org.jboss.logmanager.LogManager", false, Logger.class.getClassLoader())) && Class.forName("org.jboss.logmanager.Logger$AttachmentKey", true, classLoader).getClassLoader() == clazz2.getClassLoader()) {
            Module module = LoggerProviders.class.getModule();
            if (module.isNamed()) {
                module.addReads(clazz.getModule());
            }
            JBossLogManagerProvider jBossLogManagerProvider = new JBossLogManagerProvider();
            LoggerProviders.logProvider(jBossLogManagerProvider, string);
            return jBossLogManagerProvider;
        }
        throw new IllegalStateException();
    }

    private static void logProvider(LoggerProvider loggerProvider, String string) {
        Logger logger = loggerProvider.getLogger("org.jboss.logging");
        if (string == null) {
            logger.debugf("Logging Provider: %s", (Object)loggerProvider.getClass().getName());
        } else {
            logger.debugf("Logging Provider: %s found via %s", (Object)loggerProvider.getClass().getName(), (Object)string);
        }
    }

    private LoggerProviders() {
    }
}

