/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.text.MessageFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jboss.logging.Logger;
import org.jboss.logging.Logger$Level;

final class Log4jLogger
extends Logger {
    private static final long serialVersionUID = -5446154366955151335L;
    private final org.apache.log4j.Logger logger;

    Log4jLogger(String string) {
        super(string);
        this.logger = org.apache.log4j.Logger.getLogger((String)string);
    }

    @Override
    public boolean isEnabled(Logger$Level logger$Level) {
        Level level = Log4jLogger.translate(logger$Level);
        return this.logger.isEnabledFor((Priority)level) && level.isGreaterOrEqual((Priority)this.logger.getEffectiveLevel());
    }

    @Override
    protected void doLog(Logger$Level logger$Level, String string, Object object, Object[] objectArray, Throwable throwable) {
        Level level = Log4jLogger.translate(logger$Level);
        if (this.logger.isEnabledFor((Priority)level)) {
            try {
                this.logger.log(string, (Priority)level, objectArray == null || objectArray.length == 0 ? object : MessageFormat.format(String.valueOf(object), objectArray), throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doLogf(Logger$Level logger$Level, String string, String string2, Object[] objectArray, Throwable throwable) {
        Level level = Log4jLogger.translate(logger$Level);
        if (this.logger.isEnabledFor((Priority)level)) {
            try {
                this.logger.log(string, (Priority)level, (Object)(objectArray == null ? String.format(string2, new Object[0]) : String.format(string2, objectArray)), throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    private static Level translate(Logger$Level logger$Level) {
        if (logger$Level == Logger$Level.TRACE) {
            return Level.TRACE;
        }
        if (logger$Level == Logger$Level.DEBUG) {
            return Level.DEBUG;
        }
        return Log4jLogger.infoOrHigher(logger$Level);
    }

    private static Level infoOrHigher(Logger$Level logger$Level) {
        if (logger$Level == Logger$Level.INFO) {
            return Level.INFO;
        }
        if (logger$Level == Logger$Level.WARN) {
            return Level.WARN;
        }
        if (logger$Level == Logger$Level.ERROR) {
            return Level.ERROR;
        }
        if (logger$Level == Logger$Level.FATAL) {
            return Level.FATAL;
        }
        return Level.ALL;
    }
}

