/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFormatMessageFactory;
import org.apache.logging.log4j.message.StringFormattedMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.Logger$Level;

final class Log4j2Logger
extends Logger {
    private static final long serialVersionUID = -2507841068232627725L;
    private final AbstractLogger logger;
    private final MessageFormatMessageFactory messageFactory;

    Log4j2Logger(String string) {
        super(string);
        org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)string);
        if (!(logger instanceof AbstractLogger)) {
            throw new LoggingException("The logger for [" + string + "] does not extend AbstractLogger. Actual logger: " + logger.getClass().getName());
        }
        this.logger = (AbstractLogger)logger;
        this.messageFactory = new MessageFormatMessageFactory();
    }

    @Override
    public boolean isEnabled(Logger$Level logger$Level) {
        return this.logger.isEnabled(Log4j2Logger.translate(logger$Level));
    }

    @Override
    protected void doLog(Logger$Level logger$Level, String string, Object object, Object[] objectArray, Throwable throwable) {
        Level level = Log4j2Logger.translate(logger$Level);
        if (this.logger.isEnabled(level)) {
            try {
                this.logger.logMessage(string, level, null, objectArray == null || objectArray.length == 0 ? this.messageFactory.newMessage(String.valueOf(object)) : this.messageFactory.newMessage(String.valueOf(object), objectArray), throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doLogf(Logger$Level logger$Level, String string, String string2, Object[] objectArray, Throwable throwable) {
        Level level = Log4j2Logger.translate(logger$Level);
        if (this.logger.isEnabled(level)) {
            try {
                this.logger.logMessage(string, level, null, (Message)new StringFormattedMessage(string2, objectArray), throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    private static Level translate(Logger$Level logger$Level) {
        if (logger$Level == Logger$Level.TRACE) {
            return Level.TRACE;
        }
        if (logger$Level == Logger$Level.DEBUG) {
            return Level.DEBUG;
        }
        return Log4j2Logger.infoOrHigher(logger$Level);
    }

    private static Level infoOrHigher(Logger$Level logger$Level) {
        if (logger$Level == Logger$Level.INFO) {
            return Level.INFO;
        }
        if (logger$Level == Logger$Level.WARN) {
            return Level.WARN;
        }
        if (logger$Level == Logger$Level.ERROR) {
            return Level.ERROR;
        }
        if (logger$Level == Logger$Level.FATAL) {
            return Level.FATAL;
        }
        return Level.ALL;
    }
}

