/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.jboss.logging.JBossLogRecord;
import org.jboss.logging.JDKLevel;
import org.jboss.logging.Logger;
import org.jboss.logging.Logger$Level;

final class JDKLogger
extends Logger {
    private static final long serialVersionUID = 2563174097983721393L;
    private final transient java.util.logging.Logger logger;

    public JDKLogger(String string) {
        super(string);
        this.logger = java.util.logging.Logger.getLogger(string);
    }

    @Override
    protected void doLog(Logger$Level logger$Level, String string, Object object, Object[] objectArray, Throwable throwable) {
        if (this.isEnabled(logger$Level)) {
            try {
                JBossLogRecord jBossLogRecord = new JBossLogRecord(JDKLogger.translate(logger$Level), String.valueOf(object), string);
                if (throwable != null) {
                    jBossLogRecord.setThrown(throwable);
                }
                jBossLogRecord.setLoggerName(this.getName());
                jBossLogRecord.setParameters(objectArray);
                jBossLogRecord.setResourceBundleName(this.logger.getResourceBundleName());
                jBossLogRecord.setResourceBundle(this.logger.getResourceBundle());
                this.logger.log(jBossLogRecord);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doLogf(Logger$Level logger$Level, String string, String string2, Object[] objectArray, Throwable throwable) {
        if (this.isEnabled(logger$Level)) {
            try {
                ResourceBundle resourceBundle = this.logger.getResourceBundle();
                if (resourceBundle != null) {
                    try {
                        string2 = resourceBundle.getString(string2);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                String string3 = objectArray == null ? String.format(string2, new Object[0]) : String.format(string2, objectArray);
                JBossLogRecord jBossLogRecord = new JBossLogRecord(JDKLogger.translate(logger$Level), string3, string);
                if (throwable != null) {
                    jBossLogRecord.setThrown(throwable);
                }
                jBossLogRecord.setLoggerName(this.getName());
                jBossLogRecord.setResourceBundleName(this.logger.getResourceBundleName());
                jBossLogRecord.setResourceBundle(null);
                jBossLogRecord.setParameters(null);
                this.logger.log(jBossLogRecord);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    private static Level translate(Logger$Level logger$Level) {
        if (logger$Level == Logger$Level.TRACE) {
            return JDKLevel.TRACE;
        }
        if (logger$Level == Logger$Level.DEBUG) {
            return JDKLevel.DEBUG;
        }
        return JDKLogger.infoOrHigher(logger$Level);
    }

    private static Level infoOrHigher(Logger$Level logger$Level) {
        if (logger$Level == Logger$Level.INFO) {
            return JDKLevel.INFO;
        }
        if (logger$Level == Logger$Level.WARN) {
            return JDKLevel.WARN;
        }
        if (logger$Level == Logger$Level.ERROR) {
            return JDKLevel.ERROR;
        }
        if (logger$Level == Logger$Level.FATAL) {
            return JDKLevel.FATAL;
        }
        return JDKLevel.ALL;
    }

    @Override
    public boolean isEnabled(Logger$Level logger$Level) {
        return this.logger.isLoggable(JDKLogger.translate(logger$Level));
    }
}

