/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logging.Logger;

class JBossLogRecord
extends LogRecord {
    private static final long serialVersionUID = 2492784413065296060L;
    private static final String LOGGER_CLASS_NAME = Logger.class.getName();
    private boolean resolved;
    private final String loggerClassName;

    JBossLogRecord(Level level, String string) {
        super(level, string);
        this.loggerClassName = LOGGER_CLASS_NAME;
    }

    JBossLogRecord(Level level, String string, String string2) {
        super(level, string);
        this.loggerClassName = string2;
    }

    @Override
    public String getSourceClassName() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceClassName();
    }

    @Override
    public void setSourceClassName(String string) {
        this.resolved = true;
        super.setSourceClassName(string);
    }

    @Override
    public String getSourceMethodName() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceMethodName(String string) {
        this.resolved = true;
        super.setSourceMethodName(string);
    }

    private void resolve() {
        this.resolved = true;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        boolean bl2 = false;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string = stackTraceElement.getClassName();
            if (bl2) {
                if (this.loggerClassName.equals(string)) continue;
                this.setSourceClassName(string);
                this.setSourceMethodName(stackTraceElement.getMethodName());
                return;
            }
            bl2 = this.loggerClassName.equals(string);
        }
        this.setSourceClassName("<unknown>");
        this.setSourceMethodName("<unknown>");
    }

    protected Object writeReplace() {
        LogRecord logRecord = new LogRecord(this.getLevel(), this.getMessage());
        logRecord.setResourceBundle(this.getResourceBundle());
        logRecord.setLoggerName(this.getLoggerName());
        logRecord.setMillis(this.getMillis());
        logRecord.setParameters(this.getParameters());
        logRecord.setResourceBundleName(this.getResourceBundleName());
        logRecord.setSequenceNumber(this.getSequenceNumber());
        logRecord.setSourceClassName(this.getSourceClassName());
        logRecord.setSourceMethodName(this.getSourceMethodName());
        logRecord.setThreadID(this.getThreadID());
        logRecord.setThrown(this.getThrown());
        return logRecord;
    }
}

