/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logging.JBossLogManagerLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.MDC;
import org.jboss.logmanager.NDC;

public final class JBossLogManagerProvider
implements LoggerProvider {
    private static final Logger.AttachmentKey KEY = new Logger.AttachmentKey();
    private static final Logger.AttachmentKey LEGACY_KEY = new Logger.AttachmentKey();

    @Override
    public Logger getLogger(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            return AccessController.doPrivileged(() -> {
                try {
                    return JBossLogManagerProvider.doGetLogger(string);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return JBossLogManagerProvider.doLegacyGetLogger(string);
                }
            });
        }
        try {
            return JBossLogManagerProvider.doGetLogger(string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return JBossLogManagerProvider.doLegacyGetLogger(string);
        }
    }

    private static Logger doLegacyGetLogger(String string) {
        Object object;
        org.jboss.logmanager.Logger logger = LogContext.getLogContext().getLogger("");
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)logger.getAttachment(LEGACY_KEY);
        if (concurrentHashMap == null && (object = (ConcurrentMap)logger.attachIfAbsent(LEGACY_KEY, concurrentHashMap = new ConcurrentHashMap())) != null) {
            concurrentHashMap = object;
        }
        if ((object = (Logger)concurrentHashMap.get(string)) != null) {
            return object;
        }
        org.jboss.logmanager.Logger logger2 = org.jboss.logmanager.Logger.getLogger((String)string);
        object = new JBossLogManagerLogger(string, logger2);
        Logger logger3 = (Logger)concurrentHashMap.putIfAbsent(string, object);
        if (logger3 == null) {
            return object;
        }
        return logger3;
    }

    private static Logger doGetLogger(String string) {
        Logger logger = (Logger)LogContext.getLogContext().getAttachment(string, KEY);
        if (logger != null) {
            return logger;
        }
        org.jboss.logmanager.Logger logger2 = org.jboss.logmanager.Logger.getLogger((String)string);
        Logger logger3 = (Logger)logger2.attachIfAbsent(KEY, (Object)(logger = new JBossLogManagerLogger(string, logger2)));
        if (logger3 == null) {
            return logger;
        }
        return logger3;
    }

    @Override
    public void clearMdc() {
        MDC.clear();
    }

    @Override
    public Object putMdc(String string, Object object) {
        return MDC.putObject((String)string, (Object)object);
    }

    @Override
    public Object getMdc(String string) {
        return MDC.getObject((String)string);
    }

    @Override
    public void removeMdc(String string) {
        MDC.removeObject((String)string);
    }

    @Override
    public Map getMdcMap() {
        return MDC.copyObject();
    }

    @Override
    public void clearNdc() {
        NDC.clear();
    }

    @Override
    public String getNdc() {
        return NDC.get();
    }

    @Override
    public int getNdcDepth() {
        return NDC.getDepth();
    }

    @Override
    public String popNdc() {
        return NDC.pop();
    }

    @Override
    public String peekNdc() {
        return NDC.get();
    }

    @Override
    public void pushNdc(String string) {
        NDC.push((String)string);
    }

    @Override
    public void setNdcMaxDepth(int n2) {
        NDC.trimTo((int)n2);
    }
}

