/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.Logger$Level;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;

final class JBossLogManagerLogger
extends Logger {
    private static final long serialVersionUID = 7429618317727584742L;
    private final org.jboss.logmanager.Logger logger;

    JBossLogManagerLogger(String string, org.jboss.logmanager.Logger logger) {
        super(string);
        this.logger = logger;
    }

    @Override
    public boolean isEnabled(Logger$Level logger$Level) {
        return this.logger.isLoggable(JBossLogManagerLogger.translate(logger$Level));
    }

    @Override
    protected void doLog(Logger$Level logger$Level, String string, Object object, Object[] objectArray, Throwable throwable) {
        java.util.logging.Level level = JBossLogManagerLogger.translate(logger$Level);
        if (this.logger.isLoggable(level)) {
            if (objectArray == null) {
                this.logger.log(string, level, String.valueOf(object), throwable);
            } else {
                this.logger.log(string, level, String.valueOf(object), ExtLogRecord.FormatStyle.MESSAGE_FORMAT, objectArray, throwable);
            }
        }
    }

    @Override
    protected void doLogf(Logger$Level logger$Level, String string, String string2, Object[] objectArray, Throwable throwable) {
        if (objectArray == null) {
            this.logger.log(string, JBossLogManagerLogger.translate(logger$Level), string2, throwable);
        } else {
            this.logger.log(string, JBossLogManagerLogger.translate(logger$Level), string2, ExtLogRecord.FormatStyle.PRINTF, objectArray, throwable);
        }
    }

    private static java.util.logging.Level translate(Logger$Level logger$Level) {
        if (logger$Level == Logger$Level.TRACE) {
            return Level.TRACE;
        }
        if (logger$Level == Logger$Level.DEBUG) {
            return Level.DEBUG;
        }
        return JBossLogManagerLogger.infoOrHigher(logger$Level);
    }

    private static java.util.logging.Level infoOrHigher(Logger$Level logger$Level) {
        if (logger$Level == Logger$Level.INFO) {
            return Level.INFO;
        }
        if (logger$Level == Logger$Level.WARN) {
            return Level.WARN;
        }
        if (logger$Level == Logger$Level.ERROR) {
            return Level.ERROR;
        }
        if (logger$Level == Logger$Level.FATAL) {
            return Level.FATAL;
        }
        return Level.ALL;
    }
}

