/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.time;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ProposedTimestamp
implements AutoCloseable {
    public static void blockUntil(Iterable iterable, Duration duration) {
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 + duration.toMillis();
        while (true) {
            long l4;
            if ((l4 = l3 - l2) < 0L) {
                throw new TimeoutException();
            }
            ((ProposedTimestamp)iterator.next()).blockUntil(Duration.ofMillis(l4));
            if (!iterator.hasNext()) break;
            l2 = System.currentTimeMillis();
        }
    }

    public abstract long read(TimeUnit var1);

    public abstract void blockUntil(Duration var1);

    public long millis() {
        return this.read(TimeUnit.MILLISECONDS);
    }

    public long micros() {
        return this.read(TimeUnit.MICROSECONDS);
    }

    public Instant instant() {
        long l2 = this.micros();
        long l3 = l2 / 1000000L;
        long l4 = l2 % 1000000L * 1000L;
        return Instant.ofEpochSecond(l3, l4);
    }

    public Timestamp timestamp() {
        return Timestamp.from(this.instant());
    }

    public Date date() {
        return new Date(this.millis());
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.instant().toString();
    }
}

