/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.sha1;

import java.security.MessageDigest;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.sha1.SHA1;

class SHA1Native
extends SHA1 {
    private final MessageDigest md = Constants.newMessageDigest();

    SHA1Native() {
    }

    @Override
    public void update(byte by) {
        this.md.update(by);
    }

    @Override
    public void update(byte[] byArray) {
        this.md.update(byArray);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.md.update(byArray, n2, n3);
    }

    @Override
    public byte[] digest() {
        return this.md.digest();
    }

    @Override
    public ObjectId toObjectId() {
        return ObjectId.fromRaw(this.md.digest());
    }

    @Override
    public void digest(MutableObjectId mutableObjectId) {
        mutableObjectId.fromRaw(this.md.digest());
    }

    @Override
    public SHA1 reset() {
        this.md.reset();
        return this;
    }

    @Override
    public SHA1 setDetectCollision(boolean bl2) {
        return this;
    }

    @Override
    public boolean hasCollision() {
        return false;
    }
}

