/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.sha1;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.sha1.SHA1;
import org.eclipse.jgit.util.sha1.SHA1Java$State;
import org.eclipse.jgit.util.sha1.Sha1CollisionException;
import org.eclipse.jgit.util.sha1.UbcCheck;
import org.eclipse.jgit.util.sha1.UbcCheck$DvInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SHA1Java
extends SHA1 {
    private static final Logger LOG = LoggerFactory.getLogger(SHA1Java.class);
    private static final boolean DETECT_COLLISIONS;
    private final SHA1Java$State h = new SHA1Java$State(null);
    private final int[] w = new int[80];
    private final byte[] buffer = new byte[64];
    private long length;
    private boolean detectCollision = DETECT_COLLISIONS;
    private boolean foundCollision;
    private final int[] w2 = new int[80];
    private final SHA1Java$State state58 = new SHA1Java$State(null);
    private final SHA1Java$State state65 = new SHA1Java$State(null);
    private final SHA1Java$State hIn = new SHA1Java$State(null);
    private final SHA1Java$State hTmp = new SHA1Java$State(null);

    SHA1Java() {
        this.h.init();
    }

    @Override
    public SHA1 setDetectCollision(boolean bl2) {
        this.detectCollision = bl2;
        return this;
    }

    @Override
    public void update(byte by) {
        int n2 = (int)(this.length & 0x3FL);
        ++this.length;
        this.buffer[n2] = by;
        if (n2 == 63) {
            this.compress(this.buffer, 0);
        }
    }

    @Override
    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        int n4 = (int)(this.length & 0x3FL);
        this.length += (long)n3;
        if (n4 > 0) {
            int n5 = Math.min(64 - n4, n3);
            System.arraycopy(byArray, n2, this.buffer, n4, n5);
            n2 += n5;
            n3 -= n5;
            if (n4 + n5 < 64) {
                return;
            }
            this.compress(this.buffer, 0);
        }
        while (n3 >= 64) {
            this.compress(byArray, n2);
            n2 += 64;
            n3 -= 64;
        }
        if (n3 > 0) {
            System.arraycopy(byArray, n2, this.buffer, 0, n3);
        }
    }

    private void compress(byte[] byArray, int n2) {
        int n3;
        this.initBlock(byArray, n2);
        this.compress();
        for (int i2 = this.detectCollision ? UbcCheck.check(this.w) : 0; i2 != 0; i2 &= ~(1 << n3)) {
            n3 = Integer.numberOfTrailingZeros(Integer.lowestOneBit(i2));
            UbcCheck$DvInfo ubcCheck$DvInfo = UbcCheck.DV[n3];
            for (int i3 = 0; i3 < 80; ++i3) {
                this.w2[i3] = this.w[i3] ^ ubcCheck$DvInfo.dm[i3];
            }
            this.recompress(ubcCheck$DvInfo.testt);
            if (!SHA1Java.eq(this.hTmp, this.h)) continue;
            this.foundCollision = true;
            break;
        }
    }

    private void initBlock(byte[] byArray, int n2) {
        int n3;
        for (n3 = 0; n3 < 16; ++n3) {
            this.w[n3] = NB.decodeInt32(byArray, n2 + (n3 << 2));
        }
        for (n3 = 16; n3 < 80; ++n3) {
            int n4 = this.w[n3 - 3] ^ this.w[n3 - 8] ^ this.w[n3 - 14] ^ this.w[n3 - 16];
            this.w[n3] = Integer.rotateLeft(n4, 1);
        }
    }

    private void compress() {
        int n2 = this.h.a;
        int n3 = this.h.b;
        int n4 = this.h.c;
        int n5 = this.h.d;
        int n6 = this.h.e;
        n6 += SHA1Java.s1(n2, n3, n4, n5, this.w[0]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s1(n6, n2, n3, n4, this.w[1]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s1(n5, n6, n2, n3, this.w[2]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s1(n4, n5, n6, n2, this.w[3]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s1(n3, n4, n5, n6, this.w[4]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s1(n2, n3, n4, n5, this.w[5]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s1(n6, n2, n3, n4, this.w[6]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s1(n5, n6, n2, n3, this.w[7]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s1(n4, n5, n6, n2, this.w[8]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s1(n3, n4, n5, n6, this.w[9]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s1(n2, n3, n4, n5, this.w[10]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s1(n6, n2, n3, n4, this.w[11]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s1(n5, n6, n2, n3, this.w[12]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s1(n4, n5, n6, n2, this.w[13]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s1(n3, n4, n5, n6, this.w[14]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s1(n2, n3, n4, n5, this.w[15]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s1(n6, n2, n3, n4, this.w[16]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s1(n5, n6, n2, n3, this.w[17]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s1(n4, n5, n6, n2, this.w[18]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s1(n3, n4, n5, n6, this.w[19]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s2(n2, n3, n4, n5, this.w[20]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s2(n6, n2, n3, n4, this.w[21]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s2(n5, n6, n2, n3, this.w[22]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s2(n4, n5, n6, n2, this.w[23]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s2(n3, n4, n5, n6, this.w[24]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s2(n2, n3, n4, n5, this.w[25]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s2(n6, n2, n3, n4, this.w[26]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s2(n5, n6, n2, n3, this.w[27]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s2(n4, n5, n6, n2, this.w[28]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s2(n3, n4, n5, n6, this.w[29]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s2(n2, n3, n4, n5, this.w[30]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s2(n6, n2, n3, n4, this.w[31]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s2(n5, n6, n2, n3, this.w[32]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s2(n4, n5, n6, n2, this.w[33]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s2(n3, n4, n5, n6, this.w[34]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s2(n2, n3, n4, n5, this.w[35]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s2(n6, n2, n3, n4, this.w[36]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s2(n5, n6, n2, n3, this.w[37]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s2(n4, n5, n6, n2, this.w[38]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s2(n3, n4, n5, n6, this.w[39]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s3(n2, n3, n4, n5, this.w[40]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s3(n6, n2, n3, n4, this.w[41]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s3(n5, n6, n2, n3, this.w[42]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s3(n4, n5, n6, n2, this.w[43]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s3(n3, n4, n5, n6, this.w[44]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s3(n2, n3, n4, n5, this.w[45]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s3(n6, n2, n3, n4, this.w[46]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s3(n5, n6, n2, n3, this.w[47]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s3(n4, n5, n6, n2, this.w[48]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s3(n3, n4, n5, n6, this.w[49]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s3(n2, n3, n4, n5, this.w[50]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s3(n6, n2, n3, n4, this.w[51]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s3(n5, n6, n2, n3, this.w[52]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s3(n4, n5, n6, n2, this.w[53]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s3(n3, n4, n5, n6, this.w[54]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s3(n2, n3, n4, n5, this.w[55]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s3(n6, n2, n3, n4, this.w[56]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s3(n5, n6, n2, n3, this.w[57]);
        n6 = Integer.rotateLeft(n6, 30);
        this.state58.save(n2, n3, n4, n5, n6);
        n3 += SHA1Java.s3(n4, n5, n6, n2, this.w[58]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s3(n3, n4, n5, n6, this.w[59]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s4(n2, n3, n4, n5, this.w[60]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s4(n6, n2, n3, n4, this.w[61]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s4(n5, n6, n2, n3, this.w[62]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s4(n4, n5, n6, n2, this.w[63]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s4(n3, n4, n5, n6, this.w[64]);
        n4 = Integer.rotateLeft(n4, 30);
        this.state65.save(n2, n3, n4, n5, n6);
        n6 += SHA1Java.s4(n2, n3, n4, n5, this.w[65]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s4(n6, n2, n3, n4, this.w[66]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s4(n5, n6, n2, n3, this.w[67]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s4(n4, n5, n6, n2, this.w[68]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s4(n3, n4, n5, n6, this.w[69]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s4(n2, n3, n4, n5, this.w[70]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s4(n6, n2, n3, n4, this.w[71]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s4(n5, n6, n2, n3, this.w[72]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s4(n4, n5, n6, n2, this.w[73]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s4(n3, n4, n5, n6, this.w[74]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s4(n2, n3, n4, n5, this.w[75]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s4(n6, n2, n3, n4, this.w[76]);
        n2 = Integer.rotateLeft(n2, 30);
        n4 += SHA1Java.s4(n5, n6, n2, n3, this.w[77]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s4(n4, n5, n6, n2, this.w[78]);
        n5 = Integer.rotateLeft(n5, 30);
        n2 += SHA1Java.s4(n3, n4, n5, n6, this.w[79]);
        n4 = Integer.rotateLeft(n4, 30);
        this.h.save(this.h.a + n2, this.h.b + n3, this.h.c + n4, this.h.d + n5, this.h.e + n6);
    }

    private void recompress(int n2) {
        SHA1Java$State sHA1Java$State;
        switch (n2) {
            case 58: {
                sHA1Java$State = this.state58;
                break;
            }
            case 65: {
                sHA1Java$State = this.state65;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int n3 = sHA1Java$State.a;
        int n4 = sHA1Java$State.b;
        int n5 = sHA1Java$State.c;
        int n6 = sHA1Java$State.d;
        int n7 = sHA1Java$State.e;
        if (n2 == 65) {
            n5 = Integer.rotateRight(n5, 30);
            n3 -= SHA1Java.s4(n4, n5, n6, n7, this.w2[64]);
            n6 = Integer.rotateRight(n6, 30);
            n4 -= SHA1Java.s4(n5, n6, n7, n3, this.w2[63]);
            n7 = Integer.rotateRight(n7, 30);
            n5 -= SHA1Java.s4(n6, n7, n3, n4, this.w2[62]);
            n3 = Integer.rotateRight(n3, 30);
            n6 -= SHA1Java.s4(n7, n3, n4, n5, this.w2[61]);
            n4 = Integer.rotateRight(n4, 30);
            n7 -= SHA1Java.s4(n3, n4, n5, n6, this.w2[60]);
            n5 = Integer.rotateRight(n5, 30);
            n3 -= SHA1Java.s3(n4, n5, n6, n7, this.w2[59]);
            n6 = Integer.rotateRight(n6, 30);
            n4 -= SHA1Java.s3(n5, n6, n7, n3, this.w2[58]);
        }
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s3(n6, n7, n3, n4, this.w2[57]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s3(n7, n3, n4, n5, this.w2[56]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s3(n3, n4, n5, n6, this.w2[55]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s3(n4, n5, n6, n7, this.w2[54]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s3(n5, n6, n7, n3, this.w2[53]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s3(n6, n7, n3, n4, this.w2[52]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s3(n7, n3, n4, n5, this.w2[51]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s3(n3, n4, n5, n6, this.w2[50]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s3(n4, n5, n6, n7, this.w2[49]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s3(n5, n6, n7, n3, this.w2[48]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s3(n6, n7, n3, n4, this.w2[47]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s3(n7, n3, n4, n5, this.w2[46]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s3(n3, n4, n5, n6, this.w2[45]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s3(n4, n5, n6, n7, this.w2[44]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s3(n5, n6, n7, n3, this.w2[43]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s3(n6, n7, n3, n4, this.w2[42]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s3(n7, n3, n4, n5, this.w2[41]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s3(n3, n4, n5, n6, this.w2[40]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s2(n4, n5, n6, n7, this.w2[39]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s2(n5, n6, n7, n3, this.w2[38]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s2(n6, n7, n3, n4, this.w2[37]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s2(n7, n3, n4, n5, this.w2[36]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s2(n3, n4, n5, n6, this.w2[35]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s2(n4, n5, n6, n7, this.w2[34]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s2(n5, n6, n7, n3, this.w2[33]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s2(n6, n7, n3, n4, this.w2[32]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s2(n7, n3, n4, n5, this.w2[31]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s2(n3, n4, n5, n6, this.w2[30]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s2(n4, n5, n6, n7, this.w2[29]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s2(n5, n6, n7, n3, this.w2[28]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s2(n6, n7, n3, n4, this.w2[27]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s2(n7, n3, n4, n5, this.w2[26]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s2(n3, n4, n5, n6, this.w2[25]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s2(n4, n5, n6, n7, this.w2[24]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s2(n5, n6, n7, n3, this.w2[23]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s2(n6, n7, n3, n4, this.w2[22]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s2(n7, n3, n4, n5, this.w2[21]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s2(n3, n4, n5, n6, this.w2[20]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s1(n4, n5, n6, n7, this.w2[19]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s1(n5, n6, n7, n3, this.w2[18]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s1(n6, n7, n3, n4, this.w2[17]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s1(n7, n3, n4, n5, this.w2[16]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s1(n3, n4, n5, n6, this.w2[15]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s1(n4, n5, n6, n7, this.w2[14]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s1(n5, n6, n7, n3, this.w2[13]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s1(n6, n7, n3, n4, this.w2[12]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s1(n7, n3, n4, n5, this.w2[11]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s1(n3, n4, n5, n6, this.w2[10]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s1(n4, n5, n6, n7, this.w2[9]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s1(n5, n6, n7, n3, this.w2[8]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s1(n6, n7, n3, n4, this.w2[7]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s1(n7, n3, n4, n5, this.w2[6]);
        n4 = Integer.rotateRight(n4, 30);
        n7 -= SHA1Java.s1(n3, n4, n5, n6, this.w2[5]);
        n5 = Integer.rotateRight(n5, 30);
        n3 -= SHA1Java.s1(n4, n5, n6, n7, this.w2[4]);
        n6 = Integer.rotateRight(n6, 30);
        n4 -= SHA1Java.s1(n5, n6, n7, n3, this.w2[3]);
        n7 = Integer.rotateRight(n7, 30);
        n5 -= SHA1Java.s1(n6, n7, n3, n4, this.w2[2]);
        n3 = Integer.rotateRight(n3, 30);
        n6 -= SHA1Java.s1(n7, n3, n4, n5, this.w2[1]);
        n4 = Integer.rotateRight(n4, 30);
        this.hIn.save(n3, n4, n5, n6, n7 -= SHA1Java.s1(n3, n4, n5, n6, this.w2[0]));
        n3 = sHA1Java$State.a;
        n4 = sHA1Java$State.b;
        n5 = sHA1Java$State.c;
        n6 = sHA1Java$State.d;
        n7 = sHA1Java$State.e;
        if (n2 == 58) {
            n4 += SHA1Java.s3(n5, n6, n7, n3, this.w2[58]);
            n6 = Integer.rotateLeft(n6, 30);
            n3 += SHA1Java.s3(n4, n5, n6, n7, this.w2[59]);
            n5 = Integer.rotateLeft(n5, 30);
            n7 += SHA1Java.s4(n3, n4, n5, n6, this.w2[60]);
            n4 = Integer.rotateLeft(n4, 30);
            n6 += SHA1Java.s4(n7, n3, n4, n5, this.w2[61]);
            n3 = Integer.rotateLeft(n3, 30);
            n5 += SHA1Java.s4(n6, n7, n3, n4, this.w2[62]);
            n7 = Integer.rotateLeft(n7, 30);
            n4 += SHA1Java.s4(n5, n6, n7, n3, this.w2[63]);
            n6 = Integer.rotateLeft(n6, 30);
            n3 += SHA1Java.s4(n4, n5, n6, n7, this.w2[64]);
            n5 = Integer.rotateLeft(n5, 30);
        }
        n7 += SHA1Java.s4(n3, n4, n5, n6, this.w2[65]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s4(n7, n3, n4, n5, this.w2[66]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s4(n6, n7, n3, n4, this.w2[67]);
        n7 = Integer.rotateLeft(n7, 30);
        n4 += SHA1Java.s4(n5, n6, n7, n3, this.w2[68]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s4(n4, n5, n6, n7, this.w2[69]);
        n5 = Integer.rotateLeft(n5, 30);
        n7 += SHA1Java.s4(n3, n4, n5, n6, this.w2[70]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s4(n7, n3, n4, n5, this.w2[71]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s4(n6, n7, n3, n4, this.w2[72]);
        n7 = Integer.rotateLeft(n7, 30);
        n4 += SHA1Java.s4(n5, n6, n7, n3, this.w2[73]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s4(n4, n5, n6, n7, this.w2[74]);
        n5 = Integer.rotateLeft(n5, 30);
        n7 += SHA1Java.s4(n3, n4, n5, n6, this.w2[75]);
        n4 = Integer.rotateLeft(n4, 30);
        n6 += SHA1Java.s4(n7, n3, n4, n5, this.w2[76]);
        n3 = Integer.rotateLeft(n3, 30);
        n5 += SHA1Java.s4(n6, n7, n3, n4, this.w2[77]);
        n7 = Integer.rotateLeft(n7, 30);
        n4 += SHA1Java.s4(n5, n6, n7, n3, this.w2[78]);
        n6 = Integer.rotateLeft(n6, 30);
        n3 += SHA1Java.s4(n4, n5, n6, n7, this.w2[79]);
        n5 = Integer.rotateLeft(n5, 30);
        this.hTmp.save(this.hIn.a + n3, this.hIn.b + n4, this.hIn.c + n5, this.hIn.d + n6, this.hIn.e + n7);
    }

    private static int s1(int n2, int n3, int n4, int n5, int n6) {
        return Integer.rotateLeft(n2, 5) + (n3 & n4 | ~n3 & n5) + 1518500249 + n6;
    }

    private static int s2(int n2, int n3, int n4, int n5, int n6) {
        return Integer.rotateLeft(n2, 5) + (n3 ^ n4 ^ n5) + 1859775393 + n6;
    }

    private static int s3(int n2, int n3, int n4, int n5, int n6) {
        return Integer.rotateLeft(n2, 5) + (n3 & n4 | n3 & n5 | n4 & n5) + -1894007588 + n6;
    }

    private static int s4(int n2, int n3, int n4, int n5, int n6) {
        return Integer.rotateLeft(n2, 5) + (n3 ^ n4 ^ n5) + -899497514 + n6;
    }

    private static boolean eq(SHA1Java$State sHA1Java$State, SHA1Java$State sHA1Java$State2) {
        return sHA1Java$State.a == sHA1Java$State2.a && sHA1Java$State.b == sHA1Java$State2.b && sHA1Java$State.c == sHA1Java$State2.c && sHA1Java$State.d == sHA1Java$State2.d && sHA1Java$State.e == sHA1Java$State2.e;
    }

    private void finish() {
        int n2 = (int)(this.length & 0x3FL);
        if (n2 > 55) {
            this.buffer[n2++] = -128;
            Arrays.fill(this.buffer, n2, 64, (byte)0);
            this.compress(this.buffer, 0);
            Arrays.fill(this.buffer, 0, 56, (byte)0);
        } else {
            this.buffer[n2++] = -128;
            Arrays.fill(this.buffer, n2, 56, (byte)0);
        }
        NB.encodeInt32(this.buffer, 56, (int)(this.length >>> 29));
        NB.encodeInt32(this.buffer, 60, (int)(this.length << 3));
        this.compress(this.buffer, 0);
        if (this.foundCollision) {
            ObjectId objectId = this.h.toObjectId();
            LOG.warn(MessageFormat.format(JGitText.get().sha1CollisionDetected, objectId.name()));
            throw new Sha1CollisionException(objectId);
        }
    }

    @Override
    public byte[] digest() {
        this.finish();
        byte[] byArray = new byte[20];
        NB.encodeInt32(byArray, 0, this.h.a);
        NB.encodeInt32(byArray, 4, this.h.b);
        NB.encodeInt32(byArray, 8, this.h.c);
        NB.encodeInt32(byArray, 12, this.h.d);
        NB.encodeInt32(byArray, 16, this.h.e);
        return byArray;
    }

    @Override
    public ObjectId toObjectId() {
        this.finish();
        return this.h.toObjectId();
    }

    @Override
    public void digest(MutableObjectId mutableObjectId) {
        this.finish();
        mutableObjectId.set(this.h.a, this.h.b, this.h.c, this.h.d, this.h.e);
    }

    @Override
    public boolean hasCollision() {
        return this.foundCollision;
    }

    @Override
    public SHA1 reset() {
        this.h.init();
        this.length = 0L;
        this.foundCollision = false;
        return this;
    }

    static {
        SystemReader systemReader = SystemReader.getInstance();
        String string = systemReader.getProperty("org.eclipse.jgit.util.sha1.detectCollision");
        DETECT_COLLISIONS = string != null ? Boolean.parseBoolean(string) : true;
    }
}

