/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.sha1;

import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.sha1.SHA1$Sha1Implementation;
import org.eclipse.jgit.util.sha1.SHA1Java;
import org.eclipse.jgit.util.sha1.SHA1Native;

public abstract class SHA1 {
    private static final SHA1$Sha1Implementation SHA1_IMPLEMENTATION = SHA1.fromConfig();

    private static SHA1$Sha1Implementation fromConfig() {
        try {
            return (SHA1$Sha1Implementation)SystemReader.getInstance().getUserConfig().getEnum("core", null, "sha1implementation", SHA1$Sha1Implementation.JAVA);
        }
        catch (IOException | ConfigInvalidException exception) {
            return SHA1$Sha1Implementation.JAVA;
        }
    }

    private static SHA1$Sha1Implementation getImplementation() {
        String string = System.getProperty("org.eclipse.jgit.util.sha1.implementation");
        if (string == null) {
            return SHA1_IMPLEMENTATION;
        }
        if (string.equalsIgnoreCase(SHA1$Sha1Implementation.JAVA.name())) {
            return SHA1$Sha1Implementation.JAVA;
        }
        if (string.equalsIgnoreCase(SHA1$Sha1Implementation.JDKNATIVE.name())) {
            return SHA1$Sha1Implementation.JDKNATIVE;
        }
        return SHA1_IMPLEMENTATION;
    }

    public static SHA1 newInstance() {
        if (SHA1.getImplementation() == SHA1$Sha1Implementation.JDKNATIVE) {
            return new SHA1Native();
        }
        return new SHA1Java();
    }

    public abstract void update(byte var1);

    public abstract void update(byte[] var1);

    public abstract void update(byte[] var1, int var2, int var3);

    public abstract byte[] digest();

    public abstract ObjectId toObjectId();

    public abstract void digest(MutableObjectId var1);

    public abstract SHA1 reset();

    public abstract SHA1 setDetectCollision(boolean var1);

    public abstract boolean hasCollision();
}

