/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jgit.util.io.UnionInputStream$1;

public class UnionInputStream
extends InputStream {
    private static final InputStream EOF = new UnionInputStream$1();
    private final LinkedList streams = new LinkedList();

    public UnionInputStream() {
    }

    public UnionInputStream(InputStream ... inputStreamArray) {
        for (InputStream inputStream : inputStreamArray) {
            this.add(inputStream);
        }
    }

    private InputStream head() {
        return this.streams.isEmpty() ? EOF : (InputStream)this.streams.getFirst();
    }

    private void pop() {
        if (!this.streams.isEmpty()) {
            ((InputStream)this.streams.removeFirst()).close();
        }
    }

    public void add(InputStream inputStream) {
        this.streams.add(inputStream);
    }

    public boolean isEmpty() {
        return this.streams.isEmpty();
    }

    @Override
    public int read() {
        InputStream inputStream;
        int n2;
        while (0 > (n2 = (inputStream = this.head()).read())) {
            if (inputStream == EOF) {
                return -1;
            }
            this.pop();
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        InputStream inputStream;
        int n4;
        while (0 >= (n4 = (inputStream = this.head()).read(byArray, n2, n3))) {
            if (inputStream == EOF) {
                return -1;
            }
            this.pop();
        }
        return n4;
    }

    @Override
    public int available() {
        return this.head().available();
    }

    @Override
    public long skip(long l2) {
        long l3 = 0L;
        long l4 = l2;
        while (0L < l4) {
            InputStream inputStream = this.head();
            long l5 = inputStream.skip(l4);
            if (0L < l5) {
                l3 += l5;
                l4 -= l5;
                continue;
            }
            if (inputStream == EOF) {
                return l3;
            }
            int n2 = inputStream.read();
            if (n2 < 0) {
                this.pop();
                if (0L >= l3) continue;
                break;
            }
            ++l3;
            --l4;
        }
        return l3;
    }

    @Override
    public void close() {
        IOException iOException = null;
        Iterator iterator = this.streams.iterator();
        while (iterator.hasNext()) {
            try {
                ((InputStream)iterator.next()).close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            iterator.remove();
        }
        if (iOException != null) {
            throw iOException;
        }
    }
}

