/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.io.InterruptTimer;

public class TimeoutOutputStream
extends OutputStream {
    private final OutputStream dst;
    private final InterruptTimer myTimer;
    private int timeout;

    public TimeoutOutputStream(OutputStream outputStream, InterruptTimer interruptTimer) {
        this.dst = outputStream;
        this.myTimer = interruptTimer;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeout, n2));
        }
        this.timeout = n2;
    }

    @Override
    public void write(int n2) {
        try {
            this.beginWrite();
            this.dst.write(n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw this.writeTimedOut(interruptedIOException);
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        try {
            this.beginWrite();
            this.dst.write(byArray, n2, n3);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw this.writeTimedOut(interruptedIOException);
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public void flush() {
        try {
            this.beginWrite();
            this.dst.flush();
        }
        catch (InterruptedIOException interruptedIOException) {
            throw this.writeTimedOut(interruptedIOException);
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public void close() {
        try {
            this.beginWrite();
            this.dst.close();
        }
        catch (InterruptedIOException interruptedIOException) {
            throw this.writeTimedOut(interruptedIOException);
        }
        finally {
            this.endWrite();
        }
    }

    private void beginWrite() {
        this.myTimer.begin(this.timeout);
    }

    private void endWrite() {
        this.myTimer.end();
    }

    private InterruptedIOException writeTimedOut(InterruptedIOException interruptedIOException) {
        InterruptedIOException interruptedIOException2 = new InterruptedIOException(MessageFormat.format(JGitText.get().writeTimedOut, this.timeout));
        interruptedIOException2.initCause(interruptedIOException);
        return interruptedIOException2;
    }
}

