/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.io.InterruptTimer;

public class TimeoutInputStream
extends FilterInputStream {
    private final InterruptTimer myTimer;
    private int timeout;

    public TimeoutInputStream(InputStream inputStream, InterruptTimer interruptTimer) {
        super(inputStream);
        this.myTimer = interruptTimer;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeout, n2));
        }
        this.timeout = n2;
    }

    @Override
    public int read() {
        try {
            this.beginRead();
            int n2 = super.read();
            return n2;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw this.readTimedOut(interruptedIOException);
        }
        finally {
            this.endRead();
        }
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        try {
            this.beginRead();
            int n4 = super.read(byArray, n2, n3);
            return n4;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw this.readTimedOut(interruptedIOException);
        }
        finally {
            this.endRead();
        }
    }

    @Override
    public long skip(long l2) {
        try {
            this.beginRead();
            long l3 = super.skip(l2);
            return l3;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw this.readTimedOut(interruptedIOException);
        }
        finally {
            this.endRead();
        }
    }

    private void beginRead() {
        this.myTimer.begin(this.timeout);
    }

    private void endRead() {
        this.myTimer.end();
    }

    private InterruptedIOException readTimedOut(InterruptedIOException interruptedIOException) {
        InterruptedIOException interruptedIOException2 = new InterruptedIOException(MessageFormat.format(JGitText.get().readTimedOut, this.timeout));
        interruptedIOException2.initCause(interruptedIOException);
        return interruptedIOException2;
    }
}

