/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.Writer;
import java.security.AccessController;
import org.eclipse.jgit.util.SystemReader;

public class ThrowingPrintWriter
extends Writer {
    private final Writer out;
    private final String LF;

    public ThrowingPrintWriter(Writer writer) {
        this.out = writer;
        this.LF = AccessController.doPrivileged(() -> SystemReader.getInstance().getProperty("line.separator"));
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        this.out.write(cArray, n2, n3);
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
    }

    public void println(String string) {
        this.print(string + this.LF);
    }

    public void println() {
        this.print(this.LF);
    }

    public void print(char c2) {
        this.print(String.valueOf(c2));
    }

    public void print(int n2) {
        this.print(String.valueOf(n2));
    }

    public void print(long l2) {
        this.print(String.valueOf(l2));
    }

    public void print(short s2) {
        this.print(String.valueOf(s2));
    }

    public void format(String string, Object ... objectArray) {
        this.print(String.format(string, objectArray));
    }

    public void print(Object object) {
        this.out.write(String.valueOf(object));
    }
}

