/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends InputStream {
    private byte[] skipBuffer;
    private InputStream src;
    private OutputStream dst;

    public TeeInputStream(InputStream inputStream, OutputStream outputStream) {
        this.src = inputStream;
        this.dst = outputStream;
    }

    @Override
    public int read() {
        byte[] byArray = this.skipBuffer();
        int n2 = this.read(byArray, 0, 1);
        return n2 == 1 ? byArray[0] & 0xFF : -1;
    }

    @Override
    public long skip(long l2) {
        int n2;
        long l3 = 0L;
        byte[] byArray = this.skipBuffer();
        for (long i2 = l2; 0L < i2 && (n2 = this.src.read(byArray, 0, (int)Math.min((long)byArray.length, i2))) > 0; i2 -= (long)n2) {
            this.dst.write(byArray, 0, n2);
            l3 += (long)n2;
        }
        return l3;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.src.read(byArray, n2, n3);
        if (0 < n4) {
            this.dst.write(byArray, n2, n4);
        }
        return n4;
    }

    @Override
    public void close() {
        int n2;
        byte[] byArray = this.skipBuffer();
        while ((n2 = this.src.read(byArray)) > 0) {
            this.dst.write(byArray, 0, n2);
        }
        this.dst.close();
        this.src.close();
    }

    private byte[] skipBuffer() {
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[2048];
        }
        return this.skipBuffer;
    }
}

