/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class StreamCopyThread
extends Thread {
    private static final int BUFFER_SIZE = 1024;
    private final InputStream src;
    private final OutputStream dst;
    private volatile boolean done;
    private final Object writeLock;

    public StreamCopyThread(InputStream inputStream, OutputStream outputStream) {
        this.setName(Thread.currentThread().getName() + "-StreamCopy");
        this.src = inputStream;
        this.dst = outputStream;
        this.writeLock = new Object();
    }

    public void halt() {
        while (true) {
            this.join(250L);
            if (!this.isAlive()) break;
            this.done = true;
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            byte[] byArray = new byte[1024];
            boolean bl2 = false;
            try {
                while (true) {
                    int n2;
                    if (bl2) {
                        Object object = this.writeLock;
                        synchronized (object) {
                            boolean bl3 = Thread.interrupted();
                            this.dst.flush();
                            if (bl3) {
                                this.interrupt();
                            }
                        }
                        bl2 = false;
                    }
                    if (this.done) {
                        return;
                    }
                    try {
                        n2 = this.src.read(byArray);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        bl2 = true;
                        continue;
                    }
                    if (n2 < 0) {
                        return;
                    }
                    Object object = this.writeLock;
                    synchronized (object) {
                        boolean bl4 = Thread.interrupted();
                        this.dst.write(byArray, 0, n2);
                        if (bl4) {
                            this.interrupt();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
                return;
            }
        }
        finally {
            try {
                this.src.close();
            }
            catch (IOException iOException) {}
            try {
                this.dst.close();
            }
            catch (IOException iOException) {}
        }
    }
}

