/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.internal.JGitText;

public abstract class LimitedInputStream
extends FilterInputStream {
    private long left;
    protected final long limit;
    private long mark = -1L;

    protected LimitedInputStream(InputStream inputStream, long l2) {
        super(inputStream);
        this.left = l2;
        this.limit = l2;
    }

    @Override
    public int available() {
        return (int)Math.min((long)this.in.available(), this.left);
    }

    @Override
    public synchronized void mark(int n2) {
        this.in.mark(n2);
        this.mark = this.left;
    }

    @Override
    public int read() {
        int n2;
        if (this.left == 0L) {
            if (this.in.available() == 0) {
                return -1;
            }
            this.limitExceeded();
        }
        if ((n2 = this.in.read()) != -1) {
            --this.left;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (this.left == 0L) {
            if (this.in.available() == 0) {
                return -1;
            }
            this.limitExceeded();
        }
        if ((n4 = this.in.read(byArray, n2, n3 = (int)Math.min((long)n3, this.left))) != -1) {
            this.left -= (long)n4;
        }
        return n4;
    }

    @Override
    public synchronized void reset() {
        if (!this.in.markSupported()) {
            throw new IOException(JGitText.get().unsupportedMark);
        }
        if (this.mark == -1L) {
            throw new IOException(JGitText.get().unsetMark);
        }
        this.in.reset();
        this.left = this.mark;
    }

    @Override
    public long skip(long l2) {
        l2 = Math.min(l2, this.left);
        long l3 = this.in.skip(l2);
        this.left -= l3;
        return l3;
    }

    protected abstract void limitExceeded();
}

