/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.io.IsolatedOutputStream$NamedThreadFactory;

public class IsolatedOutputStream
extends OutputStream {
    private final OutputStream dst;
    private final ExecutorService copier;
    private Future pending;

    public IsolatedOutputStream(OutputStream outputStream) {
        this.dst = outputStream;
        this.copier = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new IsolatedOutputStream$NamedThreadFactory(null));
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)n2}, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.checkClosed();
        this.execute(() -> {
            this.dst.write(byArray, n2, n3);
            return null;
        });
    }

    @Override
    public void flush() {
        this.checkClosed();
        this.execute(() -> {
            this.dst.flush();
            return null;
        });
    }

    @Override
    public void close() {
        if (!this.copier.isShutdown()) {
            try {
                if (this.pending == null || this.tryCleanClose()) {
                    this.cleanClose();
                } else {
                    this.dirtyClose();
                }
            }
            finally {
                this.copier.shutdown();
            }
        }
    }

    private boolean tryCleanClose() {
        try {
            this.pending.get(0L, TimeUnit.MILLISECONDS);
            this.pending = null;
            return true;
        }
        catch (InterruptedException | TimeoutException exception) {
            return false;
        }
        catch (ExecutionException executionException) {
            this.pending = null;
            return true;
        }
    }

    private void cleanClose() {
        this.execute(() -> {
            this.dst.close();
            return null;
        });
    }

    private void dirtyClose() {
        Future<Void> future;
        this.pending.cancel(true);
        try {
            future = this.copier.submit(() -> {
                this.dst.close();
                return null;
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new IOException(rejectedExecutionException);
        }
        try {
            future.get(200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException exception) {
            future.cancel(true);
            throw new IOException(exception);
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException.getCause());
        }
    }

    private void checkClosed() {
        if (this.copier.isShutdown()) {
            throw new IOException(JGitText.get().closed);
        }
    }

    private void execute(Callable callable) {
        if (this.pending != null) {
            IsolatedOutputStream.checkedGet(this.pending);
        }
        try {
            this.pending = this.copier.submit(callable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new IOException(rejectedExecutionException);
        }
        IsolatedOutputStream.checkedGet(this.pending);
        this.pending = null;
    }

    private static void checkedGet(Future future) {
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            throw IsolatedOutputStream.interrupted(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException.getCause());
        }
    }

    private static InterruptedIOException interrupted(InterruptedException interruptedException) {
        InterruptedIOException interruptedIOException = new InterruptedIOException();
        interruptedIOException.initCause(interruptedException);
        return interruptedIOException;
    }
}

