/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.io.InterruptTimer$AlarmState;
import org.eclipse.jgit.util.io.InterruptTimer$AlarmThread;
import org.eclipse.jgit.util.io.InterruptTimer$AutoKiller;

public final class InterruptTimer {
    private final InterruptTimer$AlarmState state = new InterruptTimer$AlarmState();
    private final InterruptTimer$AlarmThread thread;
    final InterruptTimer$AutoKiller autoKiller = new InterruptTimer$AutoKiller(this.state);

    public InterruptTimer() {
        this("JGit-InterruptTimer");
    }

    public InterruptTimer(String string) {
        this.thread = new InterruptTimer$AlarmThread(string, this.state);
        this.thread.start();
    }

    public void begin(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeout, n2));
        }
        Thread.interrupted();
        this.state.begin(n2);
    }

    public void end() {
        this.state.end();
    }

    public void terminate() {
        this.state.terminate();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

