/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import org.eclipse.jgit.internal.JGitText;

final class InterruptTimer$AlarmState
implements Runnable {
    private Thread callingThread = Thread.currentThread();
    private long deadline;
    private boolean terminated;

    InterruptTimer$AlarmState() {
    }

    @Override
    public synchronized void run() {
        while (!this.terminated && this.callingThread.isAlive()) {
            try {
                if (0L < this.deadline) {
                    long l2 = this.deadline - InterruptTimer$AlarmState.now();
                    if (l2 <= 0L) {
                        this.deadline = 0L;
                        this.callingThread.interrupt();
                        continue;
                    }
                    this.wait(l2);
                    continue;
                }
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void begin(int n2) {
        if (this.terminated) {
            throw new IllegalStateException(JGitText.get().timerAlreadyTerminated);
        }
        this.callingThread = Thread.currentThread();
        this.deadline = InterruptTimer$AlarmState.now() + (long)n2;
        this.notifyAll();
    }

    synchronized void end() {
        if (0L == this.deadline) {
            Thread.interrupted();
        } else {
            this.deadline = 0L;
        }
        this.notifyAll();
    }

    synchronized void terminate() {
        if (!this.terminated) {
            this.deadline = 0L;
            this.terminated = true;
            this.notifyAll();
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }
}

