/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.lib.CoreConfig$EolStreamType;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.AutoCRLFInputStream;
import org.eclipse.jgit.util.io.AutoCRLFOutputStream;
import org.eclipse.jgit.util.io.AutoLFInputStream;
import org.eclipse.jgit.util.io.AutoLFInputStream$StreamFlag;
import org.eclipse.jgit.util.io.AutoLFOutputStream;

public final class EolStreamTypeUtil {
    private EolStreamTypeUtil() {
    }

    public static CoreConfig$EolStreamType detectStreamType(TreeWalk$OperationType treeWalk$OperationType, WorkingTreeOptions workingTreeOptions, Attributes attributes) {
        switch (treeWalk$OperationType) {
            case CHECKIN_OP: {
                return EolStreamTypeUtil.checkInStreamType(workingTreeOptions, attributes);
            }
            case CHECKOUT_OP: {
                return EolStreamTypeUtil.checkOutStreamType(workingTreeOptions, attributes);
            }
        }
        throw new IllegalArgumentException("unknown OperationType " + (Object)((Object)treeWalk$OperationType));
    }

    public static InputStream wrapInputStream(InputStream inputStream, CoreConfig$EolStreamType coreConfig$EolStreamType) {
        return EolStreamTypeUtil.wrapInputStream(inputStream, coreConfig$EolStreamType, false);
    }

    public static InputStream wrapInputStream(InputStream inputStream, CoreConfig$EolStreamType coreConfig$EolStreamType, boolean bl2) {
        switch (coreConfig$EolStreamType) {
            case TEXT_CRLF: {
                return new AutoCRLFInputStream(inputStream, false);
            }
            case TEXT_LF: {
                return AutoLFInputStream.create(inputStream, new AutoLFInputStream$StreamFlag[0]);
            }
            case AUTO_CRLF: {
                return new AutoCRLFInputStream(inputStream, true);
            }
            case AUTO_LF: {
                EnumSet<AutoLFInputStream$StreamFlag> enumSet = bl2 ? EnumSet.of(AutoLFInputStream$StreamFlag.DETECT_BINARY, AutoLFInputStream$StreamFlag.FOR_CHECKOUT) : EnumSet.of(AutoLFInputStream$StreamFlag.DETECT_BINARY);
                return new AutoLFInputStream(inputStream, enumSet);
            }
        }
        return inputStream;
    }

    public static OutputStream wrapOutputStream(OutputStream outputStream, CoreConfig$EolStreamType coreConfig$EolStreamType) {
        switch (coreConfig$EolStreamType) {
            case TEXT_CRLF: {
                return new AutoCRLFOutputStream(outputStream, false);
            }
            case AUTO_CRLF: {
                return new AutoCRLFOutputStream(outputStream, true);
            }
            case TEXT_LF: {
                return new AutoLFOutputStream(outputStream, false);
            }
            case AUTO_LF: {
                return new AutoLFOutputStream(outputStream, true);
            }
        }
        return outputStream;
    }

    private static CoreConfig$EolStreamType checkInStreamType(WorkingTreeOptions workingTreeOptions, Attributes attributes) {
        if (attributes.isUnset("text")) {
            return CoreConfig$EolStreamType.DIRECT;
        }
        if (attributes.isSet("crlf")) {
            return CoreConfig$EolStreamType.TEXT_LF;
        }
        if (attributes.isUnset("crlf")) {
            return CoreConfig$EolStreamType.DIRECT;
        }
        if ("input".equals(attributes.getValue("crlf"))) {
            return CoreConfig$EolStreamType.TEXT_LF;
        }
        if ("auto".equals(attributes.getValue("text"))) {
            return CoreConfig$EolStreamType.AUTO_LF;
        }
        String string = attributes.getValue("eol");
        if (string != null) {
            return CoreConfig$EolStreamType.TEXT_LF;
        }
        if (attributes.isSet("text")) {
            return CoreConfig$EolStreamType.TEXT_LF;
        }
        switch (workingTreeOptions.getAutoCRLF()) {
            case TRUE: 
            case INPUT: {
                return CoreConfig$EolStreamType.AUTO_LF;
            }
            case FALSE: {
                return CoreConfig$EolStreamType.DIRECT;
            }
        }
        return CoreConfig$EolStreamType.DIRECT;
    }

    private static CoreConfig$EolStreamType getOutputFormat(WorkingTreeOptions workingTreeOptions) {
        switch (workingTreeOptions.getAutoCRLF()) {
            case TRUE: {
                return CoreConfig$EolStreamType.TEXT_CRLF;
            }
            case INPUT: {
                return CoreConfig$EolStreamType.DIRECT;
            }
        }
        switch (workingTreeOptions.getEOL()) {
            case CRLF: {
                return CoreConfig$EolStreamType.TEXT_CRLF;
            }
            case NATIVE: {
                if (SystemReader.getInstance().isWindows()) {
                    return CoreConfig$EolStreamType.TEXT_CRLF;
                }
                return CoreConfig$EolStreamType.TEXT_LF;
            }
        }
        return CoreConfig$EolStreamType.DIRECT;
    }

    private static CoreConfig$EolStreamType checkOutStreamType(WorkingTreeOptions workingTreeOptions, Attributes attributes) {
        if (attributes.isUnset("text")) {
            return CoreConfig$EolStreamType.DIRECT;
        }
        if (attributes.isSet("crlf")) {
            return EolStreamTypeUtil.getOutputFormat(workingTreeOptions);
        }
        if (attributes.isUnset("crlf")) {
            return CoreConfig$EolStreamType.DIRECT;
        }
        if ("input".equals(attributes.getValue("crlf"))) {
            return CoreConfig$EolStreamType.DIRECT;
        }
        String string = attributes.getValue("eol");
        if (string != null) {
            if ("crlf".equals(string)) {
                if ("auto".equals(attributes.getValue("text"))) {
                    return CoreConfig$EolStreamType.AUTO_CRLF;
                }
                return CoreConfig$EolStreamType.TEXT_CRLF;
            }
            if ("lf".equals(string)) {
                return CoreConfig$EolStreamType.DIRECT;
            }
        }
        if (attributes.isSet("text")) {
            return EolStreamTypeUtil.getOutputFormat(workingTreeOptions);
        }
        if ("auto".equals(attributes.getValue("text"))) {
            CoreConfig$EolStreamType coreConfig$EolStreamType = EolStreamTypeUtil.getOutputFormat(workingTreeOptions);
            switch (coreConfig$EolStreamType) {
                case TEXT_CRLF: {
                    return CoreConfig$EolStreamType.AUTO_CRLF;
                }
                case TEXT_LF: {
                    return CoreConfig$EolStreamType.AUTO_LF;
                }
            }
            return coreConfig$EolStreamType;
        }
        switch (workingTreeOptions.getAutoCRLF()) {
            case TRUE: {
                return CoreConfig$EolStreamType.AUTO_CRLF;
            }
        }
        return CoreConfig$EolStreamType.DIRECT;
    }
}

