/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.OutputStream;
import org.eclipse.jgit.util.Base85;

public class BinaryHunkOutputStream
extends OutputStream {
    private static final int MAX_BYTES = 52;
    private final OutputStream out;
    private final byte[] buffer = new byte[52];
    private int pos;

    public BinaryHunkOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public void close() {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() {
        if (this.pos > 0) {
            this.encode(this.buffer, 0, this.pos);
            this.pos = 0;
        }
        this.out.flush();
    }

    @Override
    public void write(int n2) {
        this.buffer[this.pos++] = (byte)n2;
        if (this.pos == this.buffer.length) {
            this.encode(this.buffer, 0, this.pos);
            this.pos = 0;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        int n4 = n3;
        int n5 = n2;
        if (this.pos > 0) {
            int n6 = Math.min(n4, this.buffer.length - this.pos);
            System.arraycopy(byArray, n5, this.buffer, this.pos, n6);
            n5 += n6;
            this.pos += n6;
            n4 -= n6;
            if (this.pos == this.buffer.length) {
                this.encode(this.buffer, 0, this.pos);
                this.pos = 0;
            }
            if (n4 == 0) {
                return;
            }
        }
        while (n4 >= 52) {
            this.encode(byArray, n5, 52);
            n4 -= 52;
            n5 += 52;
        }
        if (n4 > 0) {
            System.arraycopy(byArray, n5, this.buffer, 0, n4);
            this.pos = n4;
        }
    }

    private void encode(byte[] byArray, int n2, int n3) {
        if (n3 <= 26) {
            this.out.write(65 + n3 - 1);
        } else {
            this.out.write(97 + n3 - 27);
        }
        this.out.write(Base85.encode(byArray, n2, n3));
        this.out.write(10);
    }
}

